/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import java.util.Collections;
import javax.measure.quantity.Length;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.Identifiers;
import org.geotoolkit.measure.Units;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.parameter.DefaultParameterDescriptor;
import org.geotoolkit.parameter.Parameters;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.datum.BursaWolfParameters;
import org.geotoolkit.referencing.operation.MathTransformProvider;
import org.geotoolkit.referencing.operation.provider.IdentifierCode;
import org.geotoolkit.referencing.operation.transform.ConcatenatedTransform;
import org.geotoolkit.referencing.operation.transform.GeocentricAffineTransform;
import org.geotoolkit.referencing.operation.transform.GeocentricTransform;
import org.geotoolkit.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.Transformation;

@Immutable
public class PositionVector7Param
extends MathTransformProvider {
    private static final long serialVersionUID = -6398226638364450229L;
    static final int DEFAULT_DIMENSION = 2;
    private static final double MAX_ROTATION = 648000.0;
    public static final ParameterDescriptor<Integer> SRC_DIM = DefaultParameterDescriptor.create(Collections.singletonMap("name", new NamedIdentifier(Citations.GEOTOOLKIT, "src_dim")), 2, 2, 3, false);
    public static final ParameterDescriptor<Integer> TGT_DIM = DefaultParameterDescriptor.create(Collections.singletonMap("name", new NamedIdentifier(Citations.GEOTOOLKIT, "tgt_dim")), 2, 2, 3, false);
    public static final ParameterDescriptor<Double> SRC_SEMI_MAJOR = Identifiers.createOptionalDescriptor((ReferenceIdentifier[])new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "src_semi_major")}, Double.NaN, 0.0, Double.POSITIVE_INFINITY, SI.METRE);
    public static final ParameterDescriptor<Double> SRC_SEMI_MINOR = Identifiers.createOptionalDescriptor((ReferenceIdentifier[])new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "src_semi_minor")}, Double.NaN, 0.0, Double.POSITIVE_INFINITY, SI.METRE);
    public static final ParameterDescriptor<Double> TGT_SEMI_MAJOR = Identifiers.createOptionalDescriptor((ReferenceIdentifier[])new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "tgt_semi_major")}, Double.NaN, 0.0, Double.POSITIVE_INFINITY, SI.METRE);
    public static final ParameterDescriptor<Double> TGT_SEMI_MINOR = Identifiers.createOptionalDescriptor((ReferenceIdentifier[])new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "tgt_semi_minor")}, Double.NaN, 0.0, Double.POSITIVE_INFINITY, SI.METRE);
    public static final ParameterDescriptor<Double> DX = Identifiers.createDescriptor((ReferenceIdentifier[])new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "dx"), new NamedIdentifier(Citations.EPSG, "X-axis translation")}, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, SI.METRE);
    public static final ParameterDescriptor<Double> DY = Identifiers.createDescriptor((ReferenceIdentifier[])new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "dy"), new NamedIdentifier(Citations.EPSG, "Y-axis translation")}, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, SI.METRE);
    public static final ParameterDescriptor<Double> DZ = Identifiers.createDescriptor((ReferenceIdentifier[])new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "dz"), new NamedIdentifier(Citations.EPSG, "Z-axis translation")}, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, SI.METRE);
    public static final ParameterDescriptor<Double> EX = Identifiers.createDescriptor((ReferenceIdentifier[])new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "ex"), new NamedIdentifier(Citations.EPSG, "X-axis rotation")}, 0.0, -648000.0, 648000.0, NonSI.SECOND_ANGLE);
    public static final ParameterDescriptor<Double> EY = Identifiers.createDescriptor((ReferenceIdentifier[])new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "ey"), new NamedIdentifier(Citations.EPSG, "Y-axis rotation")}, 0.0, -648000.0, 648000.0, NonSI.SECOND_ANGLE);
    public static final ParameterDescriptor<Double> EZ = Identifiers.createDescriptor((ReferenceIdentifier[])new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "ez"), new NamedIdentifier(Citations.EPSG, "Z-axis rotation")}, 0.0, -648000.0, 648000.0, NonSI.SECOND_ANGLE);
    public static final ParameterDescriptor<Double> PPM = Identifiers.createDescriptor((ReferenceIdentifier[])new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "ppm"), new NamedIdentifier(Citations.EPSG, "Scale difference")}, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Units.PPM);
    public static final ParameterDescriptorGroup PARAMETERS = PositionVector7Param.createDescriptorGroup(9606, "Position Vector transformation (geog2D domain)", "Position Vector 7-param. transformation");

    static ParameterDescriptorGroup createDescriptorGroup(int n, String string, String string2) {
        return Identifiers.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier(Citations.EPSG, string), new NamedIdentifier(Citations.EPSG, string2), new NamedIdentifier(Citations.EPSG, "Bursa-Wolf"), new IdentifierCode(Citations.EPSG, n)}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{DX, DY, DZ, EX, EY, EZ, PPM, SRC_SEMI_MAJOR, SRC_SEMI_MINOR, TGT_SEMI_MAJOR, TGT_SEMI_MINOR, SRC_DIM, TGT_DIM});
    }

    public PositionVector7Param() {
        this(PARAMETERS);
    }

    PositionVector7Param(ParameterDescriptorGroup parameterDescriptorGroup) {
        super(3, 3, parameterDescriptorGroup);
    }

    public Class<Transformation> getOperationType() {
        return Transformation.class;
    }

    @Override
    protected MathTransform createMathTransform(ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        BursaWolfParameters bursaWolfParameters = new BursaWolfParameters(null);
        this.fill(bursaWolfParameters, parameterValueGroup);
        return PositionVector7Param.concatenate(PositionVector7Param.concatenate(new GeocentricAffineTransform(bursaWolfParameters, this.getParameters()), parameterValueGroup, SRC_SEMI_MAJOR, SRC_SEMI_MINOR, SRC_DIM), parameterValueGroup, TGT_SEMI_MAJOR, TGT_SEMI_MINOR, TGT_DIM);
    }

    void fill(BursaWolfParameters bursaWolfParameters, ParameterValueGroup parameterValueGroup) {
        bursaWolfParameters.dx = Parameters.doubleValue(DX, parameterValueGroup);
        bursaWolfParameters.dy = Parameters.doubleValue(DY, parameterValueGroup);
        bursaWolfParameters.dz = Parameters.doubleValue(DZ, parameterValueGroup);
        bursaWolfParameters.ex = Parameters.doubleValue(EX, parameterValueGroup);
        bursaWolfParameters.ey = Parameters.doubleValue(EY, parameterValueGroup);
        bursaWolfParameters.ez = Parameters.doubleValue(EZ, parameterValueGroup);
        bursaWolfParameters.ppm = Parameters.doubleValue(PPM, parameterValueGroup);
    }

    private static MathTransform concatenate(MathTransform mathTransform, ParameterValueGroup parameterValueGroup, ParameterDescriptor<Double> parameterDescriptor, ParameterDescriptor<Double> parameterDescriptor2, ParameterDescriptor<Integer> parameterDescriptor3) {
        double d = Parameters.doubleValue(parameterDescriptor, parameterValueGroup);
        double d2 = Parameters.doubleValue(parameterDescriptor2, parameterValueGroup);
        Integer n = Parameters.integerValue(parameterDescriptor3, parameterValueGroup);
        boolean bl = false;
        if (n == null) {
            if (Double.isNaN(d) && Double.isNaN(d2)) {
                return mathTransform;
            }
        } else {
            switch (n) {
                case 2: {
                    break;
                }
                case 3: {
                    bl = true;
                    break;
                }
                default: {
                    String string = parameterDescriptor3.getName().getCode();
                    throw new InvalidParameterValueException(Errors.format((int)73, (Object)string, (Object)n), string, (Object)n);
                }
            }
        }
        PositionVector7Param.ensureValid(parameterDescriptor, d);
        PositionVector7Param.ensureValid(parameterDescriptor2, d2);
        MathTransform mathTransform2 = GeocentricTransform.create(d, d2, (Unit<Length>)SI.METRE, bl);
        if (parameterDescriptor3 == SRC_DIM) {
            return ConcatenatedTransform.create(mathTransform2, mathTransform);
        }
        try {
            return ConcatenatedTransform.create(mathTransform, mathTransform2.inverse());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new AssertionError((Object)noninvertibleTransformException);
        }
    }

    private static void ensureValid(ParameterDescriptor<?> parameterDescriptor, double d) {
        if (!(d > 0.0)) {
            throw new IllegalStateException(Errors.format((int)119, (Object)parameterDescriptor.getName().getCode()));
        }
    }
}

