/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import org.geotoolkit.internal.referencing.Identifiers;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.parameter.DefaultParameterDescriptor;
import org.geotoolkit.parameter.Parameters;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.operation.MathTransformProvider;
import org.geotoolkit.referencing.operation.provider.IdentifierCode;
import org.geotoolkit.referencing.operation.transform.NTv2Transform;
import org.geotoolkit.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;

public class RGF93
extends MathTransformProvider {
    private static final long serialVersionUID = 4049217192968903800L;
    public static final ParameterDescriptor<String> TRANSLATION_FILE = new DefaultParameterDescriptor<String>("Geocentric translation file", String.class, null, "gr3df97a.txt");
    public static final ParameterDescriptorGroup PARAMETERS = Identifiers.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier(Citations.EPSG, "France geocentric interpolation"), new IdentifierCode(Citations.EPSG, 9655)}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{TRANSLATION_FILE});

    public RGF93() {
        super(2, 2, PARAMETERS);
    }

    public Class<Transformation> getOperationType() {
        return Transformation.class;
    }

    @Override
    protected MathTransform createMathTransform(ParameterValueGroup parameterValueGroup) throws FactoryException {
        String string = Parameters.stringValue(TRANSLATION_FILE, parameterValueGroup);
        if (!"gr3df97a.txt".equals(string)) {
            throw new FactoryException(Errors.format((int)31, (Object)string));
        }
        return new NTv2Transform("ntf_r93.gsb");
    }
}

