/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.referencing.operation.matrix.Matrix1;
import org.geotoolkit.referencing.operation.transform.AbstractMathTransform;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

@ThreadSafe
public abstract class AbstractMathTransform1D
extends AbstractMathTransform
implements MathTransform1D {
    protected AbstractMathTransform1D() {
    }

    @Override
    public final int getSourceDimensions() {
        return 1;
    }

    @Override
    public final int getTargetDimensions() {
        return 1;
    }

    @Override
    protected void transform(double[] dArray, int n, double[] dArray2, int n2) throws TransformException {
        dArray2[n2] = this.transform(dArray[n]);
    }

    @Override
    public Matrix derivative(DirectPosition directPosition) throws TransformException {
        double d;
        if (directPosition == null) {
            d = Double.NaN;
        } else {
            int n = directPosition.getDimension();
            if (n != 1) {
                throw new MismatchedDimensionException(AbstractMathTransform1D.mismatchedDimension("point", n, 1));
            }
            d = directPosition.getOrdinate(0);
        }
        return new Matrix1(this.derivative(d));
    }

    public MathTransform1D inverse() throws NoninvertibleTransformException {
        return (MathTransform1D)super.inverse();
    }
}

