/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.internal.referencing.MatrixUtilities;
import org.geotoolkit.internal.referencing.Semaphores;
import org.geotoolkit.io.wkt.Formattable;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.referencing.operation.matrix.MatrixFactory;
import org.geotoolkit.referencing.operation.matrix.XMatrix;
import org.geotoolkit.referencing.operation.transform.AbstractMathTransform;
import org.geotoolkit.referencing.operation.transform.ConcatenatedTransform1D;
import org.geotoolkit.referencing.operation.transform.ConcatenatedTransform2D;
import org.geotoolkit.referencing.operation.transform.ConcatenatedTransformDirect;
import org.geotoolkit.referencing.operation.transform.ConcatenatedTransformDirect1D;
import org.geotoolkit.referencing.operation.transform.ConcatenatedTransformDirect2D;
import org.geotoolkit.referencing.operation.transform.IdentityTransform;
import org.geotoolkit.referencing.operation.transform.IterationStrategy;
import org.geotoolkit.referencing.operation.transform.LinearTransform;
import org.geotoolkit.referencing.operation.transform.Parameterized;
import org.geotoolkit.referencing.operation.transform.PassThroughTransform;
import org.geotoolkit.referencing.operation.transform.ProjectiveTransform;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.LenientComparable;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.converter.Classes;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

@Immutable
public class ConcatenatedTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = 5772066656987558634L;
    static final double IDENTITY_TOLERANCE = 1.0E-9;
    public final MathTransform transform1;
    public final MathTransform transform2;
    private ConcatenatedTransform inverse;

    protected ConcatenatedTransform(MathTransform mathTransform, MathTransform mathTransform2) {
        this.transform1 = mathTransform;
        this.transform2 = mathTransform2;
        if (!this.isValid()) {
            throw new IllegalArgumentException(Errors.format((int)22, (Object)ConcatenatedTransform.getName(mathTransform), (Object)ConcatenatedTransform.getName(mathTransform2)));
        }
    }

    private static boolean areInverse(MathTransform mathTransform, MathTransform mathTransform2) {
        try {
            mathTransform2 = mathTransform2.inverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return false;
        }
        if (mathTransform == mathTransform2) {
            return true;
        }
        if (mathTransform instanceof LenientComparable) {
            return ((LenientComparable)mathTransform).equals((Object)mathTransform2, ComparisonMode.APPROXIMATIVE);
        }
        if (mathTransform2 instanceof LenientComparable) {
            return ((LenientComparable)mathTransform2).equals((Object)mathTransform, ComparisonMode.APPROXIMATIVE);
        }
        return mathTransform.equals(mathTransform2);
    }

    public static MathTransform create(MathTransform mathTransform, MathTransform mathTransform2) {
        int n;
        int n2 = mathTransform.getTargetDimensions();
        if (n2 != (n = mathTransform2.getSourceDimensions())) {
            throw new IllegalArgumentException(Errors.format((int)22, (Object)ConcatenatedTransform.getName(mathTransform), (Object)ConcatenatedTransform.getName(mathTransform2)) + ' ' + Errors.format((int)112, (Object)n2, (Object)n));
        }
        MathTransform mathTransform3 = ConcatenatedTransform.createOptimized(mathTransform, mathTransform2);
        if (mathTransform3 != null) {
            return mathTransform3;
        }
        int n3 = ConcatenatedTransform.getStepCount(mathTransform) + ConcatenatedTransform.getStepCount(mathTransform2);
        boolean bl = true;
        int n4 = 0;
        while (true) {
            MathTransform mathTransform4;
            MathTransform mathTransform5 = mathTransform;
            MathTransform mathTransform6 = mathTransform2;
            boolean bl2 = !(n4 & true);
            MathTransform mathTransform7 = mathTransform4 = bl2 ? mathTransform5 : mathTransform6;
            while (mathTransform4 instanceof ConcatenatedTransform) {
                int n5;
                ConcatenatedTransform concatenatedTransform = (ConcatenatedTransform)mathTransform4;
                if (bl2) {
                    mathTransform5 = mathTransform4 = concatenatedTransform.transform1;
                    mathTransform6 = ConcatenatedTransform.create(concatenatedTransform.transform2, mathTransform6);
                } else {
                    mathTransform5 = ConcatenatedTransform.create(mathTransform5, concatenatedTransform.transform1);
                    mathTransform6 = mathTransform4 = concatenatedTransform.transform2;
                }
                if ((n5 = ConcatenatedTransform.getStepCount(mathTransform5) + ConcatenatedTransform.getStepCount(mathTransform6)) >= n3) continue;
                mathTransform = mathTransform5;
                mathTransform2 = mathTransform6;
                n3 = n5;
                bl = true;
            }
            if (!bl) break;
            bl = false;
            ++n4;
        }
        mathTransform3 = ConcatenatedTransform.createOptimized(mathTransform, mathTransform2);
        if (mathTransform3 != null) {
            return mathTransform3;
        }
        return ConcatenatedTransform.createConcatenatedTransform(mathTransform, mathTransform2);
    }

    public static MathTransform2D create(MathTransform2D mathTransform2D, MathTransform2D mathTransform2D2) {
        return (MathTransform2D)ConcatenatedTransform.create((MathTransform)mathTransform2D, (MathTransform)mathTransform2D2);
    }

    public static MathTransform1D create(MathTransform1D mathTransform1D, MathTransform1D mathTransform1D2) {
        return (MathTransform1D)ConcatenatedTransform.create((MathTransform)mathTransform1D, (MathTransform)mathTransform1D2);
    }

    public static MathTransform create(MathTransform mathTransform, MathTransform mathTransform2, MathTransform mathTransform3) {
        return ConcatenatedTransform.create(ConcatenatedTransform.create(mathTransform, mathTransform2), mathTransform3);
    }

    public static MathTransform2D create(MathTransform2D mathTransform2D, MathTransform2D mathTransform2D2, MathTransform2D mathTransform2D3) {
        return (MathTransform2D)ConcatenatedTransform.create((MathTransform)mathTransform2D, (MathTransform)mathTransform2D2, (MathTransform)mathTransform2D3);
    }

    public static MathTransform1D create(MathTransform1D mathTransform1D, MathTransform1D mathTransform1D2, MathTransform1D mathTransform1D3) {
        return (MathTransform1D)ConcatenatedTransform.create((MathTransform)mathTransform1D, (MathTransform)mathTransform1D2, (MathTransform)mathTransform1D3);
    }

    private static MathTransform createOptimized(MathTransform mathTransform, MathTransform mathTransform2) {
        Matrix matrix;
        if (mathTransform.isIdentity()) {
            return mathTransform2;
        }
        if (mathTransform2.isIdentity()) {
            return mathTransform;
        }
        Matrix matrix2 = MatrixFactory.getMatrix(mathTransform);
        if (matrix2 != null) {
            PassThroughTransform passThroughTransform;
            Matrix matrix3;
            matrix = MatrixFactory.getMatrix(mathTransform2);
            if (matrix != null) {
                XMatrix xMatrix = MatrixFactory.toXMatrix(MatrixUtilities.multiply(matrix, matrix2));
                if (xMatrix.isIdentity(1.0E-9)) {
                    xMatrix.setIdentity();
                }
                return ProjectiveTransform.create(xMatrix);
            }
            if (mathTransform2 instanceof PassThroughTransform && (matrix3 = (passThroughTransform = (PassThroughTransform)mathTransform2).toSubMatrix(matrix2)) != null) {
                return PassThroughTransform.create(passThroughTransform.firstAffectedOrdinate, ConcatenatedTransform.create(ProjectiveTransform.create(matrix3), passThroughTransform.subTransform), passThroughTransform.numTrailingOrdinates);
            }
        }
        if (ConcatenatedTransform.areInverse(mathTransform, mathTransform2) || ConcatenatedTransform.areInverse(mathTransform2, mathTransform)) {
            assert (mathTransform.getSourceDimensions() == mathTransform2.getTargetDimensions());
            assert (mathTransform.getTargetDimensions() == mathTransform2.getSourceDimensions());
            return IdentityTransform.create(mathTransform.getSourceDimensions());
        }
        if (mathTransform instanceof AbstractMathTransform && (matrix = ((AbstractMathTransform)mathTransform).concatenate(mathTransform2, false)) != null) {
            return matrix;
        }
        if (mathTransform2 instanceof AbstractMathTransform && (matrix = ((AbstractMathTransform)mathTransform2).concatenate(mathTransform, true)) != null) {
            return matrix;
        }
        return null;
    }

    static ConcatenatedTransform createConcatenatedTransform(MathTransform mathTransform, MathTransform mathTransform2) {
        int n = mathTransform.getSourceDimensions();
        int n2 = mathTransform2.getTargetDimensions();
        if (n == 1 && n2 == 1) {
            if (mathTransform instanceof MathTransform1D && mathTransform2 instanceof MathTransform1D) {
                return new ConcatenatedTransformDirect1D((MathTransform1D)mathTransform, (MathTransform1D)mathTransform2);
            }
            return new ConcatenatedTransform1D(mathTransform, mathTransform2);
        }
        if (n == 2 && n2 == 2) {
            if (mathTransform instanceof MathTransform2D && mathTransform2 instanceof MathTransform2D) {
                return new ConcatenatedTransformDirect2D((MathTransform2D)mathTransform, (MathTransform2D)mathTransform2);
            }
            return new ConcatenatedTransform2D(mathTransform, mathTransform2);
        }
        if (n == mathTransform.getTargetDimensions() && mathTransform2.getSourceDimensions() == n2) {
            return new ConcatenatedTransformDirect(mathTransform, mathTransform2);
        }
        return new ConcatenatedTransform(mathTransform, mathTransform2);
    }

    private static String getName(MathTransform mathTransform) {
        String string;
        ParameterValueGroup parameterValueGroup;
        if (mathTransform instanceof AbstractMathTransform && (parameterValueGroup = ((AbstractMathTransform)mathTransform).getParameterValues()) != null && (string = parameterValueGroup.getDescriptor().getName().getCode()) != null && !(string = string.trim()).isEmpty()) {
            return string;
        }
        return Classes.getShortClassName((Object)mathTransform);
    }

    boolean isValid() {
        return this.transform1.getTargetDimensions() == this.transform2.getSourceDimensions();
    }

    @Override
    public final int getSourceDimensions() {
        return this.transform1.getSourceDimensions();
    }

    @Override
    public final int getTargetDimensions() {
        return this.transform2.getTargetDimensions();
    }

    public final int getStepCount() {
        return ConcatenatedTransform.getStepCount(this.transform1) + ConcatenatedTransform.getStepCount(this.transform2);
    }

    private static int getStepCount(MathTransform mathTransform) {
        if (mathTransform.isIdentity()) {
            return 0;
        }
        if (!(mathTransform instanceof ConcatenatedTransform)) {
            return 1;
        }
        return ((ConcatenatedTransform)mathTransform).getStepCount();
    }

    public final List<MathTransform> getSteps() {
        ArrayList<MathTransform> arrayList = new ArrayList<MathTransform>(5);
        this.getSteps(arrayList);
        return arrayList;
    }

    private List<Object> getPseudoSteps() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.getSteps(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (!(e instanceof AbstractMathTransform)) continue;
            i = ((AbstractMathTransform)e).beforeFormat(arrayList, i, false);
        }
        return arrayList;
    }

    private void getSteps(List<? super MathTransform> list) {
        if (this.transform1 instanceof ConcatenatedTransform) {
            ((ConcatenatedTransform)this.transform1).getSteps(list);
        } else {
            list.add((MathTransform)this.transform1);
        }
        if (this.transform2 instanceof ConcatenatedTransform) {
            ((ConcatenatedTransform)this.transform2).getSteps(list);
        } else {
            list.add((MathTransform)this.transform2);
        }
    }

    private Parameterized getParameterised() {
        Parameterized parameterized = null;
        List<Object> list = this.getPseudoSteps();
        if (list.size() == 1 || Semaphores.query(2)) {
            for (Object object : list) {
                if (!(object instanceof Parameterized)) {
                    return null;
                }
                if (parameterized != null) {
                    boolean bl = object instanceof LinearTransform;
                    if (parameterized instanceof LinearTransform == bl) {
                        return null;
                    }
                    if (bl) continue;
                }
                parameterized = (Parameterized)object;
            }
        }
        return parameterized;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        Parameterized parameterized = this.getParameterised();
        return parameterized != null ? parameterized.getParameterDescriptors() : null;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        Parameterized parameterized = this.getParameterised();
        return parameterized != null ? parameterized.getParameterValues() : null;
    }

    @Override
    public DirectPosition transform(DirectPosition directPosition, DirectPosition directPosition2) throws TransformException {
        assert (this.isValid());
        return this.transform2.transform(this.transform1.transform(directPosition, null), directPosition2);
    }

    @Override
    protected void transform(double[] dArray, int n, double[] dArray2, int n2) throws TransformException {
        this.transform(dArray, n, dArray2, n2, 1);
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
        int n4;
        assert (this.isValid());
        int n5 = this.transform2.getSourceDimensions();
        if (n5 <= (n4 = this.transform2.getTargetDimensions())) {
            this.transform1.transform(dArray, n, dArray2, n2, n3);
            this.transform2.transform(dArray2, n2, dArray2, n2, n3);
            return;
        }
        if (n3 <= 0) {
            return;
        }
        boolean bl = false;
        int n6 = this.transform1.getSourceDimensions();
        int n7 = n3;
        int n8 = n7 * n5;
        if (n8 > 512) {
            n7 = Math.max(1, 512 / n5);
            if (dArray == dArray2) {
                switch (IterationStrategy.suggest(n, n7 * n6, n2, n7 * n4, n3)) {
                    default: {
                        n7 = n3;
                        break;
                    }
                    case ASCENDING: {
                        break;
                    }
                    case DESCENDING: {
                        int n9 = n3 - n7;
                        n += n9 * n6;
                        n6 = -n6;
                        n2 += n9 * n4;
                        n4 = -n4;
                        bl = true;
                        break;
                    }
                }
            }
            n8 = n7 * n5;
        }
        double[] dArray3 = new double[n8];
        do {
            if (!bl && n7 > n3) {
                n7 = n3;
            }
            this.transform1.transform(dArray, n, dArray3, 0, n7);
            this.transform2.transform(dArray3, 0, dArray2, n2, n7);
            if (bl && n7 > (n3 -= n7)) {
                n7 = n3;
            }
            n += n7 * n6;
            n2 += n7 * n4;
        } while (n3 != 0);
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) throws TransformException {
        assert (this.isValid());
        if (n3 <= 0) {
            return;
        }
        boolean bl = false;
        int n4 = this.transform1.getSourceDimensions();
        int n5 = this.transform1.getTargetDimensions();
        int n6 = n3;
        int n7 = this.transform2.getTargetDimensions();
        int n8 = Math.max(n7, n5);
        int n9 = n6 * n8;
        if (n9 > 512) {
            n6 = Math.max(1, 512 / n8);
            if (fArray == fArray2) {
                switch (IterationStrategy.suggest(n, n6 * n4, n2, n6 * n7, n3)) {
                    default: {
                        n6 = n3;
                        break;
                    }
                    case ASCENDING: {
                        break;
                    }
                    case DESCENDING: {
                        int n10 = n3 - n6;
                        n += n10 * n4;
                        n4 = -n4;
                        n2 += n10 * n7;
                        n7 = -n7;
                        bl = true;
                        break;
                    }
                }
            }
            n9 = n6 * n8;
        }
        double[] dArray = new double[n9];
        do {
            if (!bl && n6 > n3) {
                n6 = n3;
            }
            this.transform1.transform(fArray, n, dArray, 0, n6);
            this.transform2.transform(dArray, 0, fArray2, n2, n6);
            if (bl && n6 > (n3 -= n6)) {
                n6 = n3;
            }
            n += n6 * n4;
            n2 += n6 * n7;
        } while (n3 != 0);
    }

    @Override
    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) throws TransformException {
        assert (this.isValid());
        if (n3 <= 0) {
            return;
        }
        int n4 = this.transform1.getSourceDimensions();
        int n5 = this.transform1.getTargetDimensions();
        int n6 = n3;
        int n7 = this.transform2.getTargetDimensions();
        int n8 = Math.max(n7, n5);
        int n9 = n6 * n8;
        if (n9 > 512) {
            n6 = Math.max(1, 512 / n8);
            n9 = n6 * n8;
        }
        double[] dArray2 = new double[n9];
        do {
            if (n6 > n3) {
                n6 = n3;
            }
            this.transform1.transform(dArray, n, dArray2, 0, n6);
            this.transform2.transform(dArray2, 0, fArray, n2, n6);
            n += n6 * n4;
            n2 += n6 * n7;
        } while ((n3 -= n6) != 0);
    }

    @Override
    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) throws TransformException {
        int n4;
        assert (this.isValid());
        int n5 = this.transform2.getSourceDimensions();
        if (n5 <= (n4 = this.transform2.getTargetDimensions())) {
            this.transform1.transform(fArray, n, dArray, n2, n3);
            this.transform2.transform(dArray, n2, dArray, n2, n3);
            return;
        }
        if (n3 <= 0) {
            return;
        }
        int n6 = n3;
        int n7 = n6 * n5;
        if (n7 > 512) {
            n6 = Math.max(1, 512 / n5);
            n7 = n6 * n5;
        }
        double[] dArray2 = new double[n7];
        int n8 = this.getSourceDimensions();
        do {
            if (n6 > n3) {
                n6 = n3;
            }
            this.transform1.transform(fArray, n, dArray2, 0, n6);
            this.transform2.transform(dArray2, 0, dArray, n2, n6);
            n += n6 * n8;
            n2 += n6 * n4;
        } while ((n3 -= n6) != 0);
    }

    @Override
    public synchronized MathTransform inverse() throws NoninvertibleTransformException {
        assert (this.isValid());
        if (this.inverse == null) {
            this.inverse = ConcatenatedTransform.createConcatenatedTransform(this.transform2.inverse(), this.transform1.inverse());
            this.inverse.inverse = this;
        }
        return this.inverse;
    }

    @Override
    public Matrix derivative(Point2D point2D) throws TransformException {
        return this.derivative(new GeneralDirectPosition(point2D));
    }

    @Override
    public Matrix derivative(DirectPosition directPosition) throws TransformException {
        Matrix matrix = this.transform1.derivative(directPosition);
        Matrix matrix2 = this.transform2.derivative(this.transform1.transform(directPosition, null));
        return MatrixUtilities.multiply(matrix2, matrix);
    }

    @Override
    public final boolean isIdentity() {
        return this.transform1.isIdentity() && this.transform2.isIdentity();
    }

    @Override
    protected int computeHashCode() {
        return Utilities.hash(this.getSteps(), (int)super.computeHashCode());
    }

    @Override
    public final boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (object instanceof ConcatenatedTransform) {
            ConcatenatedTransform concatenatedTransform = (ConcatenatedTransform)object;
            return Utilities.deepEquals(this.getSteps(), concatenatedTransform.getSteps(), (ComparisonMode)comparisonMode);
        }
        return false;
    }

    @Override
    public String formatWKT(Formatter formatter) {
        List<Object> list = formatter.isInternalWKT() ? this.getSteps() : this.getPseudoSteps();
        if (list.size() == 1) {
            return ((Formattable)list.get(0)).formatWKT(formatter);
        }
        for (Object object : list) {
            if (object instanceof MathTransform) {
                formatter.append((MathTransform)object);
                continue;
            }
            formatter.append((Formattable)object);
        }
        return "CONCAT_MT";
    }
}

