/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import net.jcip.annotations.Immutable;
import org.geotoolkit.geometry.DirectPosition1D;
import org.geotoolkit.referencing.operation.transform.ConcatenatedTransform;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

@Immutable
final class ConcatenatedTransform1D
extends ConcatenatedTransform
implements MathTransform1D {
    private static final long serialVersionUID = 8150427971141078395L;

    public ConcatenatedTransform1D(MathTransform mathTransform, MathTransform mathTransform2) {
        super(mathTransform, mathTransform2);
    }

    @Override
    boolean isValid() {
        return super.isValid() && this.getSourceDimensions() == 1 && this.getTargetDimensions() == 1;
    }

    public double transform(double d) throws TransformException {
        double[] dArray = new double[]{d};
        double[] dArray2 = new double[]{this.transform1.getTargetDimensions()};
        this.transform1.transform(dArray, 0, dArray2, 0, 1);
        this.transform2.transform(dArray2, 0, dArray, 0, 1);
        return dArray[0];
    }

    public double derivative(double d) throws TransformException {
        DirectPosition1D directPosition1D = new DirectPosition1D(d);
        Matrix matrix = this.derivative(directPosition1D);
        assert (matrix.getNumRow() == 1 && matrix.getNumCol() == 1);
        return matrix.getElement(0, 0);
    }

    public MathTransform1D inverse() throws NoninvertibleTransformException {
        return (MathTransform1D)super.inverse();
    }
}

