/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import java.io.Serializable;
import net.jcip.annotations.Immutable;
import org.geotoolkit.referencing.operation.matrix.Matrix1;
import org.geotoolkit.referencing.operation.matrix.Matrix2;
import org.geotoolkit.referencing.operation.provider.Affine;
import org.geotoolkit.referencing.operation.transform.AbstractMathTransform1D;
import org.geotoolkit.referencing.operation.transform.ConstantTransform1D;
import org.geotoolkit.referencing.operation.transform.IdentityTransform1D;
import org.geotoolkit.referencing.operation.transform.LinearTransform;
import org.geotoolkit.referencing.operation.transform.ProjectiveTransform;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

@Immutable
public class LinearTransform1D
extends AbstractMathTransform1D
implements LinearTransform,
Serializable {
    private static final long serialVersionUID = -7595037195668813000L;
    public static final LinearTransform1D IDENTITY = new IdentityTransform1D();
    public final double scale;
    public final double offset;
    private transient MathTransform1D inverse;

    protected LinearTransform1D(double d, double d2) {
        this.scale = d;
        this.offset = d2;
    }

    public static LinearTransform1D create(double d, double d2) {
        if (d == 0.0) {
            return new ConstantTransform1D(d2);
        }
        if (d == 1.0 && d2 == 0.0) {
            return IDENTITY;
        }
        return new LinearTransform1D(d, d2);
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Affine.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return ProjectiveTransform.getParameterValues(this.getMatrix());
    }

    @Override
    public Matrix getMatrix() {
        return new Matrix2(this.scale, this.offset, 0.0, 1.0);
    }

    @Override
    public MathTransform1D inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            if (this.isIdentity()) {
                this.inverse = this;
            } else if (this.scale != 0.0) {
                LinearTransform1D linearTransform1D = LinearTransform1D.create(1.0 / this.scale, -this.offset / this.scale);
                linearTransform1D.inverse = this;
                this.inverse = linearTransform1D;
            } else {
                this.inverse = super.inverse();
            }
        }
        return this.inverse;
    }

    @Override
    public boolean isIdentity() {
        return this.isIdentity(0.0);
    }

    @Override
    public boolean isIdentity(double d) {
        d = Math.abs(d);
        return Math.abs(this.offset) <= d && Math.abs(this.scale - 1.0) <= d;
    }

    @Override
    public Matrix derivative(DirectPosition directPosition) throws TransformException {
        return new Matrix1(this.scale);
    }

    public double derivative(double d) {
        return this.scale;
    }

    public double transform(double d) {
        return this.offset + this.scale * d;
    }

    @Override
    protected void transform(double[] dArray, int n, double[] dArray2, int n2) {
        dArray2[n2] = this.offset + this.scale * dArray[n];
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        if (dArray != dArray2 || n >= n2) {
            while (--n3 >= 0) {
                dArray2[n2++] = this.offset + this.scale * dArray[n++];
            }
        } else {
            n += n3;
            n2 += n3;
            while (--n3 >= 0) {
                dArray2[--n2] = this.offset + this.scale * dArray[--n];
            }
        }
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        if (fArray != fArray2 || n >= n2) {
            while (--n3 >= 0) {
                fArray2[n2++] = (float)(this.offset + this.scale * (double)fArray[n++]);
            }
        } else {
            n += n3;
            n2 += n3;
            while (--n3 >= 0) {
                fArray2[--n2] = (float)(this.offset + this.scale * (double)fArray[--n]);
            }
        }
    }

    @Override
    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
        while (--n3 >= 0) {
            fArray[n2++] = (float)(this.offset + this.scale * dArray[n++]);
        }
    }

    @Override
    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
        while (--n3 >= 0) {
            dArray[n2++] = this.offset + this.scale * (double)fArray[n++];
        }
    }

    @Override
    protected int computeHashCode() {
        return Utilities.hash((long)Double.doubleToRawLongBits(this.offset), (int)Utilities.hash((double)this.scale, (int)super.computeHashCode()));
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (comparisonMode != ComparisonMode.STRICT) {
            return LinearTransform1D.equals(this, object, comparisonMode);
        }
        if (super.equals(object, comparisonMode)) {
            LinearTransform1D linearTransform1D = (LinearTransform1D)object;
            return Double.doubleToRawLongBits(this.scale) == Double.doubleToRawLongBits(linearTransform1D.scale) && Double.doubleToRawLongBits(this.offset) == Double.doubleToRawLongBits(linearTransform1D.offset);
        }
        return false;
    }
}

