/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferFloat;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.internal.io.Installation;
import org.geotoolkit.io.ContentFormatException;
import org.geotoolkit.referencing.factory.OptionalFactoryOperationException;
import org.geotoolkit.referencing.operation.transform.GridLoader;
import org.geotoolkit.resources.Descriptions;
import org.geotoolkit.resources.Errors;
import org.opengis.util.FactoryException;

abstract class NadconLoader
extends GridLoader {
    transient boolean rx;
    int width;
    int height;
    private float xmin;
    private float ymin;
    private float dx;
    private float dy;
    float[] longitudeShift;
    float[] latitudeShift;
    private transient DataBuffer buffer;

    NadconLoader() {
        super(NadconLoader.class);
    }

    public static NadconLoader loadIfAbsent(final String string, final String string2) throws FactoryException {
        return NadconLoader.loadIfAbsent(NadconLoader.class, string, string2, new Callable<NadconLoader>(){

            @Override
            public NadconLoader call() throws FactoryException {
                return NadconLoader.load(string, string2);
            }
        });
    }

    private static NadconLoader load(String string, String string2) throws FactoryException {
        boolean bl = false;
        try {
            Object object = Installation.NADCON.toFileOrURL(NadconLoader.class, string2);
            boolean bl2 = NadconLoader.isBinary(object, "laa", "las");
            bl = true;
            Object object2 = Installation.NADCON.toFileOrURL(NadconLoader.class, string);
            boolean bl3 = NadconLoader.isBinary(object2, "loa", "los");
            if (bl2 != bl3) {
                throw new FactoryException(Errors.format((int)95));
            }
            NadconLoader nadconLoader = bl2 ? new Binary() : new Text();
            nadconLoader.latitudeGridFile = object;
            nadconLoader.longitudeGridFile = object2;
            try {
                nadconLoader.load();
            }
            catch (IOException iOException) {
                bl = nadconLoader.rx;
                throw iOException;
            }
            nadconLoader.longitudeGridFile = string;
            nadconLoader.latitudeGridFile = string2;
            return nadconLoader;
        }
        catch (IOException iOException) {
            String string3 = Errors.format((int)31, (Object)(bl ? string : string2));
            string3 = string3 + ' ' + Descriptions.format((int)7, (Object)"NADCON", (Object)Installation.NADCON.directory(true), (Object)"geotk-setup");
            FactoryException factoryException = iOException instanceof FileNotFoundException ? new OptionalFactoryOperationException(string3, iOException) : new FactoryException(string3, (Throwable)iOException);
            throw factoryException;
        }
    }

    private static boolean isBinary(Object object, String string, String string2) throws IOException {
        String string3 = IOUtilities.extension((Object)object);
        if (string3.equalsIgnoreCase(string2)) {
            return true;
        }
        if (string3.equalsIgnoreCase(string)) {
            return false;
        }
        throw new IOException(Errors.format((int)242, (Object)string3));
    }

    final void NADCON(Number[] numberArray) {
        this.width = (Integer)numberArray[0];
        this.height = (Integer)numberArray[1];
        this.xmin = ((Float)numberArray[3]).floatValue();
        this.dx = ((Float)numberArray[4]).floatValue();
        this.ymin = ((Float)numberArray[5]).floatValue();
        this.dy = ((Float)numberArray[6]).floatValue();
        int n = this.width * this.height;
        this.latitudeShift = new float[n];
        this.longitudeShift = new float[n];
    }

    abstract void load() throws IOException;

    public final synchronized DataBuffer getDataBuffer() {
        if (this.buffer == null) {
            this.buffer = new DataBufferFloat(new float[][]{this.longitudeShift, this.latitudeShift}, this.width * this.height);
        }
        return this.buffer;
    }

    public final Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public final Rectangle2D getArea() {
        return new Rectangle2D.Float(this.xmin, this.ymin, (float)this.width * this.dx, (float)this.height * this.dy);
    }

    private static final class Binary
    extends NadconLoader {
        private static final int HEADER_LENGTH = 96;
        private static final int DESCRIPTION_LENGTH = 64;

        private Binary() {
        }

        private static void readFully(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) throws IOException {
            while (byteBuffer.remaining() != 0) {
                if (readableByteChannel.read(byteBuffer) >= 0) continue;
                throw new EOFException(Errors.format((int)61));
            }
        }

        private static Number[] readHeader(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) throws IOException {
            Binary.readFully(readableByteChannel, byteBuffer);
            byteBuffer.position(64);
            return new Number[]{byteBuffer.getInt(), byteBuffer.getInt(), byteBuffer.getInt(), Float.valueOf(byteBuffer.getFloat()), Float.valueOf(byteBuffer.getFloat()), Float.valueOf(byteBuffer.getFloat()), Float.valueOf(byteBuffer.getFloat()), Float.valueOf(byteBuffer.getFloat())};
        }

        @Override
        void load() throws IOException {
            this.rx = true;
            ReadableByteChannel readableByteChannel = Channels.newChannel(IOUtilities.open((Object)this.longitudeGridFile));
            this.rx = false;
            ReadableByteChannel readableByteChannel2 = Channels.newChannel(IOUtilities.open((Object)this.latitudeGridFile));
            ByteBuffer byteBuffer = ByteBuffer.allocate(96);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            Object[] objectArray = Binary.readHeader(readableByteChannel2, byteBuffer);
            this.rx = true;
            byteBuffer.rewind();
            if (!Arrays.equals(objectArray, Binary.readHeader(readableByteChannel, byteBuffer))) {
                throw new ContentFormatException(Errors.format((int)68));
            }
            this.NADCON((Number[])objectArray);
            int n = (this.width + 1) * 4;
            int n2 = Math.max(1, Math.min(this.height, 4096 / n));
            byteBuffer = ByteBuffer.allocateDirect(n2 * n);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
            this.rx = false;
            do {
                int n3;
                float[] fArray;
                ReadableByteChannel readableByteChannel3;
                if (this.rx) {
                    readableByteChannel3 = readableByteChannel;
                    fArray = this.longitudeShift;
                } else {
                    readableByteChannel3 = readableByteChannel2;
                    fArray = this.latitudeShift;
                }
                if (n > 96) {
                    byteBuffer.rewind();
                    byteBuffer.limit(n - 96);
                    Binary.readFully(readableByteChannel3, byteBuffer);
                }
                byteBuffer.clear();
                int n4 = 0;
                for (int i = this.height; i != 0; i -= n3) {
                    n3 = n2;
                    if (i < n3) {
                        n3 = i;
                        byteBuffer.limit(n3 * n);
                    }
                    Binary.readFully(readableByteChannel3, byteBuffer);
                    floatBuffer.rewind();
                    for (int j = 0; j < n3; ++j) {
                        float f = floatBuffer.get();
                        if (f != 0.0f) {
                            throw new ContentFormatException();
                        }
                        floatBuffer.get(fArray, n4, this.width);
                        n4 += this.width;
                    }
                    byteBuffer.rewind();
                }
                byteBuffer.limit(1);
                n3 = readableByteChannel3.read(byteBuffer);
                readableByteChannel3.close();
                if (n3 < 0) continue;
                throw new IOException(Errors.format((int)66));
            } while (this.rx = !this.rx);
        }
    }

    private static final class Text
    extends NadconLoader {
        private Text() {
        }

        private static Number[] readHeader(BufferedReader bufferedReader) throws IOException {
            bufferedReader.readLine();
            String string = bufferedReader.readLine();
            if (string == null) {
                throw new EOFException(Errors.format((int)61));
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n = stringTokenizer.countTokens();
            if (n != 8) {
                throw new ContentFormatException(Errors.format((int)69, (Object)n));
            }
            String string2 = null;
            try {
                Number[] numberArray = new Number[8];
                string2 = stringTokenizer.nextToken();
                numberArray[0] = Integer.parseInt(string2);
                string2 = stringTokenizer.nextToken();
                numberArray[1] = Integer.parseInt(string2);
                string2 = stringTokenizer.nextToken();
                numberArray[2] = Integer.parseInt(string2);
                string2 = stringTokenizer.nextToken();
                numberArray[3] = Float.valueOf(Float.parseFloat(string2));
                string2 = stringTokenizer.nextToken();
                numberArray[4] = Float.valueOf(Float.parseFloat(string2));
                string2 = stringTokenizer.nextToken();
                numberArray[5] = Float.valueOf(Float.parseFloat(string2));
                string2 = stringTokenizer.nextToken();
                numberArray[6] = Float.valueOf(Float.parseFloat(string2));
                string2 = stringTokenizer.nextToken();
                numberArray[7] = Float.valueOf(Float.parseFloat(string2));
                return numberArray;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ContentFormatException(Errors.format((int)232, string2), (Throwable)numberFormatException);
            }
        }

        @Override
        void load() throws IOException {
            this.rx = true;
            LineNumberReader lineNumberReader = IOUtilities.openLatin((Object)this.longitudeGridFile);
            this.rx = false;
            LineNumberReader lineNumberReader2 = IOUtilities.openLatin((Object)this.latitudeGridFile);
            Object[] objectArray = Text.readHeader(lineNumberReader2);
            this.rx = true;
            if (!Arrays.equals(objectArray, Text.readHeader(lineNumberReader))) {
                throw new ContentFormatException(Errors.format((int)68));
            }
            this.NADCON((Number[])objectArray);
            this.rx = false;
            Text.read(lineNumberReader2, this.latitudeShift);
            this.rx = true;
            Text.read(lineNumberReader, this.longitudeShift);
        }

        private static void read(BufferedReader bufferedReader, float[] fArray) throws IOException {
            String string;
            int n = 0;
            while ((string = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreElements()) {
                    float f;
                    String string2 = stringTokenizer.nextToken();
                    try {
                        f = Float.parseFloat(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ContentFormatException(Errors.format((int)232, (Object)string2), (Throwable)numberFormatException);
                    }
                    if (n >= fArray.length) {
                        throw new IOException(Errors.format((int)66));
                    }
                    fArray[n++] = f;
                }
            }
            bufferedReader.close();
            if (n < fArray.length) {
                throw new EOFException(Errors.format((int)65));
            }
        }
    }
}

