/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Arrays;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.MatrixUtilities;
import org.geotoolkit.parameter.MatrixParameters;
import org.geotoolkit.referencing.operation.matrix.GeneralMatrix;
import org.geotoolkit.referencing.operation.matrix.MatrixFactory;
import org.geotoolkit.referencing.operation.matrix.XMatrix;
import org.geotoolkit.referencing.operation.provider.Affine;
import org.geotoolkit.referencing.operation.transform.AbstractMathTransform;
import org.geotoolkit.referencing.operation.transform.AffineTransform2D;
import org.geotoolkit.referencing.operation.transform.CopyTransform;
import org.geotoolkit.referencing.operation.transform.IdentityTransform;
import org.geotoolkit.referencing.operation.transform.IterationStrategy;
import org.geotoolkit.referencing.operation.transform.LinearTransform;
import org.geotoolkit.referencing.operation.transform.LinearTransform1D;
import org.geotoolkit.referencing.operation.transform.ProjectiveTransform2D;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;

@Immutable
public class ProjectiveTransform
extends AbstractMathTransform
implements LinearTransform,
Serializable {
    private static final long serialVersionUID = -2104496465933824935L;
    private final int numRow;
    private final int numCol;
    private final double[] elt;
    AbstractMathTransform inverse;

    protected ProjectiveTransform(Matrix matrix) {
        this.numRow = matrix.getNumRow();
        this.numCol = matrix.getNumCol();
        this.elt = new double[this.numRow * this.numCol];
        int n = 0;
        for (int i = 0; i < this.numRow; ++i) {
            for (int j = 0; j < this.numCol; ++j) {
                this.elt[n++] = matrix.getElement(i, j);
            }
        }
    }

    public static LinearTransform create(Matrix matrix) {
        CopyTransform copyTransform;
        int n;
        int n2 = matrix.getNumCol() - 1;
        if (n2 == (n = matrix.getNumRow() - 1)) {
            if (matrix.isIdentity()) {
                return IdentityTransform.create(n2);
            }
            if (MatrixUtilities.isAffine(matrix)) {
                switch (n2) {
                    case 1: {
                        return LinearTransform1D.create(matrix.getElement(0, 0), matrix.getElement(0, 1));
                    }
                    case 2: {
                        return ProjectiveTransform.create(MatrixUtilities.toAffineTransform(matrix));
                    }
                }
            } else if (n2 == 2) {
                return new ProjectiveTransform2D(matrix);
            }
        }
        if ((copyTransform = CopyTransform.create(matrix)) != null) {
            return copyTransform;
        }
        return new ProjectiveTransform(matrix);
    }

    public static LinearTransform create(AffineTransform affineTransform) {
        if (affineTransform.isIdentity()) {
            return IdentityTransform.create(2);
        }
        return new AffineTransform2D(affineTransform);
    }

    public static LinearTransform createScale(int n, double d) {
        if (d == 1.0) {
            return IdentityTransform.create(n);
        }
        GeneralMatrix generalMatrix = new GeneralMatrix(n + 1);
        for (int i = 0; i < n; ++i) {
            generalMatrix.setElement(i, i, d);
        }
        return ProjectiveTransform.create(generalMatrix);
    }

    public static LinearTransform createTranslation(int n, double d) {
        if (d == 0.0) {
            return IdentityTransform.create(n);
        }
        GeneralMatrix generalMatrix = new GeneralMatrix(n + 1);
        for (int i = 0; i < n; ++i) {
            generalMatrix.setElement(i, n, d);
        }
        return ProjectiveTransform.create(generalMatrix);
    }

    public static XMatrix createSelectMatrix(int n, int[] nArray) throws IndexOutOfBoundsException {
        int n2 = nArray.length;
        XMatrix xMatrix = MatrixFactory.create(n2 + 1, n + 1);
        xMatrix.setZero();
        for (int i = 0; i < n2; ++i) {
            xMatrix.setElement(i, nArray[i], 1.0);
        }
        xMatrix.setElement(n2, n, 1.0);
        return xMatrix;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Affine.PARAMETERS;
    }

    static ParameterValueGroup getParameterValues(Matrix matrix) {
        MatrixParameters matrixParameters = (MatrixParameters)Affine.PARAMETERS.createValue();
        matrixParameters.setMatrix(matrix);
        return matrixParameters;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return ProjectiveTransform.getParameterValues(this.getMatrix());
    }

    @Override
    protected void transform(double[] dArray, int n, double[] dArray2, int n2) {
        this.transform(dArray, n, dArray2, n2, 1);
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        int n4;
        int n5;
        int n6 = n5 = this.numCol - 1;
        int n7 = n4 = this.numRow - 1;
        if (dArray == dArray2) {
            switch (IterationStrategy.suggest(n, n5, n2, n4, n3)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n += (n3 - 1) * n5;
                    n2 += (n3 - 1) * n4;
                    n6 = -n6;
                    n7 = -n7;
                    break;
                }
                default: {
                    dArray = Arrays.copyOfRange(dArray, n, n + n3 * n5);
                    n = 0;
                }
            }
        }
        double[] dArray3 = new double[this.numRow];
        while (--n3 >= 0) {
            int n8 = 0;
            for (int i = 0; i < this.numRow; ++i) {
                double d = this.elt[n8 + n5];
                for (int j = 0; j < n5; ++j) {
                    double d2;
                    if ((d2 = this.elt[n8++]) == 0.0) continue;
                    d += dArray[n + j] * d2;
                }
                dArray3[i] = d;
                ++n8;
            }
            double d = dArray3[n4];
            for (int i = 0; i < n4; ++i) {
                dArray2[n2 + i] = dArray3[i] / d;
            }
            n += n6;
            n2 += n7;
        }
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        int n4;
        int n5;
        int n6 = n5 = this.numCol - 1;
        int n7 = n4 = this.numRow - 1;
        if (fArray == fArray2) {
            switch (IterationStrategy.suggest(n, n5, n2, n4, n3)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n += (n3 - 1) * n5;
                    n2 += (n3 - 1) * n4;
                    n6 = -n6;
                    n7 = -n7;
                    break;
                }
                default: {
                    fArray = Arrays.copyOfRange(fArray, n, n + n3 * n5);
                    n = 0;
                }
            }
        }
        double[] dArray = new double[this.numRow];
        while (--n3 >= 0) {
            int n8 = 0;
            for (int i = 0; i < this.numRow; ++i) {
                double d = this.elt[n8 + n5];
                for (int j = 0; j < n5; ++j) {
                    double d2;
                    if ((d2 = this.elt[n8++]) == 0.0) continue;
                    d += (double)fArray[n + j] * d2;
                }
                dArray[i] = d;
                ++n8;
            }
            double d = dArray[n4];
            for (int i = 0; i < n4; ++i) {
                fArray2[n2 + i] = (float)(dArray[i] / d);
            }
            n += n6;
            n2 += n7;
        }
    }

    @Override
    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
        int n4 = this.numCol - 1;
        int n5 = this.numRow - 1;
        double[] dArray2 = new double[this.numRow];
        while (--n3 >= 0) {
            int n6 = 0;
            for (int i = 0; i < this.numRow; ++i) {
                double d = this.elt[n6 + n4];
                for (int j = 0; j < n4; ++j) {
                    double d2;
                    if ((d2 = this.elt[n6++]) == 0.0) continue;
                    d += dArray[n + j] * d2;
                }
                dArray2[i] = d;
                ++n6;
            }
            double d = dArray2[n5];
            for (int i = 0; i < n5; ++i) {
                fArray[n2++] = (float)(dArray2[i] / d);
            }
            n += n4;
        }
    }

    @Override
    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
        int n4 = this.numCol - 1;
        int n5 = this.numRow - 1;
        double[] dArray2 = new double[this.numRow];
        while (--n3 >= 0) {
            int n6 = 0;
            for (int i = 0; i < this.numRow; ++i) {
                double d = this.elt[n6 + n4];
                for (int j = 0; j < n4; ++j) {
                    double d2;
                    if ((d2 = this.elt[n6++]) == 0.0) continue;
                    d += (double)fArray[n + j] * d2;
                }
                dArray2[i] = d;
                ++n6;
            }
            double d = dArray2[n5];
            for (int i = 0; i < n5; ++i) {
                dArray[n2++] = dArray2[i] / d;
            }
            n += n4;
        }
    }

    @Override
    public Matrix derivative(Point2D point2D) {
        return this.derivative((DirectPosition)null);
    }

    @Override
    public Matrix derivative(DirectPosition directPosition) {
        GeneralMatrix generalMatrix = new GeneralMatrix(this.numRow, this.numCol, this.elt);
        generalMatrix.setSize(this.numRow - 1, this.numCol - 1);
        return generalMatrix;
    }

    @Override
    public Matrix getMatrix() {
        return MatrixFactory.create(this.numRow, this.numCol, this.elt);
    }

    @Override
    public int getSourceDimensions() {
        return this.numCol - 1;
    }

    @Override
    public int getTargetDimensions() {
        return this.numRow - 1;
    }

    @Override
    public boolean isIdentity() {
        if (this.numRow != this.numCol) {
            return false;
        }
        int n = 0;
        for (int i = 0; i < this.numRow; ++i) {
            for (int j = 0; j < this.numCol; ++j) {
                if (this.elt[n++] == (double)(j == i ? 1 : 0)) continue;
                return false;
            }
        }
        assert (this.isIdentity(0.0));
        return true;
    }

    @Override
    public boolean isIdentity(double d) {
        d = Math.abs(d);
        if (this.numRow != this.numCol) {
            return false;
        }
        int n = 0;
        for (int i = 0; i < this.numRow; ++i) {
            for (int j = 0; j < this.numCol; ++j) {
                double d2 = this.elt[n++];
                if (j == i) {
                    d2 -= 1.0;
                }
                if (Math.abs(d2) <= d) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized MathTransform inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            if (this.isIdentity()) {
                this.inverse = this;
            } else {
                XMatrix xMatrix = MatrixFactory.create(this.numRow, this.numCol, this.elt);
                xMatrix = MatrixUtilities.invert(xMatrix);
                ProjectiveTransform projectiveTransform = this.createInverse(xMatrix);
                projectiveTransform.inverse = this;
                this.inverse = projectiveTransform;
            }
        }
        return this.inverse;
    }

    ProjectiveTransform createInverse(Matrix matrix) {
        return new ProjectiveTransform(matrix);
    }

    @Override
    protected int computeHashCode() {
        return Utilities.hash((int)Arrays.hashCode(this.elt), (int)super.computeHashCode());
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (comparisonMode != ComparisonMode.STRICT) {
            return ProjectiveTransform.equals(this, object, comparisonMode);
        }
        if (super.equals(object, comparisonMode)) {
            ProjectiveTransform projectiveTransform = (ProjectiveTransform)object;
            return this.numRow == projectiveTransform.numRow && this.numCol == projectiveTransform.numCol && Arrays.equals(this.elt, projectiveTransform.elt);
        }
        return false;
    }
}

