/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.geotoolkit.display.shape.XRectangle2D;
import org.geotoolkit.geometry.AbstractEnvelope;
import org.geotoolkit.geometry.Envelope2D;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.geometry.GeneralEnvelope;
import org.geotoolkit.lang.Static;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.operation.matrix.XAffineTransform;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.Strings;
import org.geotoolkit.util.UnsupportedImplementationException;
import org.geotoolkit.util.logging.Logging;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class Envelopes
extends Static {
    private static final boolean[] CORNERS = new boolean[]{false, false, false, true, true, true, true, false, false, false};

    private Envelopes() {
    }

    public static Envelope getDomainOfValidity(CoordinateReferenceSystem coordinateReferenceSystem) {
        return CRS.getEnvelope(coordinateReferenceSystem);
    }

    public static Envelope transform(Envelope envelope, CoordinateReferenceSystem coordinateReferenceSystem) throws TransformException {
        CoordinateReferenceSystem coordinateReferenceSystem2;
        if (envelope != null && coordinateReferenceSystem != null && (coordinateReferenceSystem2 = envelope.getCoordinateReferenceSystem()) != null) {
            if (!CRS.equalsIgnoreMetadata(coordinateReferenceSystem2, coordinateReferenceSystem)) {
                CoordinateOperation coordinateOperation;
                CoordinateOperationFactory coordinateOperationFactory = CRS.getCoordinateOperationFactory(true);
                try {
                    coordinateOperation = coordinateOperationFactory.createOperation(coordinateReferenceSystem2, coordinateReferenceSystem);
                }
                catch (FactoryException factoryException) {
                    throw new TransformException(Errors.format((int)40), (Throwable)factoryException);
                }
                if (!coordinateOperation.getMathTransform().isIdentity()) {
                    envelope = Envelopes.transform(coordinateOperation, envelope);
                }
            }
            assert (CRS.equalsIgnoreMetadata(envelope.getCoordinateReferenceSystem(), coordinateReferenceSystem));
        }
        return envelope;
    }

    public static GeneralEnvelope transform(MathTransform mathTransform, Envelope envelope) throws TransformException {
        ArgumentChecks.ensureNonNull((String)"transform", (Object)mathTransform);
        return Envelopes.transform(mathTransform, envelope, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static GeneralEnvelope transform(MathTransform mathTransform, Envelope envelope, GeneralDirectPosition generalDirectPosition) throws TransformException {
        if (envelope == null) {
            return null;
        }
        if (mathTransform.isIdentity()) {
            GeneralEnvelope generalEnvelope = new GeneralEnvelope(envelope);
            generalEnvelope.setCoordinateReferenceSystem(null);
            if (generalDirectPosition != null) {
                int n = envelope.getDimension();
                while (--n >= 0) {
                    generalDirectPosition.setOrdinate(n, generalEnvelope.getMedian(n));
                }
            }
            return generalEnvelope;
        }
        int n = mathTransform.getSourceDimensions();
        if (envelope.getDimension() != n) {
            throw new MismatchedDimensionException(Errors.format((int)112, (Object)n, (Object)envelope.getDimension()));
        }
        int n2 = 0;
        GeneralEnvelope generalEnvelope = null;
        if (generalDirectPosition == null) {
            generalDirectPosition = new GeneralDirectPosition(mathTransform.getTargetDimensions());
        }
        GeneralDirectPosition generalDirectPosition2 = new GeneralDirectPosition(n);
        int n3 = n;
        while (--n3 >= 0) {
            generalDirectPosition2.setOrdinate(n3, envelope.getMinimum(n3));
        }
        block7: while (true) {
            if (generalDirectPosition != mathTransform.transform((DirectPosition)generalDirectPosition2, (DirectPosition)generalDirectPosition)) {
                throw new UnsupportedImplementationException(mathTransform.getClass());
            }
            if (generalEnvelope != null) {
                generalEnvelope.add(generalDirectPosition);
            } else {
                generalEnvelope = new GeneralEnvelope(generalDirectPosition, generalDirectPosition);
            }
            n3 = ++n2;
            int n4 = n;
            block8: while (true) {
                if (--n4 < 0) {
                    return generalEnvelope;
                }
                switch (n3 % 3) {
                    case 0: {
                        generalDirectPosition2.setOrdinate(n4, envelope.getMinimum(n4));
                        n3 /= 3;
                        continue block8;
                    }
                    case 1: {
                        generalDirectPosition2.setOrdinate(n4, envelope.getMaximum(n4));
                        continue block7;
                    }
                    case 2: {
                        generalDirectPosition2.setOrdinate(n4, envelope.getMedian(n4));
                        continue block7;
                    }
                }
                break;
            }
            break;
        }
        throw new AssertionError(n3);
    }

    public static GeneralEnvelope transform(CoordinateOperation coordinateOperation, Envelope envelope) throws TransformException {
        int n;
        int n2;
        int n3;
        Object object;
        Object object2;
        Object object3;
        CoordinateSystem coordinateSystem;
        GeneralDirectPosition generalDirectPosition;
        CoordinateReferenceSystem coordinateReferenceSystem;
        ArgumentChecks.ensureNonNull((String)"operation", (Object)coordinateOperation);
        if (envelope == null) {
            return null;
        }
        CoordinateReferenceSystem coordinateReferenceSystem2 = coordinateOperation.getSourceCRS();
        if (coordinateReferenceSystem2 != null && (coordinateReferenceSystem = envelope.getCoordinateReferenceSystem()) != null && !CRS.equalsIgnoreMetadata(coordinateReferenceSystem, coordinateReferenceSystem2)) {
            try {
                generalDirectPosition = CRS.findMathTransform(coordinateReferenceSystem, coordinateReferenceSystem2, false);
            }
            catch (FactoryException factoryException) {
                throw new TransformException(Errors.format((int)40), (Throwable)factoryException);
            }
            if (!generalDirectPosition.isIdentity()) {
                envelope = Envelopes.transform((MathTransform)generalDirectPosition, envelope);
            }
        }
        coordinateReferenceSystem = coordinateOperation.getMathTransform();
        generalDirectPosition = new GeneralDirectPosition(coordinateReferenceSystem.getTargetDimensions());
        GeneralEnvelope generalEnvelope = Envelopes.transform((MathTransform)coordinateReferenceSystem, envelope, generalDirectPosition);
        if (coordinateReferenceSystem2 != null && (coordinateSystem = coordinateReferenceSystem2.getCoordinateSystem()) != null) {
            object3 = null;
            object2 = null;
            int n4 = coordinateSystem.getDimension();
            for (int i = 0; i < n4; ++i) {
                object = coordinateSystem.getAxis(i);
                if (object == null) continue;
                double d = envelope.getMinimum(i);
                double d2 = envelope.getMaximum(i);
                double d3 = object.getMinimumValue();
                double d4 = object.getMaximumValue();
                n3 = d3 > d && d3 < d2 ? 1 : 0;
                int n5 = n2 = d4 > d && d4 < d2 ? 1 : 0;
                if (n3 == 0 && n2 == 0) continue;
                if (object3 == null) {
                    object3 = new GeneralDirectPosition(n4);
                    for (int j = 0; j < n4; ++j) {
                        object3.setOrdinate(j, envelope.getMedian(j));
                    }
                }
                if (n3 != 0) {
                    object3.setOrdinate(i, d3);
                    object2 = coordinateReferenceSystem.transform((DirectPosition)object3, object2);
                    generalEnvelope.add((DirectPosition)object2);
                }
                if (n2 != 0) {
                    object3.setOrdinate(i, d4);
                    object2 = coordinateReferenceSystem.transform((DirectPosition)object3, object2);
                    generalEnvelope.add((DirectPosition)object2);
                }
                object3.setOrdinate(i, envelope.getMedian(i));
            }
        }
        if ((coordinateSystem = coordinateOperation.getTargetCRS()) == null) {
            return generalEnvelope;
        }
        generalEnvelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)coordinateSystem);
        object3 = coordinateSystem.getCoordinateSystem();
        if (object3 == null) {
            return generalEnvelope;
        }
        object2 = null;
        GeneralEnvelope generalEnvelope2 = null;
        DirectPosition directPosition = null;
        object = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 1L;
        n3 = object3.getDimension();
        n2 = 0;
        while (n2 < n3) {
            CoordinateSystemAxis coordinateSystemAxis = object3.getAxis(n2);
            if (coordinateSystemAxis != null) {
                n = 0;
                do {
                    double d;
                    double d5 = d = n != 0 ? coordinateSystemAxis.getMaximumValue() : coordinateSystemAxis.getMinimumValue();
                    if (Double.isInfinite(d) || Double.isNaN(d)) continue;
                    if (object == null) {
                        try {
                            coordinateReferenceSystem = coordinateReferenceSystem.inverse();
                        }
                        catch (NoninvertibleTransformException noninvertibleTransformException) {
                            if (n3 >= coordinateReferenceSystem.getSourceDimensions()) {
                                Envelopes.recoverableException((Exception)((Object)noninvertibleTransformException));
                            }
                            return generalEnvelope;
                        }
                        object = new GeneralDirectPosition(coordinateReferenceSystem.getSourceDimensions());
                        for (int i = 0; i < n3; ++i) {
                            object.setOrdinate(i, generalDirectPosition.getOrdinate(i));
                        }
                        generalEnvelope2 = GeneralEnvelope.castOrCopy(envelope);
                    }
                    object.setOrdinate(n2, d);
                    try {
                        directPosition = coordinateReferenceSystem.transform((DirectPosition)object, directPosition);
                    }
                    catch (TransformException transformException) {
                        if (object2 != null) continue;
                        object2 = transformException;
                        continue;
                    }
                    if (!generalEnvelope2.contains(directPosition)) continue;
                    generalEnvelope.add((DirectPosition)object);
                    if (n != 0) {
                        l2 |= l4;
                        continue;
                    }
                    l |= l4;
                } while ((n = n == 0 ? 1 : 0) == 1);
                if ((l & l2 & l4) == 0L && Envelopes.isWrapAround(coordinateSystemAxis)) {
                    l3 |= l4;
                }
                if (object != null) {
                    object.setOrdinate(n2, generalDirectPosition.getOrdinate(n2));
                }
            }
            ++n2;
            l4 <<= 1;
        }
        long l5 = l | l2;
        if (l5 != 0L) {
            while (l3 != 0L) {
                long l6;
                n = Long.numberOfTrailingZeros(l3);
                l4 = 1 << n;
                l3 &= l4 ^ 0xFFFFFFFFFFFFFFFFL;
                CoordinateSystemAxis coordinateSystemAxis = object3.getAxis(n);
                double d = coordinateSystemAxis.getMinimumValue();
                double d6 = coordinateSystemAxis.getMaximumValue();
                for (long i = l5 & (l4 ^ 0xFFFFFFFFFFFFFFFFL); i != 0L; i &= l6 ^ 0xFFFFFFFFFFFFFFFFL) {
                    l6 = Long.lowestOneBit(i);
                    int n6 = Long.numberOfTrailingZeros(l6);
                    CoordinateSystemAxis coordinateSystemAxis2 = object3.getAxis(n6);
                    for (int j = 0; j < 4; ++j) {
                        double d7 = d6;
                        if ((j & 1) == 0) {
                            if (((j == 0 ? l : l2) & l6) == 0L) {
                                ++j;
                                continue;
                            }
                            object.setOrdinate(n6, j == 0 ? coordinateSystemAxis2.getMinimumValue() : coordinateSystemAxis2.getMaximumValue());
                            d7 = d;
                        }
                        object.setOrdinate(n, d7);
                        try {
                            directPosition = coordinateReferenceSystem.transform((DirectPosition)object, directPosition);
                        }
                        catch (TransformException transformException) {
                            if (object2 != null) continue;
                            object2 = transformException;
                            continue;
                        }
                        if (!generalEnvelope2.contains(directPosition)) continue;
                        generalEnvelope.add((DirectPosition)object);
                    }
                    object.setOrdinate(n6, generalDirectPosition.getOrdinate(n6));
                }
                object.setOrdinate(n, generalDirectPosition.getOrdinate(n));
            }
        }
        if (object2 != null) {
            Envelopes.recoverableException(object2);
        }
        return generalEnvelope;
    }

    public static Rectangle2D transform(MathTransform2D mathTransform2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) throws TransformException {
        ArgumentChecks.ensureNonNull((String)"transform", (Object)mathTransform2D);
        if (mathTransform2D instanceof AffineTransform) {
            return XAffineTransform.transform((AffineTransform)mathTransform2D, rectangle2D, rectangle2D2);
        }
        return Envelopes.transform(mathTransform2D, rectangle2D, rectangle2D2, new Point2D.Double());
    }

    private static Rectangle2D transform(MathTransform2D mathTransform2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, Point2D.Double double_) throws TransformException {
        if (rectangle2D == null) {
            return null;
        }
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i <= 8; ++i) {
            double_.x = (i & 1) == 0 ? rectangle2D.getMinX() : rectangle2D.getMaxX();
            double_.y = (i & 2) == 0 ? rectangle2D.getMinY() : rectangle2D.getMaxY();
            switch (i) {
                case 5: 
                case 6: {
                    double_.x = rectangle2D.getCenterX();
                    break;
                }
                case 8: {
                    double_.x = rectangle2D.getCenterX();
                }
                case 4: 
                case 7: {
                    double_.y = rectangle2D.getCenterY();
                }
            }
            if (double_ != mathTransform2D.transform((Point2D)double_, (Point2D)double_)) {
                throw new UnsupportedImplementationException(mathTransform2D.getClass());
            }
            if (double_.x < d) {
                d = double_.x;
            }
            if (double_.x > d3) {
                d3 = double_.x;
            }
            if (double_.y < d2) {
                d2 = double_.y;
            }
            if (!(double_.y > d4)) continue;
            d4 = double_.y;
        }
        if (rectangle2D2 != null) {
            rectangle2D2.setRect(d, d2, d3 - d, d4 - d2);
        } else {
            rectangle2D2 = XRectangle2D.createFromExtremums((double)d, (double)d2, (double)d3, (double)d4);
        }
        assert (rectangle2D2 == rectangle2D || !(rectangle2D2 instanceof Rectangle2D.Double) && !(rectangle2D2 instanceof Rectangle2D.Float) || XRectangle2D.equalsEpsilon((Rectangle2D)rectangle2D2, (Rectangle2D)Envelopes.transform((MathTransform)mathTransform2D, (Envelope)new Envelope2D(null, rectangle2D)).toRectangle2D())) : rectangle2D2;
        return rectangle2D2;
    }

    public static Rectangle2D transform(CoordinateOperation coordinateOperation, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) throws TransformException {
        int n;
        int n2;
        CoordinateSystem coordinateSystem;
        CoordinateSystem coordinateSystem2;
        ArgumentChecks.ensureNonNull((String)"operation", (Object)coordinateOperation);
        if (rectangle2D == null) {
            return null;
        }
        MathTransform mathTransform = coordinateOperation.getMathTransform();
        if (!(mathTransform instanceof MathTransform2D)) {
            throw new MismatchedDimensionException(Errors.format((int)168));
        }
        MathTransform2D mathTransform2D = (MathTransform2D)mathTransform;
        Point2D.Double double_ = new Point2D.Double();
        rectangle2D2 = Envelopes.transform(mathTransform2D, rectangle2D, rectangle2D2, double_);
        CoordinateReferenceSystem coordinateReferenceSystem = coordinateOperation.getSourceCRS();
        if (coordinateReferenceSystem != null && (coordinateSystem2 = coordinateReferenceSystem.getCoordinateSystem()) != null && coordinateSystem2.getDimension() == 2) {
            coordinateSystem = coordinateSystem2.getAxis(0);
            double d = rectangle2D.getMinX();
            double d2 = rectangle2D.getMaxX();
            Point2D.Double double_2 = null;
            for (n2 = 0; n2 < 4; ++n2) {
                double d3;
                if (n2 == 2) {
                    coordinateSystem = coordinateSystem2.getAxis(1);
                    d = rectangle2D.getMinY();
                    d2 = rectangle2D.getMaxY();
                }
                double d4 = d3 = (n2 & 1) == 0 ? coordinateSystem.getMinimumValue() : coordinateSystem.getMaximumValue();
                if (!(d3 > d) || !(d3 < d2)) continue;
                if (double_2 == null) {
                    double_2 = new Point2D.Double();
                }
                if ((n2 & 2) == 0) {
                    double_2.x = d3;
                    double_2.y = rectangle2D.getCenterY();
                } else {
                    double_2.x = rectangle2D.getCenterX();
                    double_2.y = d3;
                }
                rectangle2D2.add(mathTransform2D.transform((Point2D)double_2, (Point2D)double_2));
            }
        }
        if ((coordinateSystem2 = coordinateOperation.getTargetCRS()) == null) {
            return rectangle2D2;
        }
        coordinateSystem = coordinateSystem2.getCoordinateSystem();
        if (coordinateSystem == null || coordinateSystem.getDimension() != 2) {
            return rectangle2D2;
        }
        TransformException transformException = null;
        Point2D point2D = null;
        Point2D point2D2 = null;
        int n3 = 0;
        for (n = 0; n < 4; ++n) {
            double d;
            n2 = n >>> 1;
            CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(n2);
            if (coordinateSystemAxis == null) continue;
            double d5 = d = (n & 1) == 0 ? coordinateSystemAxis.getMinimumValue() : coordinateSystemAxis.getMaximumValue();
            if (Double.isInfinite(d) || Double.isNaN(d)) continue;
            if (point2D2 == null) {
                try {
                    mathTransform2D = mathTransform2D.inverse();
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    Envelopes.recoverableException((Exception)((Object)noninvertibleTransformException));
                    return rectangle2D2;
                }
                point2D2 = new Point2D.Double();
            }
            switch (n2) {
                case 0: {
                    point2D2.setLocation(d, double_.y);
                    break;
                }
                case 1: {
                    point2D2.setLocation(double_.x, d);
                    break;
                }
                default: {
                    throw new AssertionError(n);
                }
            }
            try {
                point2D = mathTransform2D.transform(point2D2, point2D);
            }
            catch (TransformException transformException2) {
                if (transformException != null) continue;
                transformException = transformException2;
                continue;
            }
            if (!rectangle2D.contains(point2D)) continue;
            rectangle2D2.add(point2D2);
            n3 |= 1 << n;
        }
        if (n3 != 0) {
            n = (n3 & 1) << 3 | (n3 & 4) >>> 1 | (n3 & 2) << 6 | (n3 & 8) << 2;
            n |= n >>> 1;
            if (((n &= ~(n3 | n3 << 4)) & 0x33333333) != 0 && !Envelopes.isWrapAround(coordinateSystem.getAxis(0))) {
                n &= 0xCCCCCCCC;
            }
            if ((n & 0xCCCCCCCC) != 0 && !Envelopes.isWrapAround(coordinateSystem.getAxis(1))) {
                n &= 0x33333333;
            }
            while (n != 0) {
                double d;
                n2 = Integer.numberOfTrailingZeros(n);
                int n4 = 1 << n2;
                n &= ~n4;
                int n5 = n2 >>> 1 & 1;
                CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(n5);
                CoordinateSystemAxis coordinateSystemAxis2 = coordinateSystem.getAxis(n5 ^ 1);
                double d6 = (n2 & 1) == 0 ? coordinateSystemAxis.getMinimumValue() : coordinateSystemAxis.getMaximumValue();
                double d7 = d = (n2 & 4) == 0 ? coordinateSystemAxis2.getMinimumValue() : coordinateSystemAxis2.getMaximumValue();
                if (n5 != 0) {
                    double d8 = d6;
                    d6 = d;
                    d = d8;
                }
                point2D2.setLocation(d6, d);
                try {
                    point2D = mathTransform2D.transform(point2D2, point2D);
                }
                catch (TransformException transformException3) {
                    if (transformException != null) continue;
                    transformException = transformException3;
                    continue;
                }
                if (!rectangle2D.contains(point2D)) continue;
                rectangle2D2.add(point2D2);
            }
        }
        if (transformException != null) {
            Envelopes.recoverableException(transformException);
        }
        assert (rectangle2D2 == rectangle2D || XRectangle2D.equalsEpsilon((Rectangle2D)rectangle2D2, (Rectangle2D)Envelopes.transform(coordinateOperation, (Envelope)new GeneralEnvelope(rectangle2D)).toRectangle2D())) : rectangle2D2;
        return rectangle2D2;
    }

    private static boolean isWrapAround(CoordinateSystemAxis coordinateSystemAxis) {
        return RangeMeaning.WRAPAROUND.equals((Object)coordinateSystemAxis.getRangeMeaning());
    }

    private static void recoverableException(Exception exception) {
        Logging.recoverableException(Envelopes.class, (String)"transform", (Throwable)exception);
    }

    public static Envelope parseWKT(String string) throws FactoryException {
        ArgumentChecks.ensureNonNull((String)"wkt", (Object)string);
        try {
            return new GeneralEnvelope(string);
        }
        catch (RuntimeException runtimeException) {
            throw new FactoryException(Errors.format((int)27, Envelope.class), (Throwable)runtimeException);
        }
    }

    public static String toWKT(Envelope envelope) {
        return AbstractEnvelope.toString(envelope);
    }

    public static String toPolygonWKT(Envelope envelope) {
        double d;
        int n;
        for (n = envelope.getDimension(); n != 0 && (Double.isNaN(d = envelope.getSpan(n - 1)) || Double.isInfinite(d)); --n) {
        }
        StringBuilder stringBuilder = new StringBuilder("POLYGON(");
        String string = "(";
        for (int i = 0; i < CORNERS.length; i += 2) {
            for (int j = 0; j < n; ++j) {
                double d2;
                switch (j) {
                    case 0: 
                    case 1: {
                        d2 = CORNERS[i + j] ? envelope.getMaximum(j) : envelope.getMinimum(j);
                        break;
                    }
                    default: {
                        d2 = envelope.getMedian(j);
                    }
                }
                Strings.trimFractionalPart((StringBuilder)stringBuilder.append(string).append(d2));
                string = " ";
            }
            string = ", ";
        }
        if (string == ", ") {
            stringBuilder.append(')');
        }
        return stringBuilder.append(')').toString();
    }
}

