/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.jaxb.referencing;

import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.geotoolkit.internal.jaxb.gco.Measure;
import org.geotoolkit.measure.Units;
import org.opengis.referencing.datum.Ellipsoid;

@XmlRootElement(name="SecondDefiningParameter", namespace="http://www.opengis.net/gml")
public final class SecondDefiningParameter {
    @XmlElement(name="SecondDefiningParameter", namespace="http://www.opengis.net/gml")
    public SecondDefiningParameter secondDefiningParameter;
    public Measure measure;

    public SecondDefiningParameter() {
    }

    public SecondDefiningParameter(Ellipsoid ellipsoid, boolean bl) {
        if (bl) {
            this.secondDefiningParameter = new SecondDefiningParameter(ellipsoid, false);
        } else if (ellipsoid.isIvfDefinitive()) {
            this.measure = new Measure(ellipsoid.getInverseFlattening(), Unit.ONE);
        } else {
            this.measure = new Measure(ellipsoid.getSemiMinorAxis(), ellipsoid.getAxisUnit());
            Units.ensureLinear((Unit)this.measure.unit);
        }
    }

    public boolean isIvfDefinitive() {
        return Unit.ONE.equals((Object)this.measure.unit);
    }

    @XmlElement(namespace="http://www.opengis.net/gml")
    public Measure getSemiMinorAxis() {
        return this.isIvfDefinitive() ? null : this.measure;
    }

    public void setSemiMinorAxis(Measure measure) {
        this.measure = measure;
        Units.ensureLinear((Unit)measure.unit);
    }

    @XmlElement(namespace="http://www.opengis.net/gml")
    public Measure getInverseFlattening() {
        return this.isIvfDefinitive() ? this.measure : null;
    }

    public void setInverseFlattening(Measure measure) {
        this.measure = measure;
        measure.unit = Unit.ONE;
    }
}

