/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.referencing;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.measure.quantity.Angle;
import javax.measure.unit.NonSI;
import javax.measure.unit.Unit;
import org.geotoolkit.internal.referencing.AxisDirections;
import org.geotoolkit.internal.referencing.VerticalDatumTypes;
import org.geotoolkit.lang.Static;
import org.geotoolkit.measure.Measure;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.crs.DefaultCompoundCRS;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.geotoolkit.referencing.cs.DefaultEllipsoidalCS;
import org.geotoolkit.referencing.datum.DefaultGeodeticDatum;
import org.geotoolkit.resources.Errors;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.TransformException;

public final class CRSUtilities
extends Static {
    private CRSUtilities() {
    }

    public static int dimensionColinearWith(CoordinateSystem coordinateSystem, CoordinateSystemAxis coordinateSystemAxis) {
        int n = -1;
        int n2 = coordinateSystem.getDimension();
        AxisDirection axisDirection = AxisDirections.absolute(coordinateSystemAxis.getDirection());
        for (int i = 0; i < n2; ++i) {
            CoordinateSystemAxis coordinateSystemAxis2 = coordinateSystem.getAxis(i);
            if (!axisDirection.equals((Object)AxisDirections.absolute(coordinateSystemAxis2.getDirection()))) continue;
            n = i;
            if (coordinateSystemAxis.equals(coordinateSystemAxis2)) break;
        }
        return n;
    }

    public static int dimensionColinearWith(CoordinateSystem coordinateSystem, CoordinateSystem coordinateSystem2) {
        int n;
        int n2 = CRSUtilities.dimensionColinearWith(coordinateSystem, coordinateSystem2.getAxis(0));
        if (n2 >= 0 && n2 + (n = coordinateSystem2.getDimension()) <= coordinateSystem.getDimension()) {
            while (--n > 0) {
                if (AxisDirections.absolute(coordinateSystem2.getAxis(n).getDirection()).equals((Object)AxisDirections.absolute(coordinateSystem.getAxis(n + n2).getDirection()))) continue;
                return -1;
            }
            return n2;
        }
        return -1;
    }

    public static Unit<?> getUnit(CoordinateSystem coordinateSystem) {
        Unit unit = null;
        int n = coordinateSystem.getDimension();
        while (--n >= 0) {
            Unit unit2 = coordinateSystem.getAxis(n).getUnit();
            if (unit2 == null) continue;
            if (unit == null) {
                unit = unit2;
                continue;
            }
            if (unit.equals((Object)unit2)) continue;
            return null;
        }
        return unit;
    }

    public static List<? extends CoordinateReferenceSystem> getComponents(CoordinateReferenceSystem coordinateReferenceSystem) {
        List list;
        if (coordinateReferenceSystem instanceof CompoundCRS && !(list = ((CompoundCRS)coordinateReferenceSystem).getComponents()).isEmpty()) {
            return list;
        }
        return null;
    }

    public static int getDimensionOf(CoordinateReferenceSystem coordinateReferenceSystem, Class<? extends CoordinateReferenceSystem> clazz) throws IllegalArgumentException {
        if (clazz.isAssignableFrom(coordinateReferenceSystem.getClass())) {
            return 0;
        }
        List<? extends CoordinateReferenceSystem> list = CRSUtilities.getComponents(coordinateReferenceSystem);
        if (list != null) {
            int n = 0;
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : list) {
                int n2 = CRSUtilities.getDimensionOf(coordinateReferenceSystem2, clazz);
                if (n2 >= 0) {
                    return n2 + n;
                }
                n += coordinateReferenceSystem2.getCoordinateSystem().getDimension();
            }
        }
        return -1;
    }

    public static CoordinateReferenceSystem getCRS2D(CoordinateReferenceSystem coordinateReferenceSystem) throws TransformException {
        if (coordinateReferenceSystem != null) {
            while (coordinateReferenceSystem.getCoordinateSystem().getDimension() != 2) {
                List<? extends CoordinateReferenceSystem> list = CRSUtilities.getComponents(coordinateReferenceSystem);
                if (list != null) {
                    coordinateReferenceSystem = list.get(0);
                    continue;
                }
                if ((coordinateReferenceSystem = CRS.getHorizontalCRS(coordinateReferenceSystem)) != null) continue;
                throw new TransformException(Errors.format((int)36, (Object)coordinateReferenceSystem.getName()));
            }
        }
        return coordinateReferenceSystem;
    }

    public static Map<String, ?> changeDimensionInName(IdentifiedObject identifiedObject, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(identifiedObject.getName().getCode());
        int n = stringBuilder.length() - string.length();
        boolean bl = true;
        int n2 = stringBuilder.lastIndexOf(string);
        while (n2 >= 0) {
            if (!(n2 != 0 && Character.isLetterOrDigit(stringBuilder.charAt(n2 - 1)) || n2 != n && Character.isLetterOrDigit(n2 + string.length()))) {
                stringBuilder.replace(n2, n2 + string.length(), string2);
                n2 = stringBuilder.indexOf(". ", n2);
                if (n2 >= 0) {
                    stringBuilder.setLength(n2 + 1);
                }
                bl = false;
                break;
            }
            n2 = stringBuilder.lastIndexOf(string, n2 - 1);
        }
        if (bl) {
            if (stringBuilder.indexOf(" ") >= 0) {
                stringBuilder.append(" (").append(string2).append(')');
            } else {
                stringBuilder.append('_').append(string2);
            }
        }
        return Collections.singletonMap("name", stringBuilder.toString());
    }

    public static double getGreenwichLongitude(PrimeMeridian primeMeridian, Unit<Angle> unit) {
        if (primeMeridian == null) {
            return 0.0;
        }
        return primeMeridian.getAngularUnit().getConverterTo(unit).convert(primeMeridian.getGreenwichLongitude());
    }

    public static double getGreenwichLongitude(PrimeMeridian primeMeridian) {
        return CRSUtilities.getGreenwichLongitude(primeMeridian, (Unit<Angle>)NonSI.DEGREE_ANGLE);
    }

    public static Datum getDatum(CoordinateReferenceSystem coordinateReferenceSystem) {
        Datum datum;
        if (coordinateReferenceSystem instanceof SingleCRS) {
            datum = ((SingleCRS)coordinateReferenceSystem).getDatum();
        } else {
            datum = null;
            for (SingleCRS singleCRS : DefaultCompoundCRS.getSingleCRS(coordinateReferenceSystem)) {
                Datum datum2 = singleCRS.getDatum();
                if (datum != null && !datum.equals(datum2)) {
                    if (CRSUtilities.isGeodetic3D(datum, datum2)) continue;
                    if (!CRSUtilities.isGeodetic3D(datum2, datum)) {
                        return null;
                    }
                }
                datum = datum2;
            }
        }
        return datum;
    }

    private static boolean isGeodetic3D(Datum datum, Datum datum2) {
        return datum instanceof GeodeticDatum && datum2 instanceof VerticalDatum && VerticalDatumTypes.ELLIPSOIDAL.equals((Object)((VerticalDatum)datum2).getVerticalDatumType());
    }

    public static Ellipsoid getHeadGeoEllipsoid(CoordinateReferenceSystem coordinateReferenceSystem) {
        while (!(coordinateReferenceSystem instanceof GeographicCRS)) {
            List<? extends CoordinateReferenceSystem> list = CRSUtilities.getComponents(coordinateReferenceSystem);
            if (list == null) {
                return null;
            }
            coordinateReferenceSystem = list.get(0);
        }
        return ((GeographicCRS)coordinateReferenceSystem).getDatum().getEllipsoid();
    }

    public static GeographicCRS getStandardGeographicCRS2D(CoordinateReferenceSystem coordinateReferenceSystem) {
        while (coordinateReferenceSystem instanceof GeneralDerivedCRS) {
            coordinateReferenceSystem = ((GeneralDerivedCRS)coordinateReferenceSystem).getBaseCRS();
        }
        if (!(coordinateReferenceSystem instanceof SingleCRS)) {
            return DefaultGeographicCRS.WGS84;
        }
        Datum datum = ((SingleCRS)coordinateReferenceSystem).getDatum();
        if (!(datum instanceof GeodeticDatum)) {
            return DefaultGeographicCRS.WGS84;
        }
        GeodeticDatum geodeticDatum = (GeodeticDatum)datum;
        if (geodeticDatum.getPrimeMeridian().getGreenwichLongitude() != 0.0) {
            geodeticDatum = new DefaultGeodeticDatum(geodeticDatum.getName().getCode(), geodeticDatum.getEllipsoid());
        } else if (coordinateReferenceSystem instanceof GeographicCRS && CRS.equalsIgnoreMetadata(DefaultEllipsoidalCS.GEODETIC_2D, coordinateReferenceSystem.getCoordinateSystem())) {
            return (GeographicCRS)coordinateReferenceSystem;
        }
        return new DefaultGeographicCRS(coordinateReferenceSystem.getName().getCode(), geodeticDatum, (EllipsoidalCS)DefaultEllipsoidalCS.GEODETIC_2D);
    }

    public static Measure getHorizontalResolution(CoordinateReferenceSystem coordinateReferenceSystem, double ... dArray) {
        int n;
        CoordinateSystem coordinateSystem;
        Unit<?> unit;
        SingleCRS singleCRS;
        if (dArray != null && (singleCRS = CRS.getHorizontalCRS(coordinateReferenceSystem)) != null && (unit = CRSUtilities.getUnit(coordinateSystem = singleCRS.getCoordinateSystem())) != null && (n = CRSUtilities.dimensionColinearWith(coordinateReferenceSystem.getCoordinateSystem(), coordinateSystem)) >= 0) {
            int n2 = coordinateSystem.getDimension();
            double d = Double.POSITIVE_INFINITY;
            for (int i = n; i < n2; ++i) {
                double d2 = dArray[i];
                if (!(d2 > 0.0) || !(d2 < d)) continue;
                d = d2;
            }
            if (d != Double.POSITIVE_INFINITY) {
                return new Measure(d, unit);
            }
        }
        return null;
    }
}

