/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.referencing;

import java.io.Serializable;
import org.geotoolkit.io.wkt.Formattable;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.io.wkt.UnformattableObjectException;
import org.geotoolkit.util.NullArgumentException;
import org.geotoolkit.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.TransformException;

public final class MathTransformDecorator
implements MathTransform,
Formattable,
Serializable {
    private static final long serialVersionUID = 8844242705205498128L;
    public final MathTransform transform;
    public final OperationMethod method;

    public MathTransformDecorator(MathTransform mathTransform, OperationMethod operationMethod) {
        this.transform = mathTransform;
        if (mathTransform == null) {
            throw new NullArgumentException("transform");
        }
        this.method = operationMethod;
        if (operationMethod == null) {
            throw new NullArgumentException("method");
        }
        if (!MathTransformDecorator.equals(mathTransform.getSourceDimensions(), operationMethod.getSourceDimensions()) || !MathTransformDecorator.equals(mathTransform.getTargetDimensions(), operationMethod.getTargetDimensions())) {
            throw new MismatchedDimensionException();
        }
    }

    private static boolean equals(int n, Integer n2) {
        return n2 == null || n == n2;
    }

    public int getSourceDimensions() {
        return this.transform.getTargetDimensions();
    }

    public int getTargetDimensions() {
        return this.transform.getSourceDimensions();
    }

    public DirectPosition transform(DirectPosition directPosition, DirectPosition directPosition2) throws MismatchedDimensionException, TransformException {
        return this.transform.transform(directPosition, directPosition2);
    }

    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
        this.transform.transform(dArray, n, dArray2, n2, n3);
    }

    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) throws TransformException {
        this.transform.transform(fArray, n, fArray2, n2, n3);
    }

    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) throws TransformException {
        this.transform.transform(fArray, n, dArray, n2, n3);
    }

    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) throws TransformException {
        this.transform.transform(dArray, n, fArray, n2, n3);
    }

    public Matrix derivative(DirectPosition directPosition) throws TransformException {
        return this.transform.derivative(directPosition);
    }

    public MathTransform inverse() throws NoninvertibleTransformException {
        return this.transform.inverse();
    }

    public boolean isIdentity() {
        return this.transform.isIdentity();
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            MathTransformDecorator mathTransformDecorator = (MathTransformDecorator)object;
            return Utilities.equals((Object)this.transform, (Object)mathTransformDecorator.transform);
        }
        return false;
    }

    public int hashCode() {
        return this.transform.hashCode() ^ 0xAF1D1110;
    }

    public String toWKT() throws UnsupportedOperationException {
        return this.transform.toWKT();
    }

    public String toString() {
        return this.transform.toString();
    }

    @Override
    public String formatWKT(Formatter formatter) {
        if (this.transform instanceof Formattable) {
            return ((Formattable)this.transform).formatWKT(formatter);
        }
        throw new UnformattableObjectException(this.getClass());
    }
}

