/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.referencing;

import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.geotoolkit.factory.Factories;
import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.geometry.Envelopes;
import org.geotoolkit.internal.referencing.CRSUtilities;
import org.geotoolkit.internal.referencing.ProxyForMetadata;
import org.geotoolkit.metadata.iso.extent.DefaultExtent;
import org.geotoolkit.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.geotoolkit.metadata.iso.extent.DefaultTemporalExtent;
import org.geotoolkit.metadata.iso.extent.DefaultVerticalExtent;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.geotoolkit.referencing.crs.DefaultTemporalCRS;
import org.geotoolkit.referencing.operation.TransformPathNotFoundException;
import org.geotoolkit.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class ProxyForMetadataImpl
extends ProxyForMetadata
implements ChangeListener {
    private CoordinateOperationFactory factory;

    ProxyForMetadataImpl() {
        Factories.addChangeListener((ChangeListener)this);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.factory = null;
    }

    private CoordinateOperationFactory getFactory() {
        if (this.factory == null) {
            Hints hints = new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE);
            this.factory = FactoryFinder.getCoordinateOperationFactory((Hints)hints);
        }
        return this.factory;
    }

    public void copy(Rectangle2D rectangle2D, CoordinateReferenceSystem coordinateReferenceSystem, DefaultGeographicBoundingBox defaultGeographicBoundingBox) throws TransformException {
        if (coordinateReferenceSystem != null) {
            if ((coordinateReferenceSystem = CRS.getHorizontalCRS(coordinateReferenceSystem)) == null) {
                throw new TransformPathNotFoundException(Errors.format((int)77));
            }
            GeographicCRS geographicCRS = CRSUtilities.getStandardGeographicCRS2D(coordinateReferenceSystem);
            if (!CRS.equalsIgnoreMetadata(coordinateReferenceSystem, geographicCRS)) {
                CoordinateOperation coordinateOperation;
                try {
                    coordinateOperation = this.getFactory().createOperation(coordinateReferenceSystem, (CoordinateReferenceSystem)geographicCRS);
                }
                catch (FactoryException factoryException) {
                    throw new TransformPathNotFoundException(factoryException);
                }
                rectangle2D = Envelopes.transform(coordinateOperation, rectangle2D, null);
            }
        }
        defaultGeographicBoundingBox.setBounds(rectangle2D);
    }

    public void copy(Envelope envelope, DefaultGeographicBoundingBox defaultGeographicBoundingBox) throws TransformException {
        GeographicCRS geographicCRS;
        CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
        if (!(coordinateReferenceSystem == null || ProxyForMetadataImpl.startsWith(coordinateReferenceSystem, (CoordinateReferenceSystem)(geographicCRS = CRSUtilities.getStandardGeographicCRS2D(coordinateReferenceSystem))) || ProxyForMetadataImpl.startsWith(coordinateReferenceSystem, DefaultGeographicCRS.WGS84) || ProxyForMetadataImpl.startsWith(coordinateReferenceSystem, DefaultGeographicCRS.WGS84_3D))) {
            CoordinateOperation coordinateOperation;
            CoordinateOperationFactory coordinateOperationFactory = this.getFactory();
            try {
                coordinateOperation = coordinateOperationFactory.createOperation(coordinateReferenceSystem, (CoordinateReferenceSystem)geographicCRS);
            }
            catch (FactoryException factoryException) {
                throw new TransformPathNotFoundException(Errors.format((int)40, (Object)((Object)factoryException)));
            }
            envelope = Envelopes.transform(coordinateOperation, envelope);
        }
        defaultGeographicBoundingBox.setBounds(envelope.getMinimum(0), envelope.getMaximum(0), envelope.getMinimum(1), envelope.getMaximum(1));
    }

    private static boolean startsWith(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) {
        int n = coordinateReferenceSystem2.getCoordinateSystem().getDimension();
        return coordinateReferenceSystem.getCoordinateSystem().getDimension() >= n && CRS.equalsIgnoreMetadata(CRS.getSubCRS(coordinateReferenceSystem, 0, n), coordinateReferenceSystem2);
    }

    public void copy(Envelope envelope, DefaultVerticalExtent defaultVerticalExtent) throws TransformException {
        CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
        VerticalCRS verticalCRS = CRS.getVerticalCRS(coordinateReferenceSystem);
        if (verticalCRS == null && envelope.getDimension() != 1) {
            throw new TransformPathNotFoundException(Errors.format((int)77));
        }
        this.copy(envelope, defaultVerticalExtent, coordinateReferenceSystem, verticalCRS);
    }

    public void copy(Envelope envelope, DefaultTemporalExtent defaultTemporalExtent) throws TransformException {
        CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
        TemporalCRS temporalCRS = CRS.getTemporalCRS(coordinateReferenceSystem);
        if (temporalCRS == null) {
            throw new TransformPathNotFoundException(Errors.format((int)77));
        }
        this.copy(envelope, defaultTemporalExtent, coordinateReferenceSystem, temporalCRS);
    }

    private void copy(Envelope envelope, DefaultVerticalExtent defaultVerticalExtent, CoordinateReferenceSystem coordinateReferenceSystem, VerticalCRS verticalCRS) throws TransformException {
        int n;
        int n2 = n = verticalCRS == null ? 0 : CRSUtilities.dimensionColinearWith(coordinateReferenceSystem.getCoordinateSystem(), (CoordinateSystem)verticalCRS.getCoordinateSystem());
        if (n >= 0) {
            defaultVerticalExtent.setMinimumValue(Double.valueOf(envelope.getMinimum(n)));
            defaultVerticalExtent.setMaximumValue(Double.valueOf(envelope.getMaximum(n)));
        }
        defaultVerticalExtent.setVerticalCRS(verticalCRS);
    }

    private void copy(Envelope envelope, DefaultTemporalExtent defaultTemporalExtent, CoordinateReferenceSystem coordinateReferenceSystem, TemporalCRS temporalCRS) throws TransformException {
        int n = CRSUtilities.dimensionColinearWith(coordinateReferenceSystem.getCoordinateSystem(), (CoordinateSystem)temporalCRS.getCoordinateSystem());
        if (n >= 0) {
            DefaultTemporalCRS defaultTemporalCRS = DefaultTemporalCRS.castOrCopy(temporalCRS);
            defaultTemporalExtent.setStartTime(defaultTemporalCRS.toDate(envelope.getMinimum(n)));
            defaultTemporalExtent.setEndTime(defaultTemporalCRS.toDate(envelope.getMaximum(n)));
        }
    }

    public void copy(Envelope envelope, DefaultExtent defaultExtent) throws TransformException {
        TemporalCRS temporalCRS;
        VerticalCRS verticalCRS;
        CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
        if (CRS.getHorizontalCRS(coordinateReferenceSystem) != null) {
            verticalCRS = new DefaultGeographicBoundingBox();
            verticalCRS.setInclusion(Boolean.TRUE);
            this.copy(envelope, (DefaultGeographicBoundingBox)verticalCRS);
            defaultExtent.getGeographicElements().add(verticalCRS);
        }
        if ((verticalCRS = CRS.getVerticalCRS(coordinateReferenceSystem)) != null) {
            temporalCRS = new DefaultVerticalExtent();
            this.copy(envelope, (DefaultVerticalExtent)temporalCRS, coordinateReferenceSystem, verticalCRS);
            defaultExtent.getVerticalElements().add(temporalCRS);
        }
        if ((temporalCRS = CRS.getTemporalCRS(coordinateReferenceSystem)) != null) {
            DefaultTemporalExtent defaultTemporalExtent = new DefaultTemporalExtent();
            this.copy(envelope, defaultTemporalExtent, coordinateReferenceSystem, temporalCRS);
            defaultExtent.getTemporalElements().add(defaultTemporalExtent);
        }
    }
}

