/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.referencing.factory;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.geotoolkit.metadata.iso.DefaultIdentifier;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.metadata.iso.citation.DefaultCitation;
import org.geotoolkit.metadata.iso.citation.DefaultContact;
import org.geotoolkit.metadata.iso.citation.DefaultOnlineResource;
import org.geotoolkit.metadata.iso.citation.DefaultResponsibleParty;
import org.geotoolkit.referencing.DefaultReferenceIdentifier;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.geotoolkit.referencing.cs.DefaultCartesianCS;
import org.geotoolkit.referencing.cs.DefaultEllipsoidalCS;
import org.geotoolkit.referencing.datum.DefaultEllipsoid;
import org.geotoolkit.referencing.datum.DefaultGeodeticDatum;
import org.geotoolkit.referencing.factory.DirectAuthorityFactory;
import org.geotoolkit.referencing.operation.DefiningConversion;
import org.geotoolkit.util.SimpleInternationalString;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.Conversion;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

public final class IGNF
extends DirectAuthorityFactory
implements CRSAuthorityFactory {
    private static final Citation AUTHORITY;
    private final Map<String, Object> crsMap = new TreeMap<String, Object>();
    private final Set<String> codes;

    public IGNF() {
        super(EMPTY_HINTS);
        this.crsMap.put("MILLER", "Miller_Cylindrical");
        this.codes = Collections.unmodifiableSet(this.crsMap.keySet());
    }

    @Override
    public Citation getAuthority() {
        return AUTHORITY;
    }

    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> clazz) {
        return clazz.isAssignableFrom(ProjectedCRS.class) ? this.codes : Collections.emptySet();
    }

    public InternationalString getDescriptionText(String string) throws FactoryException {
        return new SimpleInternationalString(this.createObject(string).getName().getCode());
    }

    @Override
    public IdentifiedObject createObject(String string) throws FactoryException {
        return this.createCoordinateReferenceSystem(string);
    }

    @Override
    public synchronized CoordinateReferenceSystem createCoordinateReferenceSystem(String string) throws FactoryException {
        String string2 = this.trimAuthority(string).toUpperCase();
        Object object = this.crsMap.get(string2);
        if (object == null) {
            throw this.noSuchAuthorityCode(CoordinateReferenceSystem.class, string);
        }
        if (object instanceof CoordinateReferenceSystem) {
            return (CoordinateReferenceSystem)object;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("name", (Object)new NamedIdentifier(Citations.OGC, "GRS80"));
        DefaultGeodeticDatum defaultGeodeticDatum = new DefaultGeodeticDatum(hashMap, (Ellipsoid)DefaultEllipsoid.GRS80);
        ParameterValueGroup parameterValueGroup = this.factories.getMathTransformFactory().getDefaultParameters((String)object);
        parameterValueGroup.parameter("semi-major axis").setValue(6378137);
        parameterValueGroup.parameter("semi-minor axis").setValue(6378137);
        ReferenceIdentifier[] referenceIdentifierArray = new ReferenceIdentifier[]{new NamedIdentifier(AUTHORITY, "MILLER"), new DefaultReferenceIdentifier((Citation)Citations.EPSG, "EPSG", "310642901"), new DefaultReferenceIdentifier((Citation)Citations.EPSG, "EPSG", "54003")};
        hashMap.clear();
        hashMap.put("name", referenceIdentifierArray[0]);
        hashMap.put("identifiers", referenceIdentifierArray);
        ProjectedCRS projectedCRS = this.factories.getCRSFactory().createProjectedCRS(hashMap, (GeographicCRS)new DefaultGeographicCRS(defaultGeodeticDatum, DefaultEllipsoidalCS.GEODETIC_2D), (Conversion)new DefiningConversion("Miller", parameterValueGroup), (CartesianCS)DefaultCartesianCS.PROJECTED);
        this.crsMap.put(string2, projectedCRS);
        return projectedCRS;
    }

    static {
        DefaultResponsibleParty defaultResponsibleParty = new DefaultResponsibleParty(Role.RESOURCE_PROVIDER);
        defaultResponsibleParty.setOrganisationName((InternationalString)new SimpleInternationalString("Institut G\u00e9ographique National"));
        defaultResponsibleParty.setContactInfo((Contact)new DefaultContact((OnlineResource)new DefaultOnlineResource(URI.create("http://www.ign.fr"))));
        DefaultCitation defaultCitation = new DefaultCitation((ResponsibleParty)defaultResponsibleParty);
        defaultCitation.getIdentifiers().add(new DefaultIdentifier("IGNF"));
        defaultCitation.getPresentationForms().add(PresentationForm.TABLE_DIGITAL);
        defaultCitation.freeze();
        AUTHORITY = defaultCitation;
    }
}

