/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.io.wkt;

import java.io.Console;
import java.io.PrintWriter;
import org.geotoolkit.io.X364;
import org.geotoolkit.io.wkt.Colors;
import org.geotoolkit.io.wkt.Formattable;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.io.wkt.UnformattableObjectException;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.metadata.iso.citation.DefaultCitation;
import org.geotoolkit.metadata.iso.citation.DefaultResponsibleParty;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.NullArgumentException;
import org.geotoolkit.util.converter.Classes;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterValue;

public class FormattableObject
implements Formattable {
    private static final ThreadLocal<Formatter> FORMATTER = new ThreadLocal();
    public static final int SINGLE_LINE = 0;
    public static final Citation OGC = Citations.OGC;
    public static final Citation EPSG = Citations.EPSG;
    public static final Citation GEOTIFF = Citations.GEOTIFF;
    public static final Citation INTERNAL;
    private static volatile int defaultIndentation;

    protected FormattableObject() {
    }

    public void print() {
        PrintWriter printWriter = null;
        Console console = System.console();
        if (console != null) {
            printWriter = console.writer();
        }
        boolean bl = printWriter != null && X364.isSupported();
        String string = this.formatWKT(OGC, defaultIndentation, bl, false);
        if (printWriter != null) {
            printWriter.println(string);
        } else {
            System.out.println(string);
        }
    }

    public String toString() {
        return this.formatWKT(OGC, defaultIndentation, false, false);
    }

    public String toWKT() throws UnformattableObjectException {
        return this.formatWKT(OGC, defaultIndentation, false, true);
    }

    public String toWKT(int n) throws UnformattableObjectException {
        return this.formatWKT(OGC, n, false, true);
    }

    public String toWKT(Citation citation, int n) throws UnformattableObjectException {
        return this.formatWKT(citation, n, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatWKT(Citation citation, int n, boolean bl, boolean bl2) throws UnformattableObjectException {
        if (citation == null) {
            throw new NullArgumentException(Errors.format((int)172, (Object)"authority"));
        }
        Formatter formatter = FORMATTER.get();
        if (formatter == null) {
            formatter = new Formatter();
            FORMATTER.set(formatter);
        }
        Citation citation2 = formatter.authority;
        formatter.authority = citation;
        formatter.indentation = n;
        formatter.colors = bl ? Colors.DEFAULT : null;
        try {
            if (this instanceof GeneralParameterValue) {
                formatter.append((GeneralParameterValue)this);
            } else {
                formatter.append(this);
            }
            if (bl2 && formatter.isInvalidWKT() && !INTERNAL.equals(citation)) {
                Class<?> clazz = formatter.getUnformattableClass();
                throw new UnformattableObjectException(formatter.warning, clazz);
            }
            String string = formatter.toString();
            return string;
        }
        finally {
            formatter.clear();
            formatter.authority = citation2;
        }
    }

    @Override
    public String formatWKT(Formatter formatter) {
        Class<?>[] classArray;
        Class<?> clazz = this.getClass();
        formatter.setInvalidWKT(clazz);
        for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
            String string = clazz2.getName();
            if (!string.startsWith("org.opengis.") || string.startsWith("org.opengis.util.")) continue;
            clazz = clazz2;
            break;
        }
        return Classes.getShortName(clazz);
    }

    public static int getDefaultIndentation() {
        return defaultIndentation;
    }

    public static void setDefaultIndentation(int n) {
        defaultIndentation = n;
    }

    static {
        DefaultCitation defaultCitation = new DefaultCitation((CharSequence)"Internal WKT");
        defaultCitation.getCitedResponsibleParties().add(DefaultResponsibleParty.GEOTOOLKIT);
        defaultCitation.freeze();
        INTERNAL = defaultCitation;
        defaultIndentation = 2;
    }
}

