/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.parameter;

import java.net.URI;
import javax.measure.converter.ConversionException;
import javax.measure.unit.Unit;
import org.geotoolkit.parameter.AbstractParameter;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.Utilities;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterTypeException;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;

public class FloatParameter
extends AbstractParameter
implements ParameterValue<Double> {
    private static final long serialVersionUID = 9027797654033417816L;
    private double value;

    public FloatParameter(ParameterDescriptor<Double> parameterDescriptor) {
        super((GeneralParameterDescriptor)parameterDescriptor);
        Class clazz = parameterDescriptor.getValueClass();
        Class<Double> clazz2 = Double.class;
        if (!clazz2.equals((Object)clazz) && !Double.TYPE.equals(clazz)) {
            throw new IllegalArgumentException(Errors.format((int)76, (Object)clazz, clazz2));
        }
        Number number = (Number)parameterDescriptor.getDefaultValue();
        this.value = number != null ? number.doubleValue() : Double.NaN;
    }

    public FloatParameter(ParameterDescriptor<Double> parameterDescriptor, double d) {
        this(parameterDescriptor);
        this.setValue(d);
    }

    public ParameterDescriptor<Double> getDescriptor() {
        return (ParameterDescriptor)this.descriptor;
    }

    public Unit<?> getUnit() {
        return ((ParameterDescriptor)this.descriptor).getUnit();
    }

    public double doubleValue(Unit<?> unit) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull((String)"unit", unit);
        Unit<?> unit2 = this.getUnit();
        if (unit2 == null) {
            throw FloatParameter.unitlessParameter(this.descriptor);
        }
        int n = FloatParameter.getUnitMessageID(unit2);
        if (FloatParameter.getUnitMessageID(unit) != n) {
            throw new IllegalArgumentException(Errors.format((int)n, unit));
        }
        try {
            return unit2.getConverterToAny(unit).convert(this.value);
        }
        catch (ConversionException conversionException) {
            throw new IllegalArgumentException(Errors.format((int)92, unit), conversionException);
        }
    }

    public double doubleValue() {
        return this.value;
    }

    public int intValue() {
        return (int)Math.round(this.value);
    }

    public boolean booleanValue() {
        return this.value != 0.0 && !Double.isNaN(this.value);
    }

    public String stringValue() {
        return String.valueOf(this.value);
    }

    public double[] doubleValueList(Unit<?> unit) throws IllegalArgumentException {
        return new double[]{this.doubleValue(unit)};
    }

    public double[] doubleValueList() {
        return new double[]{this.doubleValue()};
    }

    public int[] intValueList() {
        return new int[]{this.intValue()};
    }

    public URI valueFile() throws InvalidParameterTypeException {
        throw new InvalidParameterTypeException(FloatParameter.getClassTypeError(), FloatParameter.getName(this.descriptor));
    }

    private static String getClassTypeError() {
        return Errors.format((int)87, Double.class);
    }

    public Double getValue() {
        return this.value;
    }

    public void setValue(double d, Unit<?> unit) throws InvalidParameterValueException {
        ArgumentChecks.ensureNonNull((String)"unit", unit);
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)this.descriptor;
        Unit unit2 = parameterDescriptor.getUnit();
        if (unit2 == null) {
            throw FloatParameter.unitlessParameter((GeneralParameterDescriptor)parameterDescriptor);
        }
        int n = FloatParameter.getUnitMessageID(unit2);
        if (FloatParameter.getUnitMessageID(unit) != n) {
            throw new IllegalArgumentException(Errors.format((int)n, unit));
        }
        try {
            d = unit.getConverterToAny(unit2).convert(d);
        }
        catch (ConversionException conversionException) {
            throw new IllegalArgumentException(Errors.format((int)92, unit), conversionException);
        }
        this.value = (Double)FloatParameter.ensureValidValue(parameterDescriptor, d);
    }

    public void setValue(double d) throws InvalidParameterValueException {
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)this.descriptor;
        this.value = (Double)FloatParameter.ensureValidValue(parameterDescriptor, d);
    }

    public void setValue(int n) throws InvalidParameterValueException {
        this.setValue((double)n);
    }

    public void setValue(boolean bl) throws InvalidParameterValueException {
        this.setValue(bl ? 1.0 : 0.0);
    }

    public void setValue(Object object) throws InvalidParameterValueException {
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)this.descriptor;
        this.value = (Double)FloatParameter.ensureValidValue(parameterDescriptor, object);
    }

    public void setValue(double[] dArray, Unit<?> unit) throws InvalidParameterValueException {
        throw new InvalidParameterTypeException(FloatParameter.getClassTypeError(), FloatParameter.getName(this.descriptor));
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            FloatParameter floatParameter = (FloatParameter)object;
            return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(floatParameter.value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Utilities.hash((double)this.value, (int)super.hashCode());
    }

    @Override
    public FloatParameter clone() {
        return (FloatParameter)super.clone();
    }
}

