/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.parameter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotoolkit.parameter.AbstractParameter;
import org.geotoolkit.parameter.DefaultParameterDescriptorGroup;
import org.geotoolkit.parameter.ParameterValueList;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.XCollections;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterCardinalityException;
import org.opengis.parameter.InvalidParameterTypeException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;

public class ParameterGroup
extends AbstractParameter
implements ParameterValueGroup {
    private static final long serialVersionUID = -1985309386356545126L;
    public static final ParameterValueGroup EMPTY = new ParameterGroup(Collections.singletonMap("name", "Void"), new GeneralParameterValue[0]);
    private ArrayList<GeneralParameterValue> values;
    private transient List<GeneralParameterValue> asList;

    public ParameterGroup(ParameterDescriptorGroup parameterDescriptorGroup) {
        super((GeneralParameterDescriptor)parameterDescriptorGroup);
        List list = parameterDescriptorGroup.descriptors();
        this.values = new ArrayList(list.size());
        for (GeneralParameterDescriptor generalParameterDescriptor : list) {
            int n = generalParameterDescriptor.getMinimumOccurs();
            while (--n >= 0) {
                GeneralParameterValue generalParameterValue = generalParameterDescriptor.createValue();
                ArgumentChecks.ensureNonNull((String)"createValue", (Object)generalParameterValue);
                this.values.add(generalParameterValue);
            }
        }
    }

    public ParameterGroup(ParameterDescriptorGroup parameterDescriptorGroup, GeneralParameterValue ... generalParameterValueArray) {
        super((GeneralParameterDescriptor)parameterDescriptorGroup);
        ArgumentChecks.ensureNonNull((String)"values", (Object)generalParameterValueArray);
        this.values = new ArrayList<GeneralParameterValue>(Arrays.asList(generalParameterValueArray));
        List list = parameterDescriptorGroup.descriptors();
        LinkedHashMap<GeneralParameterDescriptor, int[]> linkedHashMap = new LinkedHashMap<GeneralParameterDescriptor, int[]>(XCollections.hashMapCapacity((int)list.size()));
        for (GeneralParameterDescriptor generalParameterDescriptor : list) {
            ArgumentChecks.ensureNonNull((String)"parameters", (Object)generalParameterDescriptor);
            linkedHashMap.put(generalParameterDescriptor, new int[1]);
        }
        ParameterGroup.ensureValidOccurs(generalParameterValueArray, linkedHashMap);
    }

    public ParameterGroup(Map<String, ?> map, GeneralParameterValue ... generalParameterValueArray) {
        super((GeneralParameterDescriptor)ParameterGroup.createDescriptor(map, generalParameterValueArray));
        this.values = new ArrayList<GeneralParameterValue>(Arrays.asList(generalParameterValueArray));
    }

    private static ParameterDescriptorGroup createDescriptor(Map<String, ?> map, GeneralParameterValue[] generalParameterValueArray) {
        ArgumentChecks.ensureNonNull((String)"values", (Object)generalParameterValueArray);
        LinkedHashMap<GeneralParameterDescriptor, int[]> linkedHashMap = new LinkedHashMap<GeneralParameterDescriptor, int[]>(XCollections.hashMapCapacity((int)generalParameterValueArray.length));
        for (int i = 0; i < generalParameterValueArray.length; ++i) {
            ArgumentChecks.ensureNonNull((String)"values", (int)i, (Object[])generalParameterValueArray);
            linkedHashMap.put(generalParameterValueArray[i].getDescriptor(), new int[1]);
        }
        ParameterGroup.ensureValidOccurs(generalParameterValueArray, linkedHashMap);
        Set set = linkedHashMap.keySet();
        return new DefaultParameterDescriptorGroup(map, set.toArray(new GeneralParameterDescriptor[set.size()]));
    }

    private static void ensureValidOccurs(GeneralParameterValue[] generalParameterValueArray, Map<GeneralParameterDescriptor, int[]> map) {
        Object object;
        for (int i = 0; i < generalParameterValueArray.length; ++i) {
            ArgumentChecks.ensureNonNull((String)"values", (int)i, (Object[])generalParameterValueArray);
            GeneralParameterDescriptor object2 = generalParameterValueArray[i].getDescriptor();
            object = map.get(object2);
            if (object == null) {
                String string = ParameterGroup.getName(object2);
                throw new InvalidParameterTypeException(Errors.format((int)80, (Object)string), string);
            }
            object[0] = object[0] + 1;
        }
        for (Map.Entry<GeneralParameterDescriptor, int[]> entry : map.entrySet()) {
            object = entry.getKey();
            int n = entry.getValue()[0];
            int n2 = object.getMinimumOccurs();
            int n3 = object.getMaximumOccurs();
            if (n >= n2 && n <= n3) continue;
            String string = ParameterGroup.getName((GeneralParameterDescriptor)object);
            throw new InvalidParameterCardinalityException(Errors.format((int)86, (Object)string, (Object)n, (Object)n2, (Object)n3), string);
        }
    }

    public ParameterDescriptorGroup getDescriptor() {
        return (ParameterDescriptorGroup)super.getDescriptor();
    }

    public List<GeneralParameterValue> values() {
        if (this.asList == null) {
            this.asList = new ParameterValueList((ParameterDescriptorGroup)this.descriptor, this.values);
        }
        return this.asList;
    }

    final GeneralParameterValue parameter(int n) throws IndexOutOfBoundsException {
        return this.values.get(n);
    }

    public ParameterValue<?> parameter(String string) throws ParameterNotFoundException {
        ArgumentChecks.ensureNonNull((String)"name", (Object)string);
        string = string.trim();
        for (GeneralParameterValue generalParameterValue : this.values) {
            if (!(generalParameterValue instanceof ParameterValue) || !IdentifiedObjects.nameMatches((IdentifiedObject)generalParameterValue.getDescriptor(), string)) continue;
            return (ParameterValue)generalParameterValue;
        }
        for (GeneralParameterValue generalParameterValue : this.getDescriptor().descriptors()) {
            if (!(generalParameterValue instanceof ParameterDescriptor) || !IdentifiedObjects.nameMatches((IdentifiedObject)generalParameterValue, string)) continue;
            ParameterValue parameterValue = ((ParameterDescriptor)generalParameterValue).createValue();
            this.values.add((GeneralParameterValue)parameterValue);
            return parameterValue;
        }
        throw new ParameterNotFoundException(Errors.format((int)224, (Object)string), string);
    }

    public List<ParameterValueGroup> groups(String string) throws ParameterNotFoundException {
        ArgumentChecks.ensureNonNull((String)"name", (Object)string);
        string = string.trim();
        ArrayList<ParameterValueGroup> arrayList = new ArrayList<ParameterValueGroup>(Math.min(this.values.size(), 10));
        GeneralParameterDescriptor generalParameterDescriptor = this.values.iterator();
        while (generalParameterDescriptor.hasNext()) {
            GeneralParameterValue generalParameterValue = generalParameterDescriptor.next();
            if (!(generalParameterValue instanceof ParameterValueGroup) || !IdentifiedObjects.nameMatches((IdentifiedObject)generalParameterValue.getDescriptor(), string)) continue;
            arrayList.add((ParameterValueGroup)generalParameterValue);
        }
        if (arrayList.isEmpty() && !((generalParameterDescriptor = ((ParameterDescriptorGroup)this.descriptor).descriptor(string)) instanceof ParameterDescriptorGroup)) {
            throw new ParameterNotFoundException(Errors.format((int)224, (Object)string), string);
        }
        return arrayList;
    }

    public ParameterValueGroup addGroup(String string) throws ParameterNotFoundException, InvalidParameterCardinalityException {
        GeneralParameterDescriptor generalParameterDescriptor = ((ParameterDescriptorGroup)this.descriptor).descriptor(string);
        if (!(generalParameterDescriptor instanceof ParameterDescriptorGroup)) {
            throw new ParameterNotFoundException(Errors.format((int)224, (Object)string), string);
        }
        int n = 0;
        for (GeneralParameterValue generalParameterValue : this.values) {
            if (!IdentifiedObjects.nameMatches((IdentifiedObject)generalParameterValue.getDescriptor(), string)) continue;
            ++n;
        }
        if (n >= generalParameterDescriptor.getMaximumOccurs()) {
            throw new InvalidParameterCardinalityException(Errors.format((int)202, (Object)string, (Object)n), string);
        }
        ParameterValueGroup parameterValueGroup = ((ParameterDescriptorGroup)generalParameterDescriptor).createValue();
        this.values.add((GeneralParameterValue)parameterValueGroup);
        return parameterValueGroup;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            ParameterGroup parameterGroup = (ParameterGroup)object;
            return Utilities.equals(this.values, parameterGroup.values);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.values.hashCode();
    }

    @Override
    public ParameterGroup clone() {
        ParameterGroup parameterGroup = (ParameterGroup)super.clone();
        parameterGroup.values = (ArrayList)parameterGroup.values.clone();
        int n = parameterGroup.values.size();
        while (--n >= 0) {
            parameterGroup.values.set(n, parameterGroup.values.get(n).clone());
        }
        parameterGroup.asList = null;
        return parameterGroup;
    }
}

