/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.geotoolkit.lang.Static;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.DefaultAuthorityFactory;
import org.geotoolkit.referencing.IdentifierComparator;
import org.geotoolkit.referencing.NameComparator;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.Properties;
import org.geotoolkit.referencing.RemarksComparator;
import org.geotoolkit.referencing.factory.AbstractAuthorityFactory;
import org.geotoolkit.referencing.factory.IdentifiedObjectFinder;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;
import org.opengis.util.ScopedName;

public final class IdentifiedObjects
extends Static {
    public static final ReferenceIdentifier[] EMPTY_IDENTIFIER_ARRAY = new ReferenceIdentifier[0];
    public static final GenericName[] EMPTY_ALIAS_ARRAY = new GenericName[0];
    public static final Comparator<IdentifiedObject> NAME_COMPARATOR = new NameComparator();
    public static final Comparator<IdentifiedObject> IDENTIFIER_COMPARATOR = new IdentifierComparator();
    public static final Comparator<IdentifiedObject> REMARKS_COMPARATOR = new RemarksComparator();

    private IdentifiedObjects() {
    }

    static <E extends Comparable<E>> int doCompare(E e, E e2) {
        if (e == null) {
            return e2 == null ? 0 : -1;
        }
        if (e2 == null) {
            return 1;
        }
        return e.compareTo(e2);
    }

    public static Map<String, ?> getProperties(IdentifiedObject identifiedObject) {
        ArgumentChecks.ensureNonNull((String)"info", (Object)identifiedObject);
        return new Properties(identifiedObject);
    }

    public static Map<String, Object> getProperties(IdentifiedObject identifiedObject, Citation citation) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(IdentifiedObjects.getProperties(identifiedObject));
        hashMap.put("name", (Object)new NamedIdentifier(citation, identifiedObject.getName().getCode()));
        hashMap.remove("identifiers");
        return hashMap;
    }

    public static String getName(IdentifiedObject identifiedObject, Citation citation) {
        if (identifiedObject instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)identifiedObject).getName(citation);
        }
        return IdentifiedObjects.name(identifiedObject, citation);
    }

    static String name(IdentifiedObject identifiedObject, Citation citation) {
        if (identifiedObject == null) {
            return null;
        }
        ReferenceIdentifier referenceIdentifier = identifiedObject.getName();
        if (citation == null) {
            return referenceIdentifier.getCode();
        }
        String string = null;
        Citation citation2 = referenceIdentifier.getAuthority();
        if (citation2 != null) {
            if (org.geotoolkit.internal.Citations.identifierMatches((Citation)citation, (Citation)citation2)) {
                string = referenceIdentifier.getCode();
            } else {
                for (GenericName genericName : identifiedObject.getAlias()) {
                    if (genericName == null) continue;
                    if (genericName instanceof Identifier) {
                        referenceIdentifier = (Identifier)genericName;
                        citation2 = referenceIdentifier.getAuthority();
                        if (citation2 == null || !org.geotoolkit.internal.Citations.identifierMatches((Citation)citation, (Citation)citation2)) continue;
                        string = referenceIdentifier.getCode();
                        break;
                    }
                    GenericName genericName2 = genericName.scope().name();
                    if (genericName2 == null || !org.geotoolkit.internal.Citations.identifierMatches((Citation)citation, (String)genericName2.toString())) continue;
                    string = genericName.toString();
                    break;
                }
            }
        }
        return string;
    }

    public static ReferenceIdentifier getIdentifier(IdentifiedObject identifiedObject, Citation citation) {
        if (identifiedObject instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)identifiedObject).getIdentifier(citation);
        }
        return IdentifiedObjects.identifier(identifiedObject, citation);
    }

    static ReferenceIdentifier identifier(IdentifiedObject identifiedObject, Citation citation) {
        Set set;
        if (identifiedObject != null && (set = identifiedObject.getIdentifiers()) != null) {
            for (ReferenceIdentifier referenceIdentifier : set) {
                if (referenceIdentifier == null) continue;
                if (citation == null) {
                    return referenceIdentifier;
                }
                Citation citation2 = referenceIdentifier.getAuthority();
                if (citation2 == null || !org.geotoolkit.internal.Citations.identifierMatches((Citation)citation, (Citation)citation2)) continue;
                return referenceIdentifier;
            }
        }
        return null;
    }

    public static String getIdentifier(IdentifiedObject identifiedObject) {
        if (identifiedObject != null) {
            ReferenceIdentifier referenceIdentifier;
            Set set = identifiedObject.getIdentifiers();
            if (set != null) {
                referenceIdentifier = set.iterator();
                while (referenceIdentifier.hasNext()) {
                    String string;
                    ReferenceIdentifier referenceIdentifier2 = (ReferenceIdentifier)referenceIdentifier.next();
                    if (referenceIdentifier2 == null || (string = referenceIdentifier2.toString()) == null) continue;
                    return string;
                }
            }
            if ((referenceIdentifier = identifiedObject.getName()) != null) {
                return referenceIdentifier.toString();
            }
        }
        return null;
    }

    public static String lookupIdentifier(IdentifiedObject identifiedObject, boolean bl) throws FactoryException {
        if (identifiedObject == null) {
            return null;
        }
        AbstractAuthorityFactory abstractAuthorityFactory = (AbstractAuthorityFactory)CRS.getAuthorityFactory(true);
        IdentifiedObjectFinder identifiedObjectFinder = abstractAuthorityFactory.getIdentifiedObjectFinder(identifiedObject.getClass());
        identifiedObjectFinder.setComparisonMode(ComparisonMode.APPROXIMATIVE);
        identifiedObjectFinder.setFullScanAllowed(bl);
        return identifiedObjectFinder.findIdentifier(identifiedObject);
    }

    public static String lookupIdentifier(Citation citation, IdentifiedObject identifiedObject, boolean bl) throws FactoryException {
        ArgumentChecks.ensureNonNull((String)"authority", (Object)citation);
        if (identifiedObject == null) {
            return null;
        }
        ReferenceIdentifier referenceIdentifier = IdentifiedObjects.getIdentifier(identifiedObject, citation);
        if (referenceIdentifier != null) {
            return referenceIdentifier.getCode();
        }
        DefaultAuthorityFactory defaultAuthorityFactory = (DefaultAuthorityFactory)CRS.getAuthorityFactory(true);
        for (AuthorityFactory authorityFactory : defaultAuthorityFactory.backingStore.getFactories()) {
            if (!Citations.identifierMatches((Citation)authorityFactory.getAuthority(), (Citation)citation) || !(authorityFactory instanceof AbstractAuthorityFactory)) continue;
            AbstractAuthorityFactory abstractAuthorityFactory = (AbstractAuthorityFactory)authorityFactory;
            IdentifiedObjectFinder identifiedObjectFinder = abstractAuthorityFactory.getIdentifiedObjectFinder(identifiedObject.getClass());
            identifiedObjectFinder.setComparisonMode(ComparisonMode.APPROXIMATIVE);
            identifiedObjectFinder.setFullScanAllowed(bl);
            String string = identifiedObjectFinder.findIdentifier(identifiedObject);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    public static Integer lookupEpsgCode(IdentifiedObject identifiedObject, boolean bl) throws FactoryException {
        String string = IdentifiedObjects.lookupIdentifier((Citation)Citations.EPSG, identifiedObject, bl);
        if (string != null) {
            int n = string.lastIndexOf(58);
            String string2 = string.substring(n + 1);
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new FactoryException(Errors.format((int)82, (Object)string), (Throwable)numberFormatException);
            }
        }
        return null;
    }

    public static boolean nameMatches(IdentifiedObject identifiedObject, String string) {
        if (identifiedObject instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)identifiedObject).nameMatches(string);
        }
        ArgumentChecks.ensureNonNull((String)"object", (Object)identifiedObject);
        return IdentifiedObjects.nameMatches(identifiedObject, identifiedObject.getAlias(), string);
    }

    public static boolean nameMatches(IdentifiedObject identifiedObject, IdentifiedObject identifiedObject2) {
        ArgumentChecks.ensureNonNull((String)"o1", (Object)identifiedObject);
        ArgumentChecks.ensureNonNull((String)"o2", (Object)identifiedObject2);
        return IdentifiedObjects.nameMatches(identifiedObject, identifiedObject2.getName().getCode()) || IdentifiedObjects.nameMatches(identifiedObject2, identifiedObject.getName().getCode());
    }

    static boolean nameMatches(IdentifiedObject identifiedObject, Collection<GenericName> collection, String string) {
        if ((string = string.trim()).equalsIgnoreCase(identifiedObject.getName().getCode().trim())) {
            return true;
        }
        if (collection != null) {
            block0: for (GenericName genericName : collection) {
                if (genericName == null) continue;
                genericName = genericName.toFullyQualifiedName();
                while (genericName != null) {
                    if (string.equalsIgnoreCase(genericName.toString().trim())) {
                        return true;
                    }
                    if (!(genericName instanceof ScopedName)) continue block0;
                    genericName = ((ScopedName)genericName).tail();
                }
            }
        }
        return false;
    }
}

