/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.cs;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.measure.converter.ConversionException;
import javax.measure.converter.LinearConverter;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlElement;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.AxisDirections;
import org.geotoolkit.internal.referencing.NilReferencingObject;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.measure.Measure;
import org.geotoolkit.measure.Units;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotoolkit.referencing.cs.DirectionAlongMeridian;
import org.geotoolkit.referencing.cs.PredefinedCS;
import org.geotoolkit.referencing.operation.matrix.GeneralMatrix;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.converter.Classes;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.InternationalString;

@Immutable
public class AbstractCS
extends AbstractIdentifiedObject
implements CoordinateSystem {
    private static final long serialVersionUID = 6757665252533744744L;
    private static final DefaultCoordinateSystemAxis[] DIRECTION_CHECKS = new DefaultCoordinateSystemAxis[]{DefaultCoordinateSystemAxis.NORTHING, DefaultCoordinateSystemAxis.EASTING, DefaultCoordinateSystemAxis.SOUTHING, DefaultCoordinateSystemAxis.WESTING};
    @XmlElement
    private final CoordinateSystemAxis[] axis;
    private volatile transient Unit<?> distanceUnit;

    private AbstractCS() {
        this((CoordinateSystem)NilReferencingObject.INSTANCE);
    }

    public AbstractCS(CoordinateSystem coordinateSystem) {
        super((IdentifiedObject)coordinateSystem);
        if (coordinateSystem instanceof AbstractCS) {
            this.axis = ((AbstractCS)coordinateSystem).axis;
        } else {
            this.axis = new CoordinateSystemAxis[coordinateSystem.getDimension()];
            for (int i = 0; i < this.axis.length; ++i) {
                this.axis[i] = coordinateSystem.getAxis(i);
            }
        }
    }

    public AbstractCS(String string, CoordinateSystemAxis ... coordinateSystemAxisArray) {
        this(Collections.singletonMap("name", string), coordinateSystemAxisArray);
    }

    public AbstractCS(Map<String, ?> map, CoordinateSystemAxis ... coordinateSystemAxisArray) {
        super(map);
        ArgumentChecks.ensureNonNull((String)"axis", (Object)coordinateSystemAxisArray);
        this.axis = (CoordinateSystemAxis[])coordinateSystemAxisArray.clone();
        for (int i = 0; i < coordinateSystemAxisArray.length; ++i) {
            Object object;
            ArgumentChecks.ensureNonNull((String)"axis", (int)i, (Object[])coordinateSystemAxisArray);
            AxisDirection axisDirection = coordinateSystemAxisArray[i].getDirection();
            ArgumentChecks.ensureNonNull((String)"direction", (Object)axisDirection);
            if (!this.isCompatibleDirection(axisDirection)) {
                throw new IllegalArgumentException(Errors.format((int)75, (Object)axisDirection.name(), this.getClass()));
            }
            Unit unit = coordinateSystemAxisArray[i].getUnit();
            ArgumentChecks.ensureNonNull((String)"unit", (Object)unit);
            if (!this.isCompatibleUnit(axisDirection, unit)) {
                throw new IllegalArgumentException(Errors.format((int)92, (Object)unit));
            }
            AxisDirection axisDirection2 = AxisDirections.absolute(axisDirection);
            if (!axisDirection2.equals((Object)AxisDirection.OTHER)) {
                int n = i;
                while (--n >= 0) {
                    if (!axisDirection2.equals((Object)AxisDirections.absolute(coordinateSystemAxisArray[n].getDirection()))) continue;
                    String string = coordinateSystemAxisArray[i].getDirection().name();
                    object = coordinateSystemAxisArray[n].getDirection().name();
                    throw new IllegalArgumentException(Errors.format((int)44, (Object)string, (Object)object));
                }
            }
            String string = coordinateSystemAxisArray[i].getName().getCode();
            for (int j = 0; j < DIRECTION_CHECKS.length; ++j) {
                DirectionAlongMeridian directionAlongMeridian;
                AxisDirection axisDirection3;
                object = DIRECTION_CHECKS[j];
                if (!((DefaultCoordinateSystemAxis)object).nameMatches(string) || axisDirection.equals((Object)(axisDirection3 = ((DefaultCoordinateSystemAxis)object).getDirection())) || (directionAlongMeridian = DirectionAlongMeridian.parse(axisDirection)) != null) continue;
                throw new IllegalArgumentException(Errors.format((int)93, (Object)string, (Object)axisDirection.name()));
            }
        }
    }

    static Map<String, Object> name(int n) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        InternationalString internationalString = Vocabulary.formatInternational((int)n);
        hashMap.put("name", internationalString.toString());
        hashMap.put("alias", internationalString);
        return hashMap;
    }

    protected boolean isCompatibleDirection(AxisDirection axisDirection) {
        return true;
    }

    protected boolean isCompatibleUnit(AxisDirection axisDirection, Unit<?> unit) {
        return true;
    }

    public int getDimension() {
        return this.axis.length;
    }

    public CoordinateSystemAxis getAxis(int n) throws IndexOutOfBoundsException {
        return this.axis[n];
    }

    private static AxisDirection[] getAxisDirections(CoordinateSystem coordinateSystem) {
        AxisDirection[] axisDirectionArray = new AxisDirection[coordinateSystem.getDimension()];
        for (int i = 0; i < axisDirectionArray.length; ++i) {
            axisDirectionArray[i] = coordinateSystem.getAxis(i).getDirection();
        }
        return axisDirectionArray;
    }

    public static Matrix swapAndScaleAxis(CoordinateSystem coordinateSystem, CoordinateSystem coordinateSystem2) throws IllegalArgumentException, ConversionException {
        if (!Classes.implementSameInterfaces(coordinateSystem.getClass(), coordinateSystem2.getClass(), CoordinateSystem.class)) {
            throw new IllegalArgumentException(Errors.format((int)89));
        }
        Object[] objectArray = AbstractCS.getAxisDirections(coordinateSystem);
        Object[] objectArray2 = AbstractCS.getAxisDirections(coordinateSystem2);
        GeneralMatrix generalMatrix = new GeneralMatrix((AxisDirection[])objectArray, (AxisDirection[])objectArray2);
        assert (Arrays.equals(objectArray, objectArray2) == generalMatrix.isIdentity()) : generalMatrix;
        int n = generalMatrix.getNumCol() - 1;
        int n2 = generalMatrix.getNumRow() - 1;
        assert (n == coordinateSystem.getDimension()) : coordinateSystem;
        assert (n2 == coordinateSystem2.getDimension()) : coordinateSystem2;
        for (int i = 0; i < n2; ++i) {
            Unit unit = coordinateSystem2.getAxis(i).getUnit();
            for (int j = 0; j < n; ++j) {
                Unit unit2;
                double d = generalMatrix.getElement(i, j);
                if (d == 0.0 || Utilities.equals((Object)(unit2 = coordinateSystem.getAxis(j).getUnit()), (Object)unit)) continue;
                UnitConverter unitConverter = unit2.getConverterToAny(unit);
                if (!(unitConverter instanceof LinearConverter)) {
                    throw new ConversionException(Errors.format((int)136, (Object)unit2, (Object)unit));
                }
                double d2 = unitConverter.convert(0.0);
                double d3 = Units.derivative((UnitConverter)unitConverter, (double)0.0);
                generalMatrix.setElement(i, j, d * d3);
                generalMatrix.setElement(i, n, generalMatrix.getElement(i, n) + d * d2);
            }
        }
        return generalMatrix;
    }

    public static CoordinateSystem standard(CoordinateSystem coordinateSystem) throws IllegalArgumentException {
        return PredefinedCS.standard(coordinateSystem);
    }

    final Unit<?> getDistanceUnit() {
        Unit unit = this.distanceUnit;
        if (unit == null) {
            double d = 0.0;
            for (int i = 0; i < this.axis.length; ++i) {
                Unit unit2 = this.axis[i].getUnit();
                if (unit2 == null || Units.isAngular((Unit)unit2)) continue;
                double d2 = Math.abs(Units.toStandardUnit((Unit)unit2));
                if (unit != null && !(d2 > d)) continue;
                unit = unit2;
                d = d2;
            }
            this.distanceUnit = unit;
        }
        return unit;
    }

    final void ensureDimensionMatch(String string, double[] dArray) throws MismatchedDimensionException {
        if (dArray.length != this.axis.length) {
            throw new MismatchedDimensionException(Errors.format((int)113, (Object)string, (Object)dArray.length, (Object)this.axis.length));
        }
    }

    public Measure distance(double[] dArray, double[] dArray2) throws UnsupportedOperationException, MismatchedDimensionException {
        throw new UnsupportedOperationException();
    }

    final CoordinateSystemAxis[] axisUsingUnit(Unit<?> unit) throws IllegalArgumentException {
        CoordinateSystemAxis[] coordinateSystemAxisArray = null;
        for (int i = 0; i < this.axis.length; ++i) {
            DefaultCoordinateSystemAxis defaultCoordinateSystemAxis;
            CoordinateSystemAxis coordinateSystemAxis = this.axis[i];
            if (unit.equals((Object)coordinateSystemAxis.getUnit()) || (defaultCoordinateSystemAxis = DefaultCoordinateSystemAxis.castOrCopy(coordinateSystemAxis).usingUnit(unit)) == coordinateSystemAxis) continue;
            if (coordinateSystemAxisArray == null) {
                coordinateSystemAxisArray = new CoordinateSystemAxis[this.axis.length];
                System.arraycopy(this.axis, 0, coordinateSystemAxisArray, 0, i);
            }
            coordinateSystemAxisArray[i] = defaultCoordinateSystemAxis;
        }
        return coordinateSystemAxisArray;
    }

    private static DefaultCoordinateSystemAxis[] getDefaultAxis(CoordinateSystem coordinateSystem) {
        DefaultCoordinateSystemAxis[] defaultCoordinateSystemAxisArray = new DefaultCoordinateSystemAxis[coordinateSystem.getDimension()];
        for (int i = 0; i < defaultCoordinateSystemAxisArray.length; ++i) {
            CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(i);
            DefaultCoordinateSystemAxis defaultCoordinateSystemAxis = DefaultCoordinateSystemAxis.getPredefined(coordinateSystemAxis);
            if (defaultCoordinateSystemAxis == null) {
                defaultCoordinateSystemAxis = DefaultCoordinateSystemAxis.castOrCopy(coordinateSystemAxis);
            }
            defaultCoordinateSystemAxisArray[i] = defaultCoordinateSystemAxis;
        }
        return defaultCoordinateSystemAxisArray;
    }

    final boolean axisColinearWith(CoordinateSystem coordinateSystem) {
        if (coordinateSystem.getDimension() != this.getDimension()) {
            return false;
        }
        DefaultCoordinateSystemAxis[] defaultCoordinateSystemAxisArray = AbstractCS.getDefaultAxis(this);
        DefaultCoordinateSystemAxis[] defaultCoordinateSystemAxisArray2 = AbstractCS.getDefaultAxis(coordinateSystem);
        for (int i = 0; i < defaultCoordinateSystemAxisArray.length; ++i) {
            block5: {
                DefaultCoordinateSystemAxis defaultCoordinateSystemAxis = defaultCoordinateSystemAxisArray[i];
                DefaultCoordinateSystemAxis defaultCoordinateSystemAxis2 = defaultCoordinateSystemAxis.getOpposite();
                for (int j = 0; j < defaultCoordinateSystemAxisArray2.length; ++j) {
                    DefaultCoordinateSystemAxis defaultCoordinateSystemAxis3 = defaultCoordinateSystemAxisArray2[j];
                    if (defaultCoordinateSystemAxis3 == null || !defaultCoordinateSystemAxis3.equals(defaultCoordinateSystemAxis, false, false) && (defaultCoordinateSystemAxis2 == null || !defaultCoordinateSystemAxis3.equals(defaultCoordinateSystemAxis2, false, false))) {
                        continue;
                    }
                    break block5;
                }
                return false;
            }
            defaultCoordinateSystemAxisArray2[j] = null;
        }
        assert (this.directionColinearWith(coordinateSystem));
        return true;
    }

    final boolean directionColinearWith(CoordinateSystem coordinateSystem) {
        int n;
        if (coordinateSystem.getDimension() != this.axis.length) {
            return false;
        }
        AxisDirection[] axisDirectionArray = new AxisDirection[this.axis.length];
        for (n = 0; n < axisDirectionArray.length; ++n) {
            axisDirectionArray[n] = AxisDirections.absolute(coordinateSystem.getAxis(n).getDirection());
        }
        for (n = 0; n < this.axis.length; ++n) {
            block5: {
                AxisDirection axisDirection = AxisDirections.absolute(this.axis[n].getDirection());
                for (int i = 0; i < axisDirectionArray.length; ++i) {
                    AxisDirection axisDirection2 = axisDirectionArray[i];
                    if (axisDirection2 == null || !axisDirection2.equals((Object)axisDirection)) {
                        continue;
                    }
                    break block5;
                }
                return false;
            }
            axisDirectionArray[i] = null;
        }
        return true;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            switch (comparisonMode) {
                case STRICT: {
                    AbstractCS abstractCS = (AbstractCS)object;
                    return Arrays.equals(this.axis, abstractCS.axis);
                }
            }
            int n = this.getDimension();
            CoordinateSystem coordinateSystem = (CoordinateSystem)object;
            if (n == coordinateSystem.getDimension()) {
                for (int i = 0; i < n; ++i) {
                    if (Utilities.deepEquals((Object)this.getAxis(i), (Object)coordinateSystem.getAxis(i), (ComparisonMode)comparisonMode)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected int computeHashCode() {
        return Utilities.hash((int)Arrays.hashCode(this.axis), (int)super.computeHashCode());
    }

    @Override
    public String formatWKT(Formatter formatter) {
        for (int i = 0; i < this.axis.length; ++i) {
            formatter.append((IdentifiedObject)this.axis[i]);
        }
        formatter.setInvalidWKT(CoordinateSystem.class);
        return super.formatWKT(formatter);
    }
}

