/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.cs;

import java.util.Map;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.AxisDirections;
import org.geotoolkit.internal.referencing.NilReferencingObject;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.cs.AbstractCS;
import org.geotoolkit.referencing.cs.DefaultCartesianCS;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;

@Immutable
public class DefaultAffineCS
extends AbstractCS
implements AffineCS {
    private static final long serialVersionUID = 7977674229369042440L;

    private DefaultAffineCS() {
        this((AffineCS)NilReferencingObject.INSTANCE);
    }

    public DefaultAffineCS(AffineCS affineCS) {
        super((CoordinateSystem)affineCS);
    }

    public DefaultAffineCS(String string, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) {
        super(string, coordinateSystemAxis, coordinateSystemAxis2);
    }

    public DefaultAffineCS(String string, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) {
        super(string, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
    }

    public DefaultAffineCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) {
        super(map, coordinateSystemAxis, coordinateSystemAxis2);
    }

    public DefaultAffineCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) {
        super(map, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
    }

    DefaultAffineCS(Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) {
        super(map, coordinateSystemAxisArray);
    }

    public static DefaultAffineCS castOrCopy(AffineCS affineCS) {
        if (affineCS instanceof CartesianCS) {
            return DefaultCartesianCS.castOrCopy((CartesianCS)affineCS);
        }
        return affineCS == null || affineCS instanceof DefaultAffineCS ? (DefaultAffineCS)affineCS : new DefaultAffineCS(affineCS);
    }

    @Deprecated
    public static DefaultAffineCS wrap(AffineCS affineCS) {
        return DefaultAffineCS.castOrCopy(affineCS);
    }

    @Override
    protected boolean isCompatibleDirection(AxisDirection axisDirection) {
        return !AxisDirection.FUTURE.equals((Object)AxisDirections.absolute(axisDirection));
    }

    @Override
    protected boolean isCompatibleUnit(AxisDirection axisDirection, Unit<?> unit) {
        return SI.METRE.isCompatible(unit) || Unit.ONE.equals(unit);
    }

    public DefaultAffineCS usingUnit(Unit<?> unit) throws IllegalArgumentException {
        CoordinateSystemAxis[] coordinateSystemAxisArray = this.axisUsingUnit(unit);
        if (coordinateSystemAxisArray == null) {
            return this;
        }
        return new DefaultAffineCS(IdentifiedObjects.getProperties(this, null), coordinateSystemAxisArray);
    }
}

