/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.cs;

import java.util.Map;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.AxisDirections;
import org.geotoolkit.internal.referencing.NilReferencingObject;
import org.geotoolkit.measure.Units;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.cs.AbstractCS;
import org.geotoolkit.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotoolkit.resources.Errors;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;

@Immutable
public class DefaultEllipsoidalCS
extends AbstractCS
implements EllipsoidalCS {
    private static final long serialVersionUID = -1452492488902329211L;
    public static final DefaultEllipsoidalCS GEODETIC_2D = new DefaultEllipsoidalCS((Map<String, ?>)DefaultEllipsoidalCS.name(121), (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEODETIC_LONGITUDE, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEODETIC_LATITUDE);
    public static final DefaultEllipsoidalCS GEODETIC_3D = new DefaultEllipsoidalCS((Map<String, ?>)DefaultEllipsoidalCS.name(122), (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEODETIC_LONGITUDE, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEODETIC_LATITUDE, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.ELLIPSOIDAL_HEIGHT);
    private transient int longitudeAxis;
    private transient int latitudeAxis;
    private transient int heightAxis;
    private transient UnitConverter longitudeConverter;
    private transient UnitConverter latitudeConverter;
    private transient UnitConverter heightConverter;

    private DefaultEllipsoidalCS() {
        this(NilReferencingObject.INSTANCE);
    }

    public DefaultEllipsoidalCS(EllipsoidalCS ellipsoidalCS) {
        super((CoordinateSystem)ellipsoidalCS);
    }

    public DefaultEllipsoidalCS(String string, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) {
        super(string, coordinateSystemAxis, coordinateSystemAxis2);
    }

    public DefaultEllipsoidalCS(String string, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) {
        super(string, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
    }

    public DefaultEllipsoidalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) {
        super(map, coordinateSystemAxis, coordinateSystemAxis2);
    }

    public DefaultEllipsoidalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) {
        super(map, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
    }

    private DefaultEllipsoidalCS(Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) {
        super(map, coordinateSystemAxisArray);
    }

    public static DefaultEllipsoidalCS castOrCopy(EllipsoidalCS ellipsoidalCS) {
        return ellipsoidalCS == null || ellipsoidalCS instanceof DefaultEllipsoidalCS ? (DefaultEllipsoidalCS)ellipsoidalCS : new DefaultEllipsoidalCS(ellipsoidalCS);
    }

    @Deprecated
    public static DefaultEllipsoidalCS wrap(EllipsoidalCS ellipsoidalCS) {
        return DefaultEllipsoidalCS.castOrCopy(ellipsoidalCS);
    }

    @Override
    protected boolean isCompatibleDirection(AxisDirection axisDirection) {
        return AxisDirection.NORTH.equals((Object)(axisDirection = AxisDirections.absolute(axisDirection))) || AxisDirection.EAST.equals((Object)axisDirection) || AxisDirection.UP.equals((Object)axisDirection);
    }

    @Override
    protected boolean isCompatibleUnit(AxisDirection axisDirection, Unit<?> unit) {
        if (AxisDirection.UP.equals((Object)(axisDirection = AxisDirections.absolute(axisDirection)))) {
            return Units.isLinear(unit);
        }
        return Units.isAngular(unit);
    }

    private void updateConverters() {
        int n = this.getDimension();
        while (--n >= 0) {
            CoordinateSystemAxis coordinateSystemAxis = this.getAxis(n);
            AxisDirection axisDirection = AxisDirections.absolute(coordinateSystemAxis.getDirection());
            Unit unit = coordinateSystemAxis.getUnit();
            if (AxisDirection.EAST.equals((Object)axisDirection)) {
                this.longitudeAxis = n;
                this.longitudeConverter = unit.asType(Angle.class).getConverterTo(NonSI.DEGREE_ANGLE);
                continue;
            }
            if (AxisDirection.NORTH.equals((Object)axisDirection)) {
                this.latitudeAxis = n;
                this.latitudeConverter = unit.asType(Angle.class).getConverterTo(NonSI.DEGREE_ANGLE);
                continue;
            }
            if (AxisDirection.UP.equals((Object)axisDirection)) {
                this.heightAxis = n;
                this.heightConverter = unit.asType(Length.class).getConverterTo((Unit)SI.METRE);
                continue;
            }
            throw new AssertionError(axisDirection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getLongitude(double[] dArray) throws MismatchedDimensionException {
        UnitConverter unitConverter;
        this.ensureDimensionMatch("coordinates", dArray);
        DefaultEllipsoidalCS defaultEllipsoidalCS = this;
        synchronized (defaultEllipsoidalCS) {
            unitConverter = this.longitudeConverter;
            if (unitConverter == null) {
                this.updateConverters();
                unitConverter = this.longitudeConverter;
            }
        }
        return unitConverter.convert(dArray[this.longitudeAxis]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getLatitude(double[] dArray) throws MismatchedDimensionException {
        UnitConverter unitConverter;
        this.ensureDimensionMatch("coordinates", dArray);
        DefaultEllipsoidalCS defaultEllipsoidalCS = this;
        synchronized (defaultEllipsoidalCS) {
            unitConverter = this.latitudeConverter;
            if (unitConverter == null) {
                this.updateConverters();
                unitConverter = this.latitudeConverter;
            }
        }
        return unitConverter.convert(dArray[this.latitudeAxis]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getHeight(double[] dArray) throws MismatchedDimensionException {
        UnitConverter unitConverter;
        this.ensureDimensionMatch("coordinates", dArray);
        DefaultEllipsoidalCS defaultEllipsoidalCS = this;
        synchronized (defaultEllipsoidalCS) {
            unitConverter = this.heightConverter;
            if (unitConverter == null) {
                this.updateConverters();
                unitConverter = this.heightConverter;
                if (unitConverter == null) {
                    throw new IllegalStateException(Errors.format((int)149));
                }
            }
        }
        return unitConverter.convert(dArray[this.heightAxis]);
    }

    public DefaultEllipsoidalCS usingUnit(Unit<?> unit) throws IllegalArgumentException {
        CoordinateSystemAxis[] coordinateSystemAxisArray = this.axisUsingUnit(unit);
        if (coordinateSystemAxisArray == null) {
            return this;
        }
        return new DefaultEllipsoidalCS(IdentifiedObjects.getProperties(this, null), coordinateSystemAxisArray);
    }
}

