/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.cs;

import java.util.Map;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.AxisDirections;
import org.geotoolkit.internal.referencing.NilReferencingObject;
import org.geotoolkit.measure.Measure;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.cs.AbstractCS;
import org.geotoolkit.referencing.cs.DefaultCoordinateSystemAxis;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.VerticalCS;

@Immutable
public class DefaultVerticalCS
extends AbstractCS
implements VerticalCS {
    private static final long serialVersionUID = 1201155778896630499L;
    public static final DefaultVerticalCS ELLIPSOIDAL_HEIGHT = new DefaultVerticalCS(DefaultCoordinateSystemAxis.ELLIPSOIDAL_HEIGHT);
    public static final DefaultVerticalCS GRAVITY_RELATED_HEIGHT = new DefaultVerticalCS(DefaultCoordinateSystemAxis.GRAVITY_RELATED_HEIGHT);
    public static final DefaultVerticalCS DEPTH = new DefaultVerticalCS(DefaultCoordinateSystemAxis.DEPTH);

    private DefaultVerticalCS() {
        this(NilReferencingObject.INSTANCE);
    }

    public DefaultVerticalCS(VerticalCS verticalCS) {
        super((CoordinateSystem)verticalCS);
    }

    public DefaultVerticalCS(CoordinateSystemAxis coordinateSystemAxis) {
        super(IdentifiedObjects.getProperties((IdentifiedObject)coordinateSystemAxis), coordinateSystemAxis);
    }

    public DefaultVerticalCS(String string, CoordinateSystemAxis coordinateSystemAxis) {
        super(string, coordinateSystemAxis);
    }

    public DefaultVerticalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis) {
        super(map, coordinateSystemAxis);
    }

    public static DefaultVerticalCS castOrCopy(VerticalCS verticalCS) {
        return verticalCS == null || verticalCS instanceof DefaultVerticalCS ? (DefaultVerticalCS)verticalCS : new DefaultVerticalCS(verticalCS);
    }

    @Deprecated
    public static DefaultVerticalCS wrap(VerticalCS verticalCS) {
        return DefaultVerticalCS.castOrCopy(verticalCS);
    }

    @Override
    protected boolean isCompatibleDirection(AxisDirection axisDirection) {
        return AxisDirection.UP.equals((Object)AxisDirections.absolute(axisDirection));
    }

    @Override
    public Measure distance(double[] dArray, double[] dArray2) throws MismatchedDimensionException {
        this.ensureDimensionMatch("coord1", dArray);
        this.ensureDimensionMatch("coord2", dArray2);
        return new Measure(Math.abs(dArray[0] - dArray2[0]), this.getDistanceUnit());
    }
}

