/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.cs;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.CodeLists;
import org.geotoolkit.internal.referencing.AxisDirections;
import org.geotoolkit.referencing.cs.Directions;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.util.CodeList;

@Immutable
final class DirectionAlongMeridian
implements Comparable<DirectionAlongMeridian>,
Serializable {
    private static final long serialVersionUID = 1602711631943838328L;
    static final double EPS = 1.0E-10;
    private static final Pattern EPSG = Pattern.compile("(\\p{Graph}+)\\s+along\\s+([\\-\\p{Digit}\\.]+)(?:\\s+deg|\\s*\u00b0)\\s*(\\p{Graph}+)?", 2);
    private static final AxisDirection[] BASE_DIRECTIONS = new AxisDirection[]{AxisDirection.NORTH, AxisDirection.SOUTH, AxisDirection.EAST, AxisDirection.WEST};
    private transient AxisDirection direction;
    public final AxisDirection baseDirection;
    public final double meridian;

    private DirectionAlongMeridian(AxisDirection axisDirection, double d) {
        this.baseDirection = axisDirection;
        this.meridian = d;
    }

    public static DirectionAlongMeridian parse(AxisDirection axisDirection) {
        DirectionAlongMeridian directionAlongMeridian = DirectionAlongMeridian.parse(axisDirection.name());
        if (directionAlongMeridian != null) {
            directionAlongMeridian.direction = axisDirection;
        }
        return directionAlongMeridian;
    }

    public static DirectionAlongMeridian parse(String string) {
        double d;
        Matcher matcher = EPSG.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        String string2 = matcher.group(1);
        AxisDirection axisDirection = Directions.find(BASE_DIRECTIONS, string2);
        if (axisDirection == null || !AxisDirection.NORTH.equals((Object)AxisDirections.absolute(axisDirection))) {
            return null;
        }
        string2 = matcher.group(2);
        try {
            d = Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        if (!(d >= -180.0) || !(d <= 180.0)) {
            return null;
        }
        string2 = matcher.group(3);
        if (string2 != null) {
            AxisDirection axisDirection2 = Directions.find(BASE_DIRECTIONS, string2);
            if (axisDirection2 == null) {
                return null;
            }
            AxisDirection axisDirection3 = AxisDirections.absolute(axisDirection2);
            if (axisDirection2 == null || !AxisDirection.EAST.equals((Object)axisDirection3)) {
                return null;
            }
            if (axisDirection2 != axisDirection3) {
                d = -d;
            }
        }
        return new DirectionAlongMeridian(axisDirection, d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AxisDirection getDirection() {
        AxisDirection axisDirection = this.direction;
        if (axisDirection != null) return axisDirection;
        String string = this.toString();
        Class<AxisDirection> clazz = AxisDirection.class;
        synchronized (AxisDirection.class) {
            axisDirection = Directions.find(string);
            if (axisDirection == null) {
                axisDirection = (AxisDirection)CodeLists.valueOf(AxisDirection.class, (String)string);
            }
            this.direction = axisDirection;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return axisDirection;
        }
    }

    public double getAngle(DirectionAlongMeridian directionAlongMeridian) {
        if (!this.baseDirection.equals((Object)directionAlongMeridian.baseDirection)) {
            return Double.NaN;
        }
        double d = this.meridian - directionAlongMeridian.meridian;
        if (d < -180.0) {
            d += 360.0;
        } else if (d > 180.0) {
            d -= 360.0;
        }
        if (AxisDirections.isOpposite(this.baseDirection)) {
            d = -d;
        }
        return d;
    }

    @Override
    public int compareTo(DirectionAlongMeridian directionAlongMeridian) {
        int n = this.baseDirection.compareTo((CodeList)directionAlongMeridian.baseDirection);
        if (n != 0) {
            return n;
        }
        double d = this.getAngle(directionAlongMeridian);
        if (d < 0.0) {
            return 1;
        }
        if (d > 0.0) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object instanceof DirectionAlongMeridian) {
            DirectionAlongMeridian directionAlongMeridian = (DirectionAlongMeridian)object;
            return this.baseDirection.equals((Object)directionAlongMeridian.baseDirection) && Double.doubleToLongBits(this.meridian) == Double.doubleToLongBits(directionAlongMeridian.meridian);
        }
        return false;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.meridian);
        return 0xDB662A78 ^ (int)l ^ (int)(l >> 32) + 31 * this.baseDirection.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.baseDirection.name());
        int n = stringBuilder.length();
        while (--n > 0) {
            stringBuilder.setCharAt(n, Character.toLowerCase(stringBuilder.charAt(n)));
        }
        stringBuilder.append(" along ");
        double d = Math.abs(this.meridian);
        int n2 = (int)d;
        if (d == (double)n2) {
            stringBuilder.append(n2);
        } else {
            stringBuilder.append(d);
        }
        stringBuilder.append('\u00b0');
        if (d != 0.0 && d != 180.0) {
            stringBuilder.append(this.meridian < 0.0 ? (char)'W' : 'E');
        }
        String string = stringBuilder.toString();
        assert (EPSG.matcher(string).matches()) : string;
        return string;
    }
}

