/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.datum;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.measure.quantity.Angle;
import javax.measure.unit.NonSI;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.measure.Units;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.datum.PrimeMeridian;

@Immutable
@XmlRootElement(name="PrimeMeridian")
public class DefaultPrimeMeridian
extends AbstractIdentifiedObject
implements PrimeMeridian {
    private static final long serialVersionUID = 541978454643213305L;
    public static final DefaultPrimeMeridian GREENWICH;
    @XmlElement(required=true)
    private final double greenwichLongitude;
    private final Unit<Angle> angularUnit;

    private DefaultPrimeMeridian() {
        this(GREENWICH);
    }

    public DefaultPrimeMeridian(PrimeMeridian primeMeridian) {
        super((IdentifiedObject)primeMeridian);
        this.greenwichLongitude = primeMeridian.getGreenwichLongitude();
        this.angularUnit = primeMeridian.getAngularUnit();
    }

    public DefaultPrimeMeridian(String string, double d) {
        this(string, d, (Unit<Angle>)NonSI.DEGREE_ANGLE);
    }

    public DefaultPrimeMeridian(String string, double d, Unit<Angle> unit) {
        this(Collections.singletonMap("name", string), d, unit);
    }

    public DefaultPrimeMeridian(Map<String, ?> map, double d, Unit<Angle> unit) {
        super(map);
        ArgumentChecks.ensureNonNull((String)"angularUnit", unit);
        this.greenwichLongitude = d;
        this.angularUnit = Units.ensureAngular(unit);
    }

    public static DefaultPrimeMeridian castOrCopy(PrimeMeridian primeMeridian) {
        return primeMeridian == null || primeMeridian instanceof DefaultPrimeMeridian ? (DefaultPrimeMeridian)primeMeridian : new DefaultPrimeMeridian(primeMeridian);
    }

    @Deprecated
    public static DefaultPrimeMeridian wrap(PrimeMeridian primeMeridian) {
        return DefaultPrimeMeridian.castOrCopy(primeMeridian);
    }

    public double getGreenwichLongitude() {
        return this.greenwichLongitude;
    }

    public double getGreenwichLongitude(Unit<Angle> unit) {
        return this.getAngularUnit().getConverterTo(unit).convert(this.getGreenwichLongitude());
    }

    public Unit<Angle> getAngularUnit() {
        return this.angularUnit;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            switch (comparisonMode) {
                case STRICT: {
                    DefaultPrimeMeridian defaultPrimeMeridian = (DefaultPrimeMeridian)object;
                    return Utilities.equals((double)this.greenwichLongitude, (double)defaultPrimeMeridian.greenwichLongitude) && Utilities.equals(this.angularUnit, defaultPrimeMeridian.angularUnit);
                }
                case BY_CONTRACT: {
                    PrimeMeridian primeMeridian = (PrimeMeridian)object;
                    return Utilities.equals((double)this.getGreenwichLongitude(), (double)primeMeridian.getGreenwichLongitude()) && Utilities.equals(this.getAngularUnit(), (Object)primeMeridian.getAngularUnit());
                }
            }
            DefaultPrimeMeridian defaultPrimeMeridian = DefaultPrimeMeridian.castOrCopy((PrimeMeridian)object);
            return InternalUtilities.epsilonEqual((double)this.getGreenwichLongitude((Unit<Angle>)NonSI.DEGREE_ANGLE), (double)defaultPrimeMeridian.getGreenwichLongitude((Unit<Angle>)NonSI.DEGREE_ANGLE), (ComparisonMode)comparisonMode);
        }
        return false;
    }

    @Override
    protected int computeHashCode() {
        return Utilities.hash((double)this.greenwichLongitude, (int)super.computeHashCode());
    }

    @Override
    public String formatWKT(Formatter formatter) {
        Unit unit = formatter.getAngularUnit();
        if (unit == null) {
            unit = NonSI.DEGREE_ANGLE;
        }
        formatter.append(this.getGreenwichLongitude((Unit<Angle>)unit));
        return "PRIMEM";
    }

    static {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("name", "Greenwich");
        hashMap.put("identifiers", (Object)new NamedIdentifier((Citation)Citations.EPSG, "8901"));
        GREENWICH = new DefaultPrimeMeridian(hashMap, 0.0, (Unit<Angle>)NonSI.DEGREE_ANGLE);
    }
}

