/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.datum;

import java.util.Map;
import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import net.jcip.annotations.Immutable;
import org.geotoolkit.referencing.datum.DefaultEllipsoid;

@Immutable
final class Spheroid
extends DefaultEllipsoid {
    private static final long serialVersionUID = 7867565381280669821L;

    private Spheroid() {
        super(SPHERE);
    }

    protected Spheroid(Map<String, ?> map, double d, boolean bl, Unit<Length> unit) {
        super(map, Spheroid.check("radius", d), d, Double.POSITIVE_INFINITY, bl, unit);
    }

    @Override
    public double orthodromicDistance(double d, double d2, double d3, double d4) {
        d2 = Math.toRadians(d2);
        d4 = Math.toRadians(d4);
        double d5 = Math.toRadians(Math.abs(d3 - d) % 360.0);
        double d6 = Math.sin(d2) * Math.sin(d4) + Math.cos(d2) * Math.cos(d4) * Math.cos(d5);
        assert (Math.abs(d6) < 1.0000001) : d6;
        if (d6 > 1.0) {
            d6 = 1.0;
        }
        if (d6 < -1.0) {
            d6 = -1.0;
        }
        double d7 = Math.acos(d6) * this.getSemiMajorAxis();
        try {
            double d8;
            assert ((d8 = Math.abs(super.orthodromicDistance(d, Math.toDegrees(d2), d3, Math.toDegrees(d4)) - d7)) < this.getSemiMajorAxis() / 1.0E9) : d8;
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        return d7;
    }
}

