/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory;

import java.util.Arrays;
import java.util.Comparator;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.factory.FactoryRegistryException;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.internal.referencing.AxisDirections;
import org.geotoolkit.measure.Units;
import org.geotoolkit.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotoolkit.referencing.factory.AbstractAuthorityFactory;
import org.geotoolkit.referencing.factory.TransformedAuthorityFactory;
import org.geotoolkit.resources.Errors;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CoordinateSystemAxis;

@ThreadSafe
public class OrderedAxisAuthorityFactory
extends TransformedAuthorityFactory
implements CSAuthorityFactory,
CRSAuthorityFactory,
Comparator<CoordinateSystemAxis> {
    private static final AxisDirection[] DEFAULT_ORDER = new AxisDirection[]{AxisDirection.EAST, AxisDirection.EAST_NORTH_EAST, AxisDirection.NORTH_EAST, AxisDirection.NORTH_NORTH_EAST, AxisDirection.NORTH, AxisDirection.UP, AxisDirection.GEOCENTRIC_X, AxisDirection.GEOCENTRIC_Y, AxisDirection.GEOCENTRIC_Z, AxisDirection.COLUMN_POSITIVE, AxisDirection.ROW_POSITIVE, AxisDirection.DISPLAY_RIGHT, AxisDirection.DISPLAY_DOWN, AxisDirection.FUTURE};
    private final int[] directionRanks;
    protected final boolean forceStandardDirections;
    protected final boolean forceStandardUnits;

    public OrderedAxisAuthorityFactory(String string, Hints hints, AxisDirection[] axisDirectionArray) throws FactoryRegistryException, IllegalArgumentException {
        super(string, hints);
        this.forceStandardUnits = OrderedAxisAuthorityFactory.booleanValue(hints, Hints.FORCE_STANDARD_AXIS_UNITS);
        this.forceStandardDirections = OrderedAxisAuthorityFactory.booleanValue(hints, Hints.FORCE_STANDARD_AXIS_DIRECTIONS);
        this.directionRanks = OrderedAxisAuthorityFactory.computeDirectionRanks(axisDirectionArray);
        if (this.isInitialized()) {
            this.putCustomHints();
        }
    }

    public OrderedAxisAuthorityFactory(AbstractAuthorityFactory abstractAuthorityFactory, Hints hints, AxisDirection[] axisDirectionArray) throws IllegalArgumentException {
        super((AuthorityFactory)abstractAuthorityFactory);
        this.forceStandardUnits = OrderedAxisAuthorityFactory.booleanValue(hints, Hints.FORCE_STANDARD_AXIS_UNITS);
        this.forceStandardDirections = OrderedAxisAuthorityFactory.booleanValue(hints, Hints.FORCE_STANDARD_AXIS_DIRECTIONS);
        this.directionRanks = OrderedAxisAuthorityFactory.computeDirectionRanks(axisDirectionArray);
        if (this.isInitialized()) {
            this.putCustomHints();
        }
    }

    private static boolean booleanValue(Hints hints, Hints.Key key) {
        Boolean bl;
        if (hints != null && (bl = (Boolean)hints.get((Object)key)) != null) {
            return bl;
        }
        return false;
    }

    @Override
    final void putCustomHints() {
        this.hints.put(Hints.FORCE_STANDARD_AXIS_UNITS, this.forceStandardUnits);
        this.hints.put(Hints.FORCE_STANDARD_AXIS_DIRECTIONS, this.forceStandardDirections);
        if (this.compare(DefaultCoordinateSystemAxis.EASTING, DefaultCoordinateSystemAxis.NORTHING) < 0) {
            this.hints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.TRUE);
        }
    }

    @Override
    final void toBackingFactoryHints(Hints hints) {
        hints.put((Object)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.FALSE);
        hints.put((Object)Hints.FORCE_STANDARD_AXIS_DIRECTIONS, (Object)Boolean.FALSE);
        hints.put((Object)Hints.FORCE_STANDARD_AXIS_UNITS, (Object)Boolean.FALSE);
    }

    private static int[] computeDirectionRanks(AxisDirection[] axisDirectionArray) throws IllegalArgumentException {
        int n;
        if (axisDirectionArray == null) {
            axisDirectionArray = DEFAULT_ORDER;
        }
        int n2 = 0;
        for (int i = 0; i < axisDirectionArray.length; ++i) {
            n = AxisDirections.absolute(axisDirectionArray[i]).ordinal() + 1;
            if (n <= n2) continue;
            n2 = n;
        }
        int[] nArray = new int[n2];
        Arrays.fill(nArray, n2);
        n = 0;
        while (n < axisDirectionArray.length) {
            int n3 = AxisDirections.absolute(axisDirectionArray[n]).ordinal();
            int n4 = nArray[n3];
            if (n4 != n2) {
                throw new IllegalArgumentException(Errors.format((int)44, (Object)axisDirectionArray[n4].name(), (Object)axisDirectionArray[n].name()));
            }
            nArray[n3] = n++;
        }
        return nArray;
    }

    private int rank(AxisDirection axisDirection) {
        int n = AxisDirections.absolute(axisDirection).ordinal();
        n = n >= 0 && n < this.directionRanks.length ? this.directionRanks[n] : this.directionRanks.length;
        return n;
    }

    @Override
    public int compare(CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) {
        AxisDirection axisDirection = coordinateSystemAxis.getDirection();
        AxisDirection axisDirection2 = coordinateSystemAxis2.getDirection();
        int n = this.rank(axisDirection);
        int n2 = n - this.rank(axisDirection2);
        if (n2 == 0 && n == this.directionRanks.length) {
            double d = DefaultCoordinateSystemAxis.getAngle(axisDirection, axisDirection2);
            if (d > 0.0) {
                return -1;
            }
            if (d < 0.0) {
                return 1;
            }
        }
        return n2;
    }

    @Override
    protected Unit<?> replace(Unit<?> unit) {
        if (this.forceStandardUnits) {
            if (Units.isLinear(unit)) {
                return SI.METRE;
            }
            if (Units.isAngular(unit)) {
                return NonSI.DEGREE_ANGLE;
            }
            if (Units.isTemporal(unit)) {
                return NonSI.DAY;
            }
        }
        return unit;
    }

    @Override
    protected AxisDirection replace(AxisDirection axisDirection) {
        return this.forceStandardDirections ? AxisDirections.absolute(axisDirection) : axisDirection;
    }
}

