/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory.web;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.metadata.iso.citation.DefaultCitation;
import org.geotoolkit.referencing.factory.DirectAuthorityFactory;
import org.geotoolkit.referencing.factory.web.Auto42001;
import org.geotoolkit.referencing.factory.web.Auto42002;
import org.geotoolkit.referencing.factory.web.Auto42003;
import org.geotoolkit.referencing.factory.web.Auto42004;
import org.geotoolkit.referencing.factory.web.Auto42005;
import org.geotoolkit.referencing.factory.web.Code;
import org.geotoolkit.referencing.factory.web.Factlet;
import org.geotoolkit.util.SimpleInternationalString;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

@ThreadSafe
public class AutoCRSFactory
extends DirectAuthorityFactory
implements CRSAuthorityFactory {
    private static final Citation AUTHORITY;
    private final Map<Integer, Factlet> factlets = new TreeMap<Integer, Factlet>();

    public AutoCRSFactory() {
        this(EMPTY_HINTS);
    }

    public AutoCRSFactory(Hints hints) {
        super(hints);
        this.add(Auto42001.DEFAULT);
        this.add(Auto42002.DEFAULT);
        this.add(Auto42003.DEFAULT);
        this.add(Auto42004.DEFAULT);
        this.add(Auto42005.DEFAULT);
    }

    private void add(Factlet factlet) {
        int n = factlet.code();
        if (this.factlets.put(n, factlet) != null) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
    }

    private Factlet findFactlet(Code code) throws NoSuchAuthorityCodeException {
        Integer n;
        Factlet factlet;
        if ((code.authority.equalsIgnoreCase("AUTO") || code.authority.equalsIgnoreCase("AUTO2")) && (factlet = this.factlets.get(n = Integer.valueOf(code.code))) != null) {
            return factlet;
        }
        throw this.noSuchAuthorityCode(code.type, code.toString());
    }

    @Override
    public Citation getAuthority() {
        return AUTHORITY;
    }

    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        if (clazz.isAssignableFrom(ProjectedCRS.class)) {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            for (Integer n : this.factlets.keySet()) {
                linkedHashSet.add(String.valueOf(n));
            }
            return linkedHashSet;
        }
        return Collections.emptySet();
    }

    public InternationalString getDescriptionText(String string) throws FactoryException {
        Code code = new Code(string, ProjectedCRS.class, false);
        return new SimpleInternationalString(this.findFactlet(code).getName());
    }

    @Override
    public IdentifiedObject createObject(String string) throws FactoryException {
        return this.createCoordinateReferenceSystem(string);
    }

    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String string) throws FactoryException {
        return this.createProjectedCRS(string);
    }

    @Override
    public ProjectedCRS createProjectedCRS(String string) throws FactoryException {
        Code code = new Code(string, ProjectedCRS.class, true);
        return this.findFactlet(code).create(code, this.factories);
    }

    static {
        DefaultCitation defaultCitation = new DefaultCitation((Citation)Citations.AUTO2);
        defaultCitation.getIdentifiers().addAll(Citations.AUTO.getIdentifiers());
        defaultCitation.freeze();
        AUTHORITY = defaultCitation;
    }
}

