/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory.wkt;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.referencing.factory.AbstractAuthorityFactory;
import org.geotoolkit.referencing.factory.NoSuchFactoryException;
import org.geotoolkit.referencing.factory.ThreadedAuthorityFactory;
import org.geotoolkit.referencing.factory.wkt.DirectPostgisFactory;
import org.geotoolkit.referencing.factory.wkt.WKTParsingAuthorityFactory;
import org.geotoolkit.util.Disposable;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.util.FactoryException;

final class CachingPostgisFactory
extends ThreadedAuthorityFactory
implements CRSAuthorityFactory,
Disposable {
    private final DataSource datasource;

    CachingPostgisFactory(Hints hints, DataSource dataSource) {
        super(hints, 10, 2);
        this.datasource = dataSource;
        WKTParsingAuthorityFactory.copyRelevantHints(hints, this.hints);
        this.setTimeout(2000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AbstractAuthorityFactory createBackingStore() throws FactoryException {
        Hints hints = EMPTY_HINTS.clone();
        Object object = this;
        synchronized (object) {
            hints.putAll(this.hints);
        }
        try {
            object = this.datasource.getConnection();
        }
        catch (SQLException sQLException) {
            if ("08001".equals(sQLException.getSQLState())) {
                throw new NoSuchFactoryException(sQLException);
            }
            throw new FactoryException((Throwable)sQLException);
        }
        try {
            return new DirectPostgisFactory(hints, (Connection)object);
        }
        catch (SQLException sQLException) {
            try {
                object.close();
            }
            catch (SQLException sQLException2) {
                sQLException.setNextException(sQLException2);
            }
            throw new FactoryException((Throwable)sQLException);
        }
    }

    public void dispose() {
        this.dispose(false);
    }
}

