/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.parameter.Parameters;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.operation.DefaultFormula;
import org.geotoolkit.referencing.operation.transform.ConcatenatedTransform;
import org.geotoolkit.referencing.operation.transform.LinearTransform;
import org.geotoolkit.referencing.operation.transform.Parameterized;
import org.geotoolkit.referencing.operation.transform.PassThroughTransform;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.operation.Formula;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.SingleOperation;

@Immutable
public class DefaultOperationMethod
extends AbstractIdentifiedObject
implements OperationMethod {
    private static final long serialVersionUID = -8181774670648793964L;
    private static final String[] LOCALIZABLES = new String[]{"formula"};
    private final Formula formula;
    protected final Integer sourceDimension;
    protected final Integer targetDimension;
    private final ParameterDescriptorGroup parameters;

    public DefaultOperationMethod(MathTransform mathTransform) {
        this(DefaultOperationMethod.getProperties(mathTransform), mathTransform.getSourceDimensions(), mathTransform.getTargetDimensions(), DefaultOperationMethod.getDescriptor(mathTransform));
    }

    private static Map<String, ?> getProperties(MathTransform mathTransform) {
        Parameterized parameterized;
        ParameterDescriptorGroup parameterDescriptorGroup;
        ArgumentChecks.ensureNonNull((String)"transform", (Object)mathTransform);
        if (mathTransform instanceof Parameterized && (parameterDescriptorGroup = (parameterized = (Parameterized)mathTransform).getParameterDescriptors()) != null) {
            return IdentifiedObjects.getProperties((IdentifiedObject)parameterDescriptorGroup, null);
        }
        return Collections.singletonMap("name", Vocabulary.format((int)309));
    }

    private static ParameterDescriptorGroup getDescriptor(MathTransform mathTransform) {
        ParameterDescriptorGroup parameterDescriptorGroup = null;
        if (mathTransform instanceof Parameterized) {
            parameterDescriptorGroup = ((Parameterized)mathTransform).getParameterDescriptors();
        }
        return parameterDescriptorGroup;
    }

    public DefaultOperationMethod(OperationMethod operationMethod) {
        super((IdentifiedObject)operationMethod);
        this.formula = operationMethod.getFormula();
        this.parameters = operationMethod.getParameters();
        this.sourceDimension = operationMethod.getSourceDimensions();
        this.targetDimension = operationMethod.getTargetDimensions();
    }

    public DefaultOperationMethod(OperationMethod operationMethod, Integer n, Integer n2) {
        super((IdentifiedObject)operationMethod);
        this.formula = operationMethod.getFormula();
        this.parameters = operationMethod.getParameters();
        this.sourceDimension = n;
        this.targetDimension = n2;
        this.checkDimension();
    }

    public DefaultOperationMethod(Map<String, ?> map, Integer n, Integer n2, ParameterDescriptorGroup parameterDescriptorGroup) {
        this(map, new HashMap<String, Object>(), n, n2, parameterDescriptorGroup);
    }

    private DefaultOperationMethod(Map<String, ?> map, Map<String, Object> map2, Integer n, Integer n2, ParameterDescriptorGroup parameterDescriptorGroup) {
        super(map, map2, LOCALIZABLES);
        Object object = map2.get("formula");
        if (object != null) {
            if (object instanceof Citation) {
                object = new DefaultFormula((Citation)object);
            } else if (object instanceof CharSequence) {
                object = new DefaultFormula((CharSequence)object);
            } else if (!(object instanceof Formula)) {
                throw new InvalidParameterValueException(Errors.format((int)73, (Object)"formula", (Object)object), "formula", object);
            }
        }
        this.formula = (Formula)object;
        this.parameters = parameterDescriptorGroup;
        this.sourceDimension = n;
        this.targetDimension = n2;
        this.checkDimension();
    }

    private void checkDimension() {
        if (this.sourceDimension != null) {
            ArgumentChecks.ensurePositive((String)"sourceDimension", (int)this.sourceDimension);
        }
        if (this.targetDimension != null) {
            ArgumentChecks.ensurePositive((String)"targetDimension", (int)this.targetDimension);
        }
    }

    public Formula getFormula() {
        return this.formula;
    }

    public Integer getSourceDimensions() {
        return this.sourceDimension;
    }

    public Integer getTargetDimensions() {
        return this.targetDimension;
    }

    public ParameterDescriptorGroup getParameters() {
        return this.parameters != null ? this.parameters : Parameters.EMPTY_GROUP;
    }

    Class<? extends SingleOperation> getOperationType() {
        return Projection.class;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            switch (comparisonMode) {
                case BY_CONTRACT: {
                    if (!Utilities.equals((Object)this.getFormula(), (Object)((OperationMethod)object).getFormula())) {
                        return false;
                    }
                }
                default: {
                    OperationMethod operationMethod = (OperationMethod)object;
                    return Utilities.equals((Object)this.getSourceDimensions(), (Object)operationMethod.getSourceDimensions()) && Utilities.equals((Object)this.getTargetDimensions(), (Object)operationMethod.getTargetDimensions()) && Utilities.deepEquals((Object)this.getParameters(), (Object)operationMethod.getParameters(), (ComparisonMode)comparisonMode);
                }
                case STRICT: 
            }
            DefaultOperationMethod defaultOperationMethod = (DefaultOperationMethod)object;
            return Utilities.equals((Object)this.formula, (Object)defaultOperationMethod.formula) && Utilities.equals((Object)this.sourceDimension, (Object)defaultOperationMethod.sourceDimension) && Utilities.equals((Object)this.targetDimension, (Object)defaultOperationMethod.targetDimension) && Utilities.equals((Object)this.parameters, (Object)defaultOperationMethod.parameters);
        }
        return false;
    }

    @Override
    protected int computeHashCode() {
        return Utilities.hash((Object)this.sourceDimension, (int)Utilities.hash((Object)this.targetDimension, (int)Utilities.hash((Object)this.parameters, (int)super.computeHashCode())));
    }

    @Override
    public String formatWKT(Formatter formatter) {
        if (Projection.class.isAssignableFrom(this.getOperationType())) {
            return "PROJECTION";
        }
        return super.formatWKT(formatter);
    }

    private static boolean isTrivial(MathTransform mathTransform) {
        if (mathTransform instanceof LinearTransform) {
            Matrix matrix = ((LinearTransform)mathTransform).getMatrix();
            int n = matrix.getNumRow();
            if (matrix.getNumCol() == n) {
                for (int i = 0; i < n; ++i) {
                    int n2 = 0;
                    int n3 = 0;
                    for (int j = 0; j < n; ++j) {
                        if (matrix.getElement(i, j) != 0.0) {
                            ++n2;
                        }
                        if (matrix.getElement(j, i) == 0.0) continue;
                        ++n3;
                    }
                    if (n2 == 1 && n3 == true) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static void checkDimensions(OperationMethod operationMethod, MathTransform mathTransform) throws MismatchedDimensionException {
        Object object;
        int n;
        if (operationMethod == null || mathTransform == null) {
            return;
        }
        Integer n2 = operationMethod.getSourceDimensions();
        if (n2 == null) {
            return;
        }
        while ((n = mathTransform.getSourceDimensions()) > n2) {
            if (mathTransform instanceof ConcatenatedTransform) {
                object = (ConcatenatedTransform)mathTransform;
                if (DefaultOperationMethod.isTrivial(((ConcatenatedTransform)object).transform1)) {
                    mathTransform = ((ConcatenatedTransform)object).transform2;
                    continue;
                }
                if (!DefaultOperationMethod.isTrivial(((ConcatenatedTransform)object).transform2)) break;
                mathTransform = ((ConcatenatedTransform)object).transform1;
                continue;
            }
            if (!(mathTransform instanceof PassThroughTransform)) break;
            mathTransform = ((PassThroughTransform)mathTransform).getSubTransform();
        }
        if (n != n2) {
            object = "sourceDimension";
        } else {
            n2 = operationMethod.getTargetDimensions();
            if (n2 == null) {
                return;
            }
            n = mathTransform.getTargetDimensions();
            if (n != n2) {
                object = "targetDimension";
            } else {
                return;
            }
        }
        throw new IllegalArgumentException(Errors.format((int)113, (Object)object, (Object)n, (Object)n2));
    }
}

