/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation;

import java.util.Collections;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.operation.DefaultConversion;
import org.geotoolkit.referencing.operation.DefaultOperationMethod;
import org.geotoolkit.util.ArgumentChecks;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;

@Immutable
public class DefiningConversion
extends DefaultConversion {
    private static final long serialVersionUID = 7399026512478064721L;
    private final ParameterValueGroup parameters;

    public DefiningConversion(String string, ParameterValueGroup parameterValueGroup) {
        this(Collections.singletonMap("name", string), DefiningConversion.getOperationMethod(parameterValueGroup), parameterValueGroup);
    }

    private static OperationMethod getOperationMethod(ParameterValueGroup parameterValueGroup) {
        ArgumentChecks.ensureNonNull((String)"parameters", (Object)parameterValueGroup);
        ParameterDescriptorGroup parameterDescriptorGroup = parameterValueGroup.getDescriptor();
        return new DefaultOperationMethod(IdentifiedObjects.getProperties((IdentifiedObject)parameterDescriptorGroup, null), 2, 2, parameterDescriptorGroup);
    }

    public DefiningConversion(Map<String, ?> map, OperationMethod operationMethod, ParameterValueGroup parameterValueGroup) {
        super(map, null, null, null, operationMethod);
        ArgumentChecks.ensureNonNull((String)"parameters", (Object)parameterValueGroup);
        this.parameters = parameterValueGroup.clone();
    }

    public DefiningConversion(Map<String, ?> map, OperationMethod operationMethod, MathTransform mathTransform) {
        super(map, null, null, mathTransform, operationMethod);
        this.parameters = null;
    }

    @Override
    void validate() throws IllegalArgumentException {
        if (this.transform == null) {
            super.validate();
        }
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return this.parameters != null ? this.parameters.clone() : super.getParameterValues();
    }

    @Override
    public String formatWKT(Formatter formatter) {
        String string = super.formatWKT(formatter);
        formatter.append((GeneralParameterValue)this.parameters);
        return string;
    }
}

