/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.matrix;

import java.awt.geom.AffineTransform;
import org.geotoolkit.lang.Static;
import org.geotoolkit.referencing.operation.matrix.GeneralMatrix;
import org.geotoolkit.referencing.operation.matrix.Matrix1;
import org.geotoolkit.referencing.operation.matrix.Matrix2;
import org.geotoolkit.referencing.operation.matrix.Matrix3;
import org.geotoolkit.referencing.operation.matrix.Matrix4;
import org.geotoolkit.referencing.operation.matrix.XMatrix;
import org.geotoolkit.referencing.operation.transform.LinearTransform;
import org.geotoolkit.resources.Errors;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;

public final class MatrixFactory
extends Static {
    private MatrixFactory() {
    }

    public static XMatrix create(int n) {
        switch (n) {
            case 1: {
                return new Matrix1();
            }
            case 2: {
                return new Matrix2();
            }
            case 3: {
                return new Matrix3();
            }
            case 4: {
                return new Matrix4();
            }
        }
        return new GeneralMatrix(n);
    }

    public static XMatrix create(int n, int n2) {
        if (n == n2) {
            return MatrixFactory.create(n);
        }
        return new GeneralMatrix(n, n2);
    }

    public static XMatrix create(int n, int n2, double[] dArray) {
        if (n * n2 != dArray.length) {
            throw new IllegalArgumentException(Errors.format((int)109));
        }
        if (n == n2) {
            switch (n) {
                case 1: {
                    return new Matrix1(dArray[0]);
                }
                case 2: {
                    return new Matrix2(dArray);
                }
                case 3: {
                    return new Matrix3(dArray);
                }
                case 4: {
                    return new Matrix4(dArray);
                }
            }
        }
        return new GeneralMatrix(n, n2, dArray);
    }

    public static XMatrix create(Matrix matrix) {
        int n = matrix.getNumRow();
        if (n == matrix.getNumCol()) {
            switch (n) {
                case 1: {
                    return new Matrix1(matrix);
                }
                case 2: {
                    return new Matrix2(matrix);
                }
                case 3: {
                    return new Matrix3(matrix);
                }
                case 4: {
                    return new Matrix4(matrix);
                }
            }
        }
        return new GeneralMatrix(matrix);
    }

    public static Matrix getMatrix(MathTransform mathTransform) {
        if (mathTransform instanceof LinearTransform) {
            return ((LinearTransform)mathTransform).getMatrix();
        }
        if (mathTransform instanceof AffineTransform) {
            return new Matrix3((AffineTransform)mathTransform);
        }
        return null;
    }

    public static XMatrix toXMatrix(Matrix matrix) {
        if (matrix == null || matrix instanceof XMatrix) {
            return (XMatrix)matrix;
        }
        return MatrixFactory.create(matrix);
    }

    public static XMatrix toOptimalMatrix(Matrix matrix) {
        int n;
        if (matrix != null && (n = matrix.getNumRow()) == matrix.getNumCol()) {
            switch (n) {
                case 1: {
                    return matrix instanceof Matrix1 ? (Matrix1)matrix : new Matrix1(matrix);
                }
                case 2: {
                    return matrix instanceof Matrix2 ? (Matrix2)matrix : new Matrix2(matrix);
                }
                case 3: {
                    return matrix instanceof Matrix3 ? (Matrix3)matrix : new Matrix3(matrix);
                }
                case 4: {
                    return matrix instanceof Matrix4 ? (Matrix4)matrix : new Matrix4(matrix);
                }
            }
        }
        return MatrixFactory.toXMatrix(matrix);
    }

    public static GeneralMatrix toGeneralMatrix(Matrix matrix) {
        if (matrix == null || matrix instanceof GeneralMatrix) {
            return (GeneralMatrix)matrix;
        }
        return new GeneralMatrix(matrix);
    }
}

