/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import org.geotoolkit.lang.Static;
import org.geotoolkit.measure.Latitude;
import org.geotoolkit.measure.Longitude;
import org.geotoolkit.referencing.operation.projection.ProjectionError;
import org.geotoolkit.referencing.operation.projection.ProjectionException;
import org.geotoolkit.referencing.operation.projection.UnitaryProjection;
import org.geotoolkit.resources.Errors;
import org.opengis.referencing.operation.Matrix;

final class Assertions
extends Static {
    private static final double INVERSE_TOLERANCE = 1.0E-7;
    private static final double FORWARD_TOLERANCE = 1.0E-7;
    private static final double DERIVATIVE_TOLERANCE = 0.1;
    static final double ERROR_SCALE = 1.5;

    private Assertions() {
    }

    private static double orthodromicDistance(double d, double d2, double d3, double d4) {
        double d5 = Math.abs(d3 - d) % (Math.PI * 2);
        double d6 = Math.sin(d2) * Math.sin(d4) + Math.cos(d2) * Math.cos(d4) * Math.cos(d5);
        if (d6 > 1.0) {
            assert (d6 <= 1.0000000001) : d6;
            d6 = 1.0;
        }
        if (d6 < -1.0) {
            assert (d6 >= -1.0000000001) : d6;
            d6 = -1.0;
        }
        return Math.acos(d6);
    }

    static boolean checkReciprocal(UnitaryProjection unitaryProjection, boolean bl, double[] dArray, int n, double[] dArray2, int n2, int n3) throws ProjectionException {
        if (dArray2 == dArray) {
            int n4 = (n2 - n) / 2;
            if (n4 >= 0) {
                if (n4 < n3) {
                    n3 = n4;
                }
            } else if ((n4 = -n4) < n3) {
                n2 += (n3 -= n4) * 2;
                n += n3 * 2;
                n3 = n4;
            }
        }
        if (--n3 >= 0) {
            double[] dArray3 = new double[2];
            do {
                double d;
                double d2;
                double d3;
                if (bl) {
                    unitaryProjection.inverseTransform(dArray2, n2, dArray3, 0);
                    d3 = dArray3[0];
                    d2 = dArray3[1];
                    d = Assertions.orthodromicDistance(d3, d2, dArray[n++], dArray[n++]);
                } else {
                    unitaryProjection.transform(dArray2, n2, dArray3, 0);
                    d3 = dArray2[n2++];
                    d2 = dArray2[n2++];
                    d = Math.hypot(dArray[n++] - dArray3[0], dArray[n++] - dArray3[1]);
                }
                double d4 = unitaryProjection.getErrorEstimate(d3, d2);
                if (d > d4 * 1.5 + 1.0E-7) {
                    UnitaryProjection.Parameters parameters = unitaryProjection.getUnmarshalledParameters();
                    throw new ProjectionError(Errors.format((int)190, (Object)(d * parameters.semiMajor), (Object)new Longitude(Math.toDegrees(d3) - parameters.centralMeridian), (Object)new Latitude(Math.toDegrees(d2) - parameters.latitudeOfOrigin), (Object)unitaryProjection.getName()));
                }
                n2 += 2;
            } while (--n3 >= 0);
        }
        return true;
    }

    static boolean checkTransform(double[] dArray, int n, double d, double d2, double d3) throws ProjectionException {
        Assertions.compare("x", dArray[n++], d, d3);
        Assertions.compare("y", dArray[n++], d2, d3);
        return d3 < Double.POSITIVE_INFINITY;
    }

    static boolean checkTransform(double[] dArray, int n, double d, double d2) throws ProjectionException {
        return Assertions.checkTransform(dArray, n, d, d2, 1.0E-7);
    }

    static boolean checkInverseTransform(double[] dArray, int n, double d, double d2, double d3) throws ProjectionException {
        Assertions.compare("latitude", dArray[n + 1], d2, d3);
        if (Math.abs(1.5707963267948966 - Math.abs(d2)) > 1.0E-6) {
            Assertions.compare("longitude", dArray[n], d, d3);
        }
        return d3 < Double.POSITIVE_INFINITY;
    }

    static boolean checkInverseTransform(double[] dArray, int n, double d, double d2) throws ProjectionException {
        return Assertions.checkInverseTransform(dArray, n, d, d2, 1.0E-7);
    }

    static boolean checkDerivative(Matrix matrix, Matrix matrix2) throws ProjectionException {
        Assertions.compare("m00", matrix.getElement(0, 0), matrix2.getElement(0, 0), 0.1);
        Assertions.compare("m01", matrix.getElement(0, 1), matrix2.getElement(0, 1), 0.1);
        Assertions.compare("m10", matrix.getElement(1, 0), matrix2.getElement(1, 0), 0.1);
        Assertions.compare("m11", matrix.getElement(1, 1), matrix2.getElement(1, 1), 0.1);
        return true;
    }

    private static void compare(String string, double d, double d2, double d3) throws ProjectionException {
        if (Math.abs(d - d2) > d3) {
            if (string.charAt(0) == 'l') {
                d2 = Math.toDegrees(d2);
                d = Math.toDegrees(d);
            } else if (Math.abs(d2) > 30.0 && Math.abs(d) > 30.0 && Math.signum(d2) == Math.signum(d)) {
                return;
            }
            throw new ProjectionError(Errors.format((int)197, (Object)string, (Object)d, (Object)d2));
        }
    }
}

