/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import java.awt.geom.AffineTransform;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.Identifiers;
import org.geotoolkit.internal.referencing.ParameterizedAffine;
import org.geotoolkit.referencing.operation.projection.ProjectionException;
import org.geotoolkit.referencing.operation.projection.UnitaryProjection;
import org.geotoolkit.referencing.operation.provider.EquidistantCylindrical;
import org.geotoolkit.referencing.operation.transform.Parameterized;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

@Immutable
public class Equirectangular
extends UnitaryProjection {
    private static final long serialVersionUID = -848975059471102069L;

    public static MathTransform2D create(ParameterDescriptorGroup parameterDescriptorGroup, ParameterValueGroup parameterValueGroup) {
        UnitaryProjection.Parameters parameters = new UnitaryProjection.Parameters(parameterDescriptorGroup, parameterValueGroup);
        Equirectangular equirectangular = new Equirectangular(parameters);
        MathTransform2D mathTransform2D = equirectangular.createConcatenatedTransform();
        if (mathTransform2D instanceof AffineTransform) {
            mathTransform2D = new Affine((AffineTransform)mathTransform2D, parameters);
        }
        return mathTransform2D;
    }

    protected Equirectangular(UnitaryProjection.Parameters parameters) {
        super(parameters);
        double d;
        if (parameters.standardParallels.length != 0) {
            throw Equirectangular.unknownParameter(Identifiers.STANDARD_PARALLEL_1);
        }
        parameters.latitudeOfOrigin = d = Math.abs(parameters.latitudeOfOrigin);
        d = Math.toRadians(d);
        parameters.normalize(true).scale(Math.cos(d), 1.0);
        parameters.validate();
        d = Math.sin(d);
        d = Math.sqrt(1.0 - this.excentricitySquared) / (1.0 - d * d * this.excentricitySquared);
        parameters.normalize(false).scale(d, d);
        this.finish();
    }

    @Override
    boolean isSpherical() {
        return true;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return EquidistantCylindrical.PARAMETERS;
    }

    @Override
    protected void transform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d = dArray[n + 1];
        dArray2[n2] = this.rollLongitude(dArray[n]);
        dArray2[n2 + 1] = d;
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
        if (dArray != dArray2 || n != n2) {
            super.transform(dArray, n, dArray2, n2, n3);
            return;
        }
        if (this.verifyCoordinateRanges()) {
            this.verifyGeographicRanges(dArray, n, n3);
        }
        while (--n3 >= 0) {
            dArray2[n2] = this.rollLongitude(dArray2[n2]);
            n2 += 2;
        }
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d = dArray[n + 1];
        dArray2[n2] = this.unrollLongitude(dArray[n]);
        dArray2[n2 + 1] = d;
    }

    @Override
    public boolean isIdentity() {
        return !this.rollLongitude();
    }

    @Override
    double getErrorEstimate(double d, double d2) {
        return 0.0;
    }

    private static final class Affine
    extends ParameterizedAffine {
        private static final long serialVersionUID = -4667404054723855507L;

        public Affine(AffineTransform affineTransform, Parameterized parameterized) {
            super(affineTransform, parameterized);
        }

        @Override
        public ParameterDescriptorGroup getParameterDescriptors() {
            return this.parameters.getParameterDescriptors();
        }

        @Override
        public ParameterValueGroup getParameterValues() {
            return this.parameters.getParameterValues();
        }
    }
}

