/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import java.awt.geom.Point2D;
import net.jcip.annotations.Immutable;
import org.geotoolkit.referencing.operation.matrix.Matrix2;
import org.geotoolkit.referencing.operation.projection.Assertions;
import org.geotoolkit.referencing.operation.projection.CassiniOrMercator;
import org.geotoolkit.referencing.operation.projection.ProjectionException;
import org.geotoolkit.referencing.operation.projection.UnitaryProjection;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;

@Immutable
public class Polyconic
extends CassiniOrMercator {
    private static final long serialVersionUID = -4178027711158788385L;

    public static MathTransform2D create(ParameterDescriptorGroup parameterDescriptorGroup, ParameterValueGroup parameterValueGroup) {
        UnitaryProjection.Parameters parameters = new UnitaryProjection.Parameters(parameterDescriptorGroup, parameterValueGroup);
        Polyconic polyconic = parameters.isSpherical() ? new Spherical(parameters) : new Polyconic(parameters);
        return polyconic.createConcatenatedTransform();
    }

    protected Polyconic(UnitaryProjection.Parameters parameters) {
        super(parameters);
    }

    @Override
    protected void transform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d;
        double d2 = this.rollLongitude(dArray[n]);
        double d3 = dArray[n + 1];
        double d4 = Math.sin(d3);
        double d5 = this.msfn(d4, d = Math.cos(d3)) / d4;
        if (Double.isInfinite(d5)) {
            dArray2[n2] = d2;
            return;
        }
        double d6 = d2 * d4;
        dArray2[n2 + 1] = d5 * (1.0 - Math.cos(d6)) + this.mlfn(d3, d4, d);
        dArray2[n2] = d5 * Math.sin(d6);
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d;
        double d2;
        double d3 = dArray[n];
        double d4 = dArray[n + 1];
        if (Math.abs(d4) <= 1.0E-7) {
            d2 = 0.0;
            d = d3;
        } else {
            double d5;
            double d6;
            d2 = d4;
            double d7 = d4 * d4 + d3 * d3;
            double d8 = 2.0 * d4;
            int n3 = 15;
            do {
                if (--n3 < 0) {
                    throw new ProjectionException(152);
                }
                d5 = Math.cos(d2);
                if (Math.abs(d5) < 1.0E-10) break;
                double d9 = Math.sin(d2);
                double d10 = d9 * d5;
                double d11 = Math.sqrt(1.0 - this.excentricitySquared * (d9 * d9));
                double d12 = d11 * d9 / d5;
                double d13 = this.mlfn(d2, d9, d5);
                double d14 = d13 * d13 + d7;
                d11 = (1.0 - this.excentricitySquared) / (d11 * d11 * d11);
                d6 = (2.0 * d13 + d12 * d14 - d8 * (d12 * d13 + 1.0)) / (this.excentricitySquared * d10 * (d14 - d8 * d13) / d12 + (d8 - 2.0 * d13) * (d12 * d11 - 1.0 / d10) - 2.0 * d11);
                d2 += d6;
            } while (Math.abs(d6) > 1.0E-10);
            d5 = Math.sin(d2);
            d = Math.asin(d3 * Math.tan(d2) * Math.sqrt(1.0 - this.excentricitySquared * (d5 * d5))) / d5;
        }
        dArray2[n2] = this.unrollLongitude(d);
        dArray2[n2 + 1] = d2;
    }

    @Override
    public Matrix derivative(Point2D point2D) throws ProjectionException {
        double d;
        double d2 = this.rollLongitude(point2D.getX());
        double d3 = point2D.getY();
        double d4 = Math.sin(d3);
        double d5 = this.msfn(d4, d = Math.cos(d3));
        double d6 = d5 / d4;
        if (Double.isInfinite(d6)) {
            return new Matrix2();
        }
        double d7 = this.dmsfn_d\u03c6(d4, d, d5) - d / d4;
        double d8 = d2 * d4;
        double d9 = Math.sin(d8);
        double d10 = Math.cos(d8);
        double d11 = d2 * d;
        return new Matrix2(d5 * d10, d6 * (d11 * d10 + d7 * d9), d5 * d9, d6 * (d11 * d9 + d7 * (1.0 - d10)) + this.dmlfn_d\u03c6(d4 * d4, d * d));
    }

    @Override
    double getErrorEstimate(double d, double d2) {
        return 0.0;
    }

    @Immutable
    static final class Spherical
    extends Polyconic {
        private static final long serialVersionUID = 8669570024272104893L;
        private final double phi0;

        Spherical(UnitaryProjection.Parameters parameters) {
            super(parameters);
            this.phi0 = Math.toRadians(parameters.latitudeOfOrigin);
        }

        @Override
        final boolean isSpherical() {
            return true;
        }

        @Override
        protected void transform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
            double d = this.rollLongitude(dArray[n]);
            double d2 = dArray[n + 1];
            double d3 = d * Math.sin(d2);
            double d4 = 1.0 / Math.tan(d2);
            double d5 = Math.sin(d3) * d4;
            double d6 = d2 - this.phi0 + d4 * (1.0 - Math.cos(d3));
            assert (this.checkTransform(dArray, n, dArray2, n2, d5, d6));
            dArray2[n2] = d5;
            dArray2[n2 + 1] = d6;
        }

        private boolean checkTransform(double[] dArray, int n, double[] dArray2, int n2, double d, double d2) throws ProjectionException {
            super.transform(dArray, n, dArray2, n2);
            return Assertions.checkTransform(dArray2, n2, d, d2);
        }

        @Override
        protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
            double d;
            double d2;
            double d3 = this.unrollLongitude(dArray[n]);
            double d4 = dArray[n + 1];
            if (Math.abs(d4) <= 1.0E-7) {
                d2 = d3;
                d = 0.0;
            } else {
                double d5;
                d = d4;
                double d6 = d3 * d3 + d4 * d4;
                int n3 = 15;
                do {
                    if (--n3 < 0) {
                        throw new ProjectionException(152);
                    }
                    double d7 = Math.tan(d);
                    d5 = (d4 * (d * d7 + 1.0) - d - 0.5 * (d * d + d6) * d7) / ((d - d4) / d7 - 1.0);
                    d -= d5;
                } while (Math.abs(d5) > 1.0E-10);
                d2 = Math.asin(d3 * Math.tan(d)) / Math.sin(d);
            }
            assert (this.checkInverseTransform(dArray, n, dArray2, n2, d2, d));
            dArray2[n2] = d2;
            dArray2[n2 + 1] = d;
        }

        private boolean checkInverseTransform(double[] dArray, int n, double[] dArray2, int n2, double d, double d2) throws ProjectionException {
            super.inverseTransform(dArray, n, dArray2, n2);
            return Assertions.checkInverseTransform(dArray2, n2, d, d2);
        }

        @Override
        public Matrix derivative(Point2D point2D) throws ProjectionException {
            double d = this.rollLongitude(point2D.getX());
            double d2 = point2D.getY();
            double d3 = Math.sin(d2);
            double d4 = Math.cos(d2);
            double d5 = d3 * d3;
            double d6 = d4 * d4 / d5;
            double d7 = d * d3;
            double d8 = Math.cos(d7);
            double d9 = Math.sin(d7);
            Matrix2 matrix2 = new Matrix2(d4 * d8, d6 * (d8 * d7 - d9) - d9, d4 * d9, d6 * (d9 * d7) + (d8 - 1.0) / d5 + 1.0);
            assert (Assertions.checkDerivative(matrix2, super.derivative(point2D)));
            return matrix2;
        }
    }
}

