/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import java.awt.geom.Point2D;
import net.jcip.annotations.Immutable;
import org.geotoolkit.referencing.operation.matrix.Matrix2;
import org.geotoolkit.referencing.operation.projection.Assertions;
import org.geotoolkit.referencing.operation.projection.CassiniOrMercator;
import org.geotoolkit.referencing.operation.projection.ProjectionException;
import org.geotoolkit.referencing.operation.projection.UnitaryProjection;
import org.geotoolkit.resources.Errors;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;

@Immutable
public class TransverseMercator
extends CassiniOrMercator {
    private static final long serialVersionUID = -4717976245811852528L;
    private final double esp;
    private static final double FC1 = 1.0;
    private static final double FC2 = 0.5;
    private static final double FC3 = 0.16666666666666666;
    private static final double FC4 = 0.08333333333333333;
    private static final double FC5 = 0.05;
    private static final double FC6 = 0.03333333333333333;
    private static final double FC7 = 0.023809523809523808;
    private static final double FC8 = 0.017857142857142856;

    public static MathTransform2D create(ParameterDescriptorGroup parameterDescriptorGroup, ParameterValueGroup parameterValueGroup) {
        Parameters parameters = new Parameters(parameterDescriptorGroup, parameterValueGroup);
        TransverseMercator transverseMercator = parameters.isSpherical() ? new Spherical(parameters) : new TransverseMercator(parameters);
        return transverseMercator.createConcatenatedTransform();
    }

    protected TransverseMercator(Parameters parameters) {
        super(parameters);
        this.esp = this.excentricitySquared / (1.0 - this.excentricitySquared);
    }

    @Override
    protected void transform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d = this.rollLongitude(dArray[n]);
        double d2 = dArray[n + 1];
        double d3 = Math.sin(d2);
        double d4 = Math.cos(d2);
        double d5 = Math.abs(d4) > 1.0E-6 ? d3 / d4 : 0.0;
        d5 *= d5;
        double d6 = d4 * d;
        double d7 = d6 * d6;
        double d8 = this.esp * d4 * d4;
        dArray2[n2] = (d6 /= Math.sqrt(1.0 - this.excentricitySquared * (d3 * d3))) * (1.0 + 0.16666666666666666 * d7 * (1.0 - d5 + d8 + 0.05 * d7 * (5.0 + d5 * (d5 - 18.0) + d8 * (14.0 - 58.0 * d5) + 0.023809523809523808 * d7 * (61.0 + d5 * (d5 * (179.0 - d5) - 479.0)))));
        dArray2[n2 + 1] = this.mlfn(d2, d3, d4) + d3 * d6 * d * 0.5 * (1.0 + 0.08333333333333333 * d7 * (5.0 - d5 + d8 * (9.0 + 4.0 * d8) + 0.03333333333333333 * d7 * (61.0 + d5 * (d5 - 58.0) + d8 * (270.0 - 330.0 * d5) + 0.017857142857142856 * d7 * (1385.0 + d5 * (d5 * (543.0 - d5) - 3111.0)))));
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        double d3 = this.inv_mlfn(d2);
        if (Math.abs(d3) >= 1.5707963267948966) {
            d2 = Math.copySign(1.5707963267948966, d2);
            d = 0.0;
        } else {
            double d4 = Math.sin(d3);
            double d5 = Math.cos(d3);
            double d6 = Math.abs(d5) > 1.0E-6 ? d4 / d5 : 0.0;
            double d7 = this.esp * d5 * d5;
            double d8 = 1.0 - this.excentricitySquared * (d4 * d4);
            double d9 = d * Math.sqrt(d8);
            d8 *= d6;
            d6 *= d6;
            double d10 = d9 * d9;
            d2 = d3 - d8 * d10 / (1.0 - this.excentricitySquared) * 0.5 * (1.0 - d10 * 0.08333333333333333 * (5.0 + d6 * (3.0 - 9.0 * d7) + d7 * (1.0 - 4.0 * d7) - d10 * 0.03333333333333333 * (61.0 + d6 * (90.0 - 252.0 * d7 + 45.0 * d6) + 46.0 * d7 - d10 * 0.017857142857142856 * (1385.0 + d6 * (3633.0 + d6 * (4095.0 + 1574.0 * d6))))));
            d = d9 * (1.0 - d10 * 0.16666666666666666 * (1.0 + 2.0 * d6 + d7 - d10 * 0.05 * (5.0 + d6 * (28.0 + 24.0 * d6 + 8.0 * d7) + 6.0 * d7 - d10 * 0.023809523809523808 * (61.0 + d6 * (662.0 + d6 * (1320.0 + 720.0 * d6)))))) / d5;
        }
        dArray2[n2] = this.unrollLongitude(d);
        dArray2[n2 + 1] = d2;
    }

    @Override
    public Matrix derivative(Point2D point2D) throws ProjectionException {
        double d;
        double d2;
        double d3 = this.rollLongitude(point2D.getX());
        double d4 = point2D.getY();
        double d5 = d3 * d3;
        double d6 = Math.sin(d4);
        double d7 = d6 * d6;
        double d8 = Math.cos(d4);
        double d9 = d8 * d8;
        double d10 = d6 / d8;
        if (Math.abs(d8) > 1.0E-6) {
            d2 = d10 * d10;
            d = 2.0 * d10 * (1.0 + d2);
        } else {
            d2 = 0.0;
            d = 0.0;
        }
        double d11 = 14.0 - 58.0 * d2;
        double d12 = (9.0 - 11.0 * d2) * 30.0;
        double d13 = d8 * d3;
        double d14 = d13 * d13;
        double d15 = 2.0 * d13 * d8;
        double d16 = -2.0 * d13 * d6 * d3;
        double d17 = Math.sqrt(1.0 - this.excentricitySquared * d7);
        double d18 = d3 * d6 * (this.excentricitySquared - 1.0) / (1.0 - this.excentricitySquared * d7);
        double d19 = this.esp * d9;
        double d20 = -2.0 * d19 * d10;
        double d21 = ((179.0 - d2) * d2 - 479.0) * d2 + 61.0;
        double d22 = ((543.0 - d2) * d2 - 3111.0) * d2 + 1385.0;
        double d23 = ((358.0 - 3.0 * d2) * d2 - 479.0) * d;
        double d24 = ((1086.0 - 3.0 * d2) * d2 - 3099.0) * d;
        double d25 = 5.0 + (d2 - 18.0) * d2 + d9 * (this.esp * d11 + 0.023809523809523808 * d5 * d21);
        double d26 = 0.023809523809523808 * (d15 * d21);
        double d27 = 0.023809523809523808 * (d16 * d21 + d23 * d14) + (2.0 * d2 + 58.0 * d19 - 18.0) * d + d11 * d20;
        double d28 = 0.05 * (d15 * d25 + d26 * d14);
        double d29 = 0.05 * (d16 * d25 + d27 * d14) - d + d20;
        double d30 = 0.05 * (d14 * d25) - d2 + d19 + 1.0;
        double d31 = 0.16666666666666666 * (d15 * d30 + d28 * d14);
        double d32 = 0.16666666666666666 * (d16 * d30 + d29 * d14);
        double d33 = 0.16666666666666666 * (d14 * d30) + 1.0;
        double d34 = 0.017857142857142856 * (d14 * d22) + (d2 - 58.0) * d2 + d12 * d19 + 61.0;
        double d35 = 0.017857142857142856 * (d16 * d22 + d24 * d14) + 2.0 * (d2 - 145.0 * d19 - 29.0) * d + d12 * d20;
        double d36 = 0.03333333333333333 * d15 * (d34 + 0.017857142857142856 * d22 * d14);
        double d37 = 0.03333333333333333 * (d16 * d34 + d35 * d14) + (9.0 + 8.0 * d19) * d20 - d;
        double d38 = 0.03333333333333333 * (d14 * d34) + (9.0 + 4.0 * d19) * d19 - d2 + 5.0;
        double d39 = 0.08333333333333333 * (d14 * d38) + 1.0;
        double d40 = 0.08333333333333333 * (d15 * d38 + d36 * d14);
        double d41 = 0.08333333333333333 * (d16 * d38 + d37 * d14);
        return new Matrix2((d8 * d33 + d31 * d13) / d17, (d18 * d33 + d32 * d13) / d17, 0.5 * d6 * d13 * (2.0 * d39 + d40 * d3) / d17, 0.5 * ((d14 + d3 * d6 * d18) * d39 + d5 * d6 * d8 * d41) / d17 + this.dmlfn_d\u03c6(d7, d9));
    }

    @Override
    double getErrorEstimate(double d, double d2) {
        return Math.abs(d) < 0.08726646259971647 && Math.abs(d2) < 0.7853981633974483 ? 0.0 : Double.NaN;
    }

    @Immutable
    static final class Spherical
    extends TransverseMercator {
        private static final long serialVersionUID = 8903592710452235162L;

        protected Spherical(Parameters parameters) {
            super(parameters);
            parameters.ensureSpherical();
        }

        @Override
        final boolean isSpherical() {
            return true;
        }

        @Override
        protected void transform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
            double d = this.rollLongitude(dArray[n]);
            double d2 = dArray[n + 1];
            double d3 = Math.cos(d2) * Math.sin(d);
            d2 = Math.atan2(Math.tan(d2), Math.cos(d));
            d = 0.5 * Math.log((1.0 + d3) / (1.0 - d3));
            assert (this.checkTransform(dArray, n, dArray2, n2, d, d2));
            dArray2[n2] = d;
            dArray2[n2 + 1] = d2;
        }

        private boolean checkTransform(double[] dArray, int n, double[] dArray2, int n2, double d, double d2) throws ProjectionException {
            double d3 = dArray[n];
            if (Math.abs(d3) < 0.08726646259971647) {
                super.transform(dArray, n, dArray2, n2);
                return Assertions.checkTransform(dArray2, n2, d, d2);
            }
            return true;
        }

        @Override
        protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
            double d = dArray[n];
            double d2 = dArray[n + 1];
            double d3 = Math.sinh(d);
            double d4 = Math.cos(d2);
            d2 = Math.copySign(Math.asin(Math.sqrt((1.0 - d4 * d4) / (1.0 + d3 * d3))), d2);
            d = this.unrollLongitude(Math.atan2(d3, d4));
            assert (this.checkInverseTransform(dArray, n, dArray2, n2, d, d2));
            dArray2[n2] = d;
            dArray2[n2 + 1] = d2;
        }

        private boolean checkInverseTransform(double[] dArray, int n, double[] dArray2, int n2, double d, double d2) throws ProjectionException {
            if (Math.abs(d) < 0.08726646259971647) {
                super.inverseTransform(dArray, n, dArray2, n2);
                return Assertions.checkInverseTransform(dArray2, n2, d, d2);
            }
            return true;
        }

        @Override
        public Matrix derivative(Point2D point2D) throws ProjectionException {
            double d = this.rollLongitude(point2D.getX());
            double d2 = point2D.getY();
            double d3 = Math.sin(d);
            double d4 = Math.cos(d);
            double d5 = Math.sin(d2);
            double d6 = Math.cos(d2);
            double d7 = d5 / d6;
            double d8 = d4 * d4 + d7 * d7;
            double d9 = d6 * d3;
            d9 = d9 * d9 - 1.0;
            Matrix2 matrix2 = new Matrix2(-(d6 * d4) / d9, d5 * d3 / d9, d7 * d3 / d8, d4 / (d6 * d6 * d8));
            assert (Assertions.checkDerivative(matrix2, super.derivative(point2D)));
            return matrix2;
        }
    }

    protected static class Parameters
    extends UnitaryProjection.Parameters {
        private static final long serialVersionUID = -1689301305119562861L;

        public Parameters(ParameterDescriptorGroup parameterDescriptorGroup, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
            super(parameterDescriptorGroup, parameterValueGroup);
        }

        private int getZone(double d, double d2) {
            double d3 = Math.abs(360.0 / d2);
            double d4 = d - 0.5 * d2;
            d4 = Math.toDegrees(this.centralMeridian) - d4;
            d4 = Math.floor(d4 / d2 + 1.0E-6);
            d4 -= d3 * Math.floor(d4 / d3);
            return (int)d4 + 1;
        }

        private double getCentralMedirian(double d, double d2) {
            double d3 = d + (double)(this.getZone(d, d2) - 1) * d2;
            d3 -= 360.0 * Math.floor((d3 + 180.0) / 360.0);
            return d3;
        }

        public int getZone() throws IllegalStateException {
            if (this.scaleFactor == 0.9996 && this.falseEasting == 500000.0) {
                return this.getZone(-177.0, 6.0);
            }
            if (this.scaleFactor == 0.9999 && this.falseEasting == 304800.0) {
                return this.getZone(-52.5, -3.0);
            }
            throw new IllegalStateException(Errors.format((int)225));
        }

        public double getCentralMeridian() throws IllegalStateException {
            if (this.scaleFactor == 0.9996 && this.falseEasting == 500000.0) {
                return this.getCentralMedirian(-177.0, 6.0);
            }
            if (this.scaleFactor == 0.9999 && this.falseEasting == 304800.0) {
                return this.getCentralMedirian(-52.5, -3.0);
            }
            throw new IllegalStateException(Errors.format((int)225));
        }
    }
}

