/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import javax.measure.quantity.Length;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.MathTransformDecorator;
import org.geotoolkit.parameter.Parameters;
import org.geotoolkit.referencing.operation.MathTransformProvider;
import org.geotoolkit.referencing.operation.provider.EllipsoidToGeocentric;
import org.geotoolkit.referencing.operation.transform.GeocentricTransform;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;

@Immutable
public class GeocentricToEllipsoid
extends MathTransformProvider {
    private static final long serialVersionUID = 8459294628751497567L;
    public static final ParameterDescriptor<Double> SEMI_MAJOR = EllipsoidToGeocentric.SEMI_MAJOR;
    public static final ParameterDescriptor<Double> SEMI_MINOR = EllipsoidToGeocentric.SEMI_MINOR;
    public static final ParameterDescriptor<Integer> DIM = EllipsoidToGeocentric.DIM;
    public static final ParameterDescriptorGroup PARAMETERS = EllipsoidToGeocentric.createDescriptorGroup("Geocentric_To_Ellipsoid");
    private final GeocentricToEllipsoid complement;

    public GeocentricToEllipsoid() {
        super(3, 3, PARAMETERS);
        this.complement = new GeocentricToEllipsoid(this);
    }

    private GeocentricToEllipsoid(GeocentricToEllipsoid geocentricToEllipsoid) {
        super(3, 2, PARAMETERS);
        this.complement = geocentricToEllipsoid;
    }

    @Override
    public MathTransform createMathTransform(ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        double d = Parameters.doubleValue(SEMI_MAJOR, parameterValueGroup);
        double d2 = Parameters.doubleValue(SEMI_MINOR, parameterValueGroup);
        int n = EllipsoidToGeocentric.dimension(parameterValueGroup);
        MathTransform mathTransform = GeocentricTransform.create(d, d2, (Unit<Length>)SI.METRE, n != 2);
        try {
            mathTransform = mathTransform.inverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new AssertionError((Object)noninvertibleTransformException);
        }
        if (n != this.targetDimension) {
            mathTransform = new MathTransformDecorator(mathTransform, this.complement);
        }
        return mathTransform;
    }
}

