/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.Identifiers;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.operation.projection.Mercator;
import org.geotoolkit.referencing.operation.provider.IdentifierCode;
import org.geotoolkit.referencing.operation.provider.MapProjection;
import org.geotoolkit.referencing.operation.provider.Mercator1SP;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform2D;

@Immutable
public class Mercator2SP
extends MapProjection {
    private static final long serialVersionUID = 6356028352681135786L;
    public static final ParameterDescriptor<Double> CENTRAL_MERIDIAN = Mercator1SP.CENTRAL_MERIDIAN;
    public static final ParameterDescriptor<Double> LATITUDE_OF_ORIGIN = Identifiers.LATITUDE_OF_ORIGIN.select("latitude_of_origin", "Latitude_Of_Origin", "Latitude of natural origin", "NatOriginLat");
    public static final ParameterDescriptor<Double> STANDARD_PARALLEL = Identifiers.STANDARD_PARALLEL_1.select(true, "standard_parallel_1", "Standard_Parallel_1", "Latitude of 1st standard parallel");
    public static final ParameterDescriptor<Double> FALSE_EASTING = Mercator1SP.FALSE_EASTING;
    public static final ParameterDescriptor<Double> FALSE_NORTHING = Mercator1SP.FALSE_NORTHING;
    public static final ParameterDescriptorGroup PARAMETERS = Identifiers.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier(Citations.OGC, "Mercator_2SP"), new NamedIdentifier((Citation)Citations.EPSG, "Mercator (variant B)"), new NamedIdentifier((Citation)Citations.EPSG, "Mercator (2SP)"), new IdentifierCode((Citation)Citations.EPSG, 9805), new NamedIdentifier(Citations.ESRI, "Mercator"), Mercator2SP.sameNameAs(Citations.GEOTIFF, (GeneralParameterDescriptor)Mercator1SP.PARAMETERS), Mercator2SP.sameNameAs(Citations.GEOTOOLKIT, (GeneralParameterDescriptor)Mercator1SP.PARAMETERS)}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, ROLL_LONGITUDE, STANDARD_PARALLEL, LATITUDE_OF_ORIGIN, CENTRAL_MERIDIAN, FALSE_EASTING, FALSE_NORTHING});

    public Mercator2SP() {
        super(PARAMETERS);
    }

    public Class<CylindricalProjection> getOperationType() {
        return CylindricalProjection.class;
    }

    @Override
    protected MathTransform2D createMathTransform(ParameterValueGroup parameterValueGroup) {
        return Mercator.create(this.getParameters(), parameterValueGroup);
    }
}

