/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.Identifiers;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.operation.projection.Mercator;
import org.geotoolkit.referencing.operation.provider.IdentifierCode;
import org.geotoolkit.referencing.operation.provider.MapProjection;
import org.geotoolkit.referencing.operation.provider.Mercator1SP;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform2D;

@Immutable
public class MillerCylindrical
extends MapProjection {
    private static final long serialVersionUID = -7682370461334391883L;
    public static final ParameterDescriptor<Double> LONGITUDE_OF_CENTRE = Identifiers.CENTRAL_MERIDIAN.select("longitude_of_center", "ProjCenterLong");
    public static final ParameterDescriptor<Double> LATITUDE_OF_CENTRE = Identifiers.LATITUDE_OF_ORIGIN.select(false, "latitude_of_center", "ProjCenterLat");
    public static final ParameterDescriptor<Double> FALSE_EASTING = Mercator1SP.FALSE_EASTING;
    public static final ParameterDescriptor<Double> FALSE_NORTHING = Mercator1SP.FALSE_NORTHING;
    public static final ParameterDescriptorGroup PARAMETERS = Identifiers.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier(Citations.OGC, "Miller_Cylindrical"), new NamedIdentifier(Citations.GEOTIFF, "CT_MillerCylindrical"), new IdentifierCode(Citations.GEOTIFF, 20)}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, ROLL_LONGITUDE, LATITUDE_OF_CENTRE, LONGITUDE_OF_CENTRE, FALSE_EASTING, FALSE_NORTHING});

    public MillerCylindrical() {
        super(PARAMETERS);
    }

    public Class<CylindricalProjection> getOperationType() {
        return CylindricalProjection.class;
    }

    @Override
    protected MathTransform2D createMathTransform(ParameterValueGroup parameterValueGroup) {
        return Mercator.create(this.getParameters(), parameterValueGroup);
    }
}

