/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.Identifiers;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.operation.provider.IdentifierCode;
import org.geotoolkit.referencing.operation.provider.MapProjection;
import org.geotoolkit.resources.Vocabulary;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform2D;

@Immutable
public class ObliqueMercator
extends MapProjection {
    private static final long serialVersionUID = 201776686002266891L;
    public static final ParameterDescriptor<Double> LONGITUDE_OF_CENTRE = Identifiers.CENTRAL_MERIDIAN.select("longitude_of_center", "Longitude_Of_Center", "Longitude of projection centre", "CenterLong");
    public static final ParameterDescriptor<Double> LATITUDE_OF_CENTRE = Identifiers.LATITUDE_OF_ORIGIN.select("latitude_of_center", "Latitude_Of_Center", "Latitude of projection centre", "CenterLat");
    public static final ParameterDescriptor<Double> AZIMUTH = Identifiers.AZIMUTH.select("Azimuth of initial line");
    public static final ParameterDescriptor<Double> RECTIFIED_GRID_ANGLE = Identifiers.RECTIFIED_GRID_ANGLE;
    public static final ParameterDescriptor<Double> SCALE_FACTOR = Identifiers.SCALE_FACTOR.select("Scale factor on initial line", "ScaleAtCenter");
    public static final ParameterDescriptor<Double> FALSE_EASTING = Identifiers.FALSE_EASTING.select("Easting at projection centre", "FalseEasting");
    public static final ParameterDescriptor<Double> FALSE_NORTHING = Identifiers.FALSE_NORTHING.select("Northing at projection centre", "FalseNorthing");
    public static final ParameterDescriptorGroup PARAMETERS = Identifiers.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier(Citations.OGC, "Oblique_Mercator"), new NamedIdentifier((Citation)Citations.EPSG, "Hotine Oblique Mercator (variant B)"), new NamedIdentifier((Citation)Citations.EPSG, "Oblique Mercator"), new NamedIdentifier((Citation)Citations.EPSG, "Rectified Skew Orthomorphic (RSO)"), new IdentifierCode((Citation)Citations.EPSG, 9815), new NamedIdentifier(Citations.GEOTIFF, "CT_ObliqueMercator"), new IdentifierCode(Citations.GEOTIFF, 3), new NamedIdentifier(Citations.ESRI, "Hotine_Oblique_Mercator_Azimuth_Center"), new NamedIdentifier(Citations.ESRI, "Rectified_Skew_Orthomorphic_Center"), new NamedIdentifier(Citations.GEOTOOLKIT, Vocabulary.formatInternational((int)211))}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, ROLL_LONGITUDE, LONGITUDE_OF_CENTRE, LATITUDE_OF_CENTRE, AZIMUTH, RECTIFIED_GRID_ANGLE, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

    public ObliqueMercator() {
        super(PARAMETERS);
    }

    ObliqueMercator(ParameterDescriptorGroup parameterDescriptorGroup) {
        super(parameterDescriptorGroup);
    }

    public Class<CylindricalProjection> getOperationType() {
        return CylindricalProjection.class;
    }

    @Override
    protected MathTransform2D createMathTransform(ParameterValueGroup parameterValueGroup) {
        return org.geotoolkit.referencing.operation.projection.ObliqueMercator.create(this.getParameters(), parameterValueGroup);
    }

    @Immutable
    public static class TwoPoint
    extends ObliqueMercator {
        private static final long serialVersionUID = 7124258885016543889L;
        public static final ParameterDescriptor<Double> LAT_OF_1ST_POINT = Identifiers.LAT_OF_1ST_POINT;
        public static final ParameterDescriptor<Double> LONG_OF_1ST_POINT = Identifiers.LONG_OF_1ST_POINT;
        public static final ParameterDescriptor<Double> LAT_OF_2ND_POINT = Identifiers.LAT_OF_2ND_POINT;
        public static final ParameterDescriptor<Double> LONG_OF_2ND_POINT = Identifiers.LONG_OF_2ND_POINT;
        public static final ParameterDescriptorGroup PARAMETERS = Identifiers.createDescriptorGroup((ReferenceIdentifier[])new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Hotine_Oblique_Mercator_Two_Point_Center"), TwoPoint.sameNameAs(Citations.GEOTOOLKIT, (GeneralParameterDescriptor)PARAMETERS)}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, ROLL_LONGITUDE, LAT_OF_1ST_POINT, LONG_OF_1ST_POINT, LAT_OF_2ND_POINT, LONG_OF_2ND_POINT, LATITUDE_OF_CENTRE, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public TwoPoint() {
            super(PARAMETERS);
        }
    }
}

