/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.Identifiers;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.operation.provider.IdentifierCode;
import org.geotoolkit.referencing.operation.provider.Mercator1SP;
import org.geotoolkit.referencing.operation.provider.Stereographic;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.MathTransform2D;

@Immutable
public class PolarStereographic
extends Stereographic {
    private static final long serialVersionUID = 9124091259039220308L;
    public static final ParameterDescriptor<Double> CENTRAL_MERIDIAN = Identifiers.CENTRAL_MERIDIAN.select("central_meridian", "Central_Meridian", "Longitude of natural origin", "StraightVertPoleLong");
    public static final ParameterDescriptor<Double> LATITUDE_OF_ORIGIN = Mercator1SP.LATITUDE_OF_ORIGIN;
    public static final ParameterDescriptorGroup PARAMETERS = Identifiers.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier(Citations.OGC, "Polar_Stereographic"), new NamedIdentifier((Citation)Citations.EPSG, "Polar Stereographic (variant A)"), new IdentifierCode((Citation)Citations.EPSG, 9810), new NamedIdentifier(Citations.GEOTIFF, "CT_PolarStereographic"), new IdentifierCode(Citations.GEOTIFF, 15), PolarStereographic.sameNameAs(Citations.GEOTOOLKIT, (GeneralParameterDescriptor)Stereographic.PARAMETERS)}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, ROLL_LONGITUDE, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

    public PolarStereographic() {
        super(PARAMETERS);
    }

    PolarStereographic(ParameterDescriptorGroup parameterDescriptorGroup) {
        super(parameterDescriptorGroup);
    }

    @Override
    protected MathTransform2D createMathTransform(ParameterValueGroup parameterValueGroup) {
        return org.geotoolkit.referencing.operation.projection.PolarStereographic.create(this.getParameters(), parameterValueGroup);
    }

    @Immutable
    public static class South
    extends PolarStereographic {
        private static final long serialVersionUID = 6537800238416448564L;
        public static final ParameterDescriptor<Double> STANDARD_PARALLEL = Identifiers.STANDARD_PARALLEL_1.select(false, -90.0, new String[]{"standard_parallel_1", "Standard_Parallel_1", "Latitude of standard parallel"});
        public static final ParameterDescriptorGroup PARAMETERS = Identifiers.createDescriptorGroup((ReferenceIdentifier[])new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Stereographic_South_Pole"), South.sameNameAs(Citations.GEOTOOLKIT, (GeneralParameterDescriptor)PARAMETERS)}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, ROLL_LONGITUDE, CENTRAL_MERIDIAN, STANDARD_PARALLEL, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public South() {
            super(PARAMETERS);
        }
    }

    @Immutable
    public static class North
    extends PolarStereographic {
        private static final long serialVersionUID = 657493908431273866L;
        public static final ParameterDescriptor<Double> STANDARD_PARALLEL = Identifiers.STANDARD_PARALLEL_1.select(false, 90.0, new String[]{"standard_parallel_1", "Standard_Parallel_1", "Latitude of standard parallel"});
        public static final ParameterDescriptorGroup PARAMETERS = Identifiers.createDescriptorGroup((ReferenceIdentifier[])new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Stereographic_North_Pole"), North.sameNameAs(Citations.GEOTOOLKIT, (GeneralParameterDescriptor)PARAMETERS)}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, ROLL_LONGITUDE, CENTRAL_MERIDIAN, STANDARD_PARALLEL, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public North() {
            super(PARAMETERS);
        }
    }

    @Immutable
    public static class VariantB
    extends PolarStereographic {
        private static final long serialVersionUID = 5188231050523249971L;
        public static final ParameterDescriptor<Double> CENTRAL_MERIDIAN = Identifiers.CENTRAL_MERIDIAN.select("central_meridian", "Longitude_Of_Origin", "Longitude of origin", "StraightVertPoleLong");
        public static final ParameterDescriptor<Double> STANDARD_PARALLEL = North.STANDARD_PARALLEL;
        public static final ParameterDescriptorGroup PARAMETERS = Identifiers.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier((Citation)Citations.EPSG, "Polar Stereographic (variant B)"), new IdentifierCode((Citation)Citations.EPSG, 9829), VariantB.sameNameAs(Citations.GEOTOOLKIT, (GeneralParameterDescriptor)PARAMETERS)}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, ROLL_LONGITUDE, CENTRAL_MERIDIAN, STANDARD_PARALLEL, FALSE_EASTING, FALSE_NORTHING});

        public VariantB() {
            super(PARAMETERS);
        }
    }
}

