/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.Identifiers;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.operation.provider.IdentifierCode;
import org.geotoolkit.referencing.operation.provider.MapProjection;
import org.geotoolkit.referencing.operation.provider.Mercator1SP;
import org.geotoolkit.referencing.operation.provider.Mercator2SP;
import org.geotoolkit.resources.Vocabulary;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform2D;

@Immutable
public class TransverseMercator
extends MapProjection {
    private static final long serialVersionUID = -3386587506686432398L;
    public static final ParameterDescriptor<Double> CENTRAL_MERIDIAN = Mercator1SP.CENTRAL_MERIDIAN;
    public static final ParameterDescriptor<Double> LATITUDE_OF_ORIGIN = Mercator2SP.LATITUDE_OF_ORIGIN;
    public static final ParameterDescriptor<Double> SCALE_FACTOR = Mercator1SP.SCALE_FACTOR;
    public static final ParameterDescriptor<Double> FALSE_EASTING = Mercator1SP.FALSE_EASTING;
    public static final ParameterDescriptor<Double> FALSE_NORTHING = Mercator1SP.FALSE_NORTHING;
    public static final ParameterDescriptorGroup PARAMETERS = TransverseMercator.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier(Citations.OGC, "Transverse_Mercator"), new NamedIdentifier(Citations.ESRI, "Transverse_Mercator"), new NamedIdentifier(Citations.ESRI, "Gauss_Kruger"), new NamedIdentifier((Citation)Citations.EPSG, "Transverse Mercator"), new NamedIdentifier((Citation)Citations.EPSG, "Gauss-Kruger"), new NamedIdentifier((Citation)Citations.EPSG, "Gauss-Boaga"), new NamedIdentifier((Citation)Citations.EPSG, "TM"), new IdentifierCode((Citation)Citations.EPSG, 9807), new NamedIdentifier(Citations.GEOTIFF, "CT_TransverseMercator"), new IdentifierCode(Citations.GEOTIFF, 1), new NamedIdentifier(Citations.GEOTOOLKIT, Vocabulary.formatInternational((int)303))});

    static ParameterDescriptorGroup createDescriptorGroup(ReferenceIdentifier[] referenceIdentifierArray) {
        return Identifiers.createDescriptorGroup(referenceIdentifierArray, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, ROLL_LONGITUDE, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});
    }

    public TransverseMercator() {
        super(PARAMETERS);
    }

    TransverseMercator(ParameterDescriptorGroup parameterDescriptorGroup) {
        super(parameterDescriptorGroup);
    }

    public Class<CylindricalProjection> getOperationType() {
        return CylindricalProjection.class;
    }

    @Override
    protected MathTransform2D createMathTransform(ParameterValueGroup parameterValueGroup) {
        return org.geotoolkit.referencing.operation.projection.TransverseMercator.create(this.getParameters(), parameterValueGroup);
    }

    @Immutable
    public static class SouthOrientated
    extends TransverseMercator {
        private static final long serialVersionUID = -5938929136350638347L;
        public static final ParameterDescriptorGroup PARAMETERS = SouthOrientated.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier((Citation)Citations.EPSG, "Transverse Mercator (South Orientated)"), new IdentifierCode((Citation)Citations.EPSG, 9808), SouthOrientated.sameNameAs(Citations.GEOTOOLKIT, (GeneralParameterDescriptor)PARAMETERS)});

        public SouthOrientated() {
            super(PARAMETERS);
        }
    }
}

