/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import net.jcip.annotations.Immutable;
import org.geotoolkit.parameter.FloatParameter;
import org.geotoolkit.parameter.ParameterGroup;
import org.geotoolkit.referencing.datum.BursaWolfParameters;
import org.geotoolkit.referencing.operation.provider.CoordinateFrameRotation;
import org.geotoolkit.referencing.operation.provider.GeocentricTranslation;
import org.geotoolkit.referencing.operation.provider.PositionVector7Param;
import org.geotoolkit.referencing.operation.transform.ProjectiveTransform;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.Matrix;

@Immutable
public class GeocentricAffineTransform
extends ProjectiveTransform {
    private static final long serialVersionUID = -3588786513463289242L;
    private static final byte TRANSLATION = 1;
    private static final byte SEVEN_PARAM = 2;
    private static final byte FRAME_ROTATION = 3;
    private final byte type;

    public GeocentricAffineTransform(BursaWolfParameters bursaWolfParameters) {
        super(bursaWolfParameters.getAffineTransform());
        this.type = (byte)(bursaWolfParameters.isTranslation() ? 1 : 2);
    }

    public GeocentricAffineTransform(BursaWolfParameters bursaWolfParameters, ParameterDescriptorGroup parameterDescriptorGroup) {
        super(bursaWolfParameters.getAffineTransform());
        String string;
        String string2;
        if (GeocentricTranslation.PARAMETERS.equals(parameterDescriptorGroup)) {
            if (bursaWolfParameters.isTranslation()) {
                this.type = 1;
                return;
            }
            string2 = "ex|ey|ez|ppm";
            string = "\u22600";
        } else {
            if (PositionVector7Param.PARAMETERS.equals(parameterDescriptorGroup)) {
                this.type = (byte)2;
                return;
            }
            if (CoordinateFrameRotation.PARAMETERS.equals(parameterDescriptorGroup)) {
                this.type = (byte)3;
                return;
            }
            string2 = "descriptor";
            string = parameterDescriptorGroup != null ? parameterDescriptorGroup.getName().getCode() : null;
        }
        throw new IllegalArgumentException(Errors.format((int)12, (Object)string2, (Object)string));
    }

    private GeocentricAffineTransform(Matrix matrix, byte by) {
        super(matrix);
        this.type = by;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        switch (this.type) {
            case 1: {
                return GeocentricTranslation.PARAMETERS;
            }
            case 2: {
                return PositionVector7Param.PARAMETERS;
            }
            case 3: {
                return CoordinateFrameRotation.PARAMETERS;
            }
        }
        throw new AssertionError(this.type);
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        BursaWolfParameters bursaWolfParameters = new BursaWolfParameters(null);
        bursaWolfParameters.setAffineTransform(this.getMatrix(), Double.POSITIVE_INFINITY);
        GeneralParameterValue[] generalParameterValueArray = new FloatParameter[this.type == 1 ? 3 : 7];
        switch (this.type) {
            default: {
                throw new AssertionError(this.type);
            }
            case 3: {
                bursaWolfParameters.ex = -bursaWolfParameters.ex;
                bursaWolfParameters.ey = -bursaWolfParameters.ey;
                bursaWolfParameters.ez = -bursaWolfParameters.ez;
            }
            case 2: {
                generalParameterValueArray[3] = new FloatParameter(PositionVector7Param.EX, bursaWolfParameters.ex);
                generalParameterValueArray[4] = new FloatParameter(PositionVector7Param.EY, bursaWolfParameters.ey);
                generalParameterValueArray[5] = new FloatParameter(PositionVector7Param.EZ, bursaWolfParameters.ez);
                generalParameterValueArray[6] = new FloatParameter(PositionVector7Param.PPM, bursaWolfParameters.ppm);
            }
            case 1: 
        }
        generalParameterValueArray[0] = new FloatParameter(PositionVector7Param.DX, bursaWolfParameters.dx);
        generalParameterValueArray[1] = new FloatParameter(PositionVector7Param.DY, bursaWolfParameters.dy);
        generalParameterValueArray[2] = new FloatParameter(PositionVector7Param.DZ, bursaWolfParameters.dz);
        return new ParameterGroup(this.getParameterDescriptors(), generalParameterValueArray);
    }

    @Override
    final GeocentricAffineTransform createInverse(Matrix matrix) {
        return new GeocentricAffineTransform(matrix, this.type);
    }

    @Override
    protected int computeHashCode() {
        return Utilities.hash((int)this.type, (int)super.computeHashCode());
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (comparisonMode != ComparisonMode.STRICT) {
            return GeocentricAffineTransform.equals(this, object, comparisonMode);
        }
        if (super.equals(object, comparisonMode)) {
            GeocentricAffineTransform geocentricAffineTransform = (GeocentricAffineTransform)object;
            return this.type == geocentricAffineTransform.type;
        }
        return false;
    }
}

