/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.Callable;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.Cache;
import org.geotoolkit.util.converter.Classes;
import org.opengis.util.FactoryException;

class GridLoader {
    private static final Cache<GridLoader, GridLoader> CACHE = new Cache(4, 0L, true);
    private final Class<? extends GridLoader> type;
    Object longitudeGridFile;
    Object latitudeGridFile;

    GridLoader(Class<? extends GridLoader> clazz) {
        this.type = clazz;
    }

    protected static <T extends GridLoader> T loadIfAbsent(Class<T> clazz, Object object, Object object2, Callable<T> callable) throws FactoryException {
        GridLoader gridLoader;
        GridLoader gridLoader2 = new GridLoader(clazz);
        gridLoader2.longitudeGridFile = object;
        gridLoader2.latitudeGridFile = object2;
        try {
            gridLoader = (GridLoader)CACHE.getOrCreate((Object)gridLoader2, callable);
        }
        catch (FactoryException factoryException) {
            throw factoryException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new UndeclaredThrowableException(exception);
        }
        assert (gridLoader2.equals(gridLoader));
        return (T)((GridLoader)clazz.cast(gridLoader));
    }

    public final boolean equals(Object object) {
        if (object instanceof GridLoader) {
            GridLoader gridLoader = (GridLoader)object;
            return Utilities.equals(this.type, gridLoader.type) && Utilities.equals((Object)this.longitudeGridFile, (Object)gridLoader.longitudeGridFile) && Utilities.equals((Object)this.latitudeGridFile, (Object)gridLoader.latitudeGridFile);
        }
        return false;
    }

    public final int hashCode() {
        return Utilities.hash((Object)this.longitudeGridFile, (int)Utilities.hash((Object)this.latitudeGridFile, (int)this.type.hashCode()));
    }

    public final String toString() {
        return Classes.getShortName(this.type) + "[\"" + this.longitudeGridFile + "\",\"" + this.latitudeGridFile + "\"]";
    }
}

