/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferFloat;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.internal.io.Installation;
import org.geotoolkit.io.ContentFormatException;
import org.geotoolkit.referencing.factory.OptionalFactoryOperationException;
import org.geotoolkit.referencing.operation.transform.GridLoader;
import org.geotoolkit.resources.Descriptions;
import org.geotoolkit.resources.Errors;
import org.opengis.util.FactoryException;

final class NTv2Loader
extends GridLoader {
    private static final int HEADER_KEY_LENGTH = 8;
    private static final int RECORD_LENGTH = 16;
    private static final Map<String, Class<?>> TYPES;
    private final Map<String, Comparable<?>> header = new LinkedHashMap();
    private int width;
    private int height;
    private double xmin;
    private double ymin;
    private double dx;
    private double dy;
    private float[] latitudeShift;
    private float[] longitudeShift;
    private float[] latitudePrecision;
    private float[] longitudePrecision;
    private transient DataBuffer buffer;

    NTv2Loader() {
        super(NTv2Loader.class);
    }

    public static NTv2Loader loadIfAbsent(final String string, final boolean bl) throws FactoryException {
        return NTv2Loader.loadIfAbsent(NTv2Loader.class, string, string, new Callable<NTv2Loader>(){

            @Override
            public NTv2Loader call() throws FactoryException {
                return NTv2Loader.load(string, bl);
            }
        });
    }

    private static NTv2Loader load(String string, boolean bl) throws FactoryException {
        NTv2Loader nTv2Loader = new NTv2Loader();
        try {
            Object object;
            nTv2Loader.latitudeGridFile = object = Installation.NTv2.toFileOrURL(NTv2Loader.class, string);
            nTv2Loader.longitudeGridFile = object;
            nTv2Loader.load(bl);
            nTv2Loader.longitudeGridFile = string;
            nTv2Loader.latitudeGridFile = string;
        }
        catch (IOException iOException) {
            String string2 = Errors.format((int)31, (Object)string);
            string2 = string2 + ' ' + Descriptions.format((int)7, (Object)"NTv2", (Object)Installation.NTv2.directory(true), (Object)"geotk-setup");
            FactoryException factoryException = iOException instanceof FileNotFoundException ? new OptionalFactoryOperationException(string2, iOException) : new FactoryException(string2, (Throwable)iOException);
            throw factoryException;
        }
        return nTv2Loader;
    }

    private void load(boolean bl) throws IOException {
        ReadableByteChannel readableByteChannel = Channels.newChannel(IOUtilities.open((Object)this.latitudeGridFile));
        ByteBuffer byteBuffer = ByteBuffer.allocate(4096);
        byteBuffer.limit(32);
        NTv2Loader.readFully(readableByteChannel, byteBuffer);
        int n = byteBuffer.getInt(8) + byteBuffer.getInt(24);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int n2 = byteBuffer.getInt(8) + byteBuffer.getInt(24);
        if (n2 < n) {
            n = n2;
        } else {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        }
        int n3 = (n - 2) * 16;
        byteBuffer.rewind().limit(n3);
        NTv2Loader.readFully(readableByteChannel, byteBuffer);
        byte[] byArray = byteBuffer.array();
        Charset charset = Charset.forName("US-ASCII");
        for (int i = 0; i < n3; i += 16) {
            String string = new String(byArray, i, 8, charset).trim().toUpperCase(Locale.US);
            Class<?> clazz = TYPES.get(string);
            if (clazz == null) continue;
            int n4 = i + 8;
            Object object = clazz.equals(Double.class) ? Double.valueOf(byteBuffer.getDouble(n4)) : (clazz.equals(Integer.class) ? Integer.valueOf(byteBuffer.getInt(n4)) : new String(byArray, n4, 8, charset).trim());
            string = string.intern();
            this.header.put(string, (Comparable<?>)object);
        }
        this.ymin = this.getDouble("S_LAT");
        double d = this.getDouble("N_LAT");
        this.xmin = this.getDouble("E_LONG");
        double d2 = this.getDouble("W_LONG");
        this.dy = this.getDouble("LAT_INC");
        this.dx = this.getDouble("LONG_INC");
        this.width = (int)Math.round((d2 - this.xmin) / this.dx) + 1;
        this.height = (int)Math.round((d - this.ymin) / this.dy) + 1;
        this.xmin /= 3600.0;
        this.ymin /= 3600.0;
        this.dx /= 3600.0;
        this.dy /= 3600.0;
        int n5 = this.getInteger("GS_COUNT");
        this.latitudeShift = new float[n5];
        this.longitudeShift = new float[n5];
        if (bl) {
            this.latitudePrecision = new float[n5];
            this.longitudePrecision = new float[n5];
        }
        int n6 = byteBuffer.capacity() / 16;
        int n7 = 0;
        while (n7 < n5) {
            byteBuffer.rewind().limit(Math.min(n6, n5 - n7) * 16);
            NTv2Loader.readFully(readableByteChannel, byteBuffer);
            byteBuffer.rewind();
            while (byteBuffer.hasRemaining()) {
                this.latitudeShift[n7] = byteBuffer.getFloat();
                this.longitudeShift[n7] = byteBuffer.getFloat();
                if (bl) {
                    this.latitudePrecision[n7] = byteBuffer.getFloat();
                    this.longitudePrecision[n7] = byteBuffer.getFloat();
                } else {
                    byteBuffer.position(byteBuffer.position() + 8);
                }
                ++n7;
            }
        }
        byteBuffer.rewind().limit(16);
        NTv2Loader.readFully(readableByteChannel, byteBuffer);
        readableByteChannel.close();
        String string = new String(byArray, 0, 8, charset).trim().toUpperCase(Locale.US);
        if (!string.equals("END")) {
            throw new IOException(Errors.format((int)66));
        }
    }

    private static void readFully(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) throws IOException {
        while (byteBuffer.hasRemaining()) {
            if (readableByteChannel.read(byteBuffer) >= 0) continue;
            readableByteChannel.close();
            throw new EOFException(Errors.format((int)61));
        }
    }

    final String getString(String string) {
        Comparable<?> comparable = this.header.get(string);
        return comparable != null ? comparable.toString() : null;
    }

    private final double getDouble(String string) throws ContentFormatException {
        Comparable<?> comparable = this.header.get(string);
        if (comparable instanceof Number) {
            return ((Number)((Object)comparable)).doubleValue();
        }
        throw new ContentFormatException(Errors.format((int)163, (Object)string));
    }

    private final int getInteger(String string) throws ContentFormatException {
        Comparable<?> comparable = this.header.get(string);
        if (comparable instanceof Number) {
            return ((Number)((Object)comparable)).intValue();
        }
        throw new ContentFormatException(Errors.format((int)163, (Object)string));
    }

    public final Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public final Rectangle2D getArea() {
        return new Rectangle2D.Double(this.xmin, this.ymin, this.dx * (double)this.width, this.dy * (double)this.height);
    }

    public final synchronized DataBuffer getDataBuffer() {
        if (this.buffer == null) {
            boolean bl = this.latitudePrecision != null;
            float[][] fArrayArray = new float[bl ? 4 : 2][];
            if (bl) {
                fArrayArray[3] = this.latitudePrecision;
                fArrayArray[2] = this.longitudeShift;
            }
            fArrayArray[1] = this.latitudeShift;
            fArrayArray[0] = this.longitudeShift;
            this.buffer = new DataBufferFloat(fArrayArray, this.width * this.height);
        }
        return this.buffer;
    }

    static {
        HashMap hashMap = new HashMap(32);
        hashMap.put("NUM_OREC", Integer.class);
        hashMap.put("NUM_SREC", Integer.class);
        hashMap.put("NUM_FILE", Integer.class);
        hashMap.put("GS_TYPE", String.class);
        hashMap.put("VERSION", String.class);
        hashMap.put("SYSTEM_F", String.class);
        hashMap.put("SYSTEM_T", String.class);
        hashMap.put("MAJOR_F", Double.class);
        hashMap.put("MINOR_F", Double.class);
        hashMap.put("MAJOR_T", Double.class);
        hashMap.put("MINOR_T", Double.class);
        hashMap.put("SUB_NAME", String.class);
        hashMap.put("PARENT", String.class);
        hashMap.put("CREATED", String.class);
        hashMap.put("UPDATED", String.class);
        hashMap.put("S_LAT", Double.class);
        hashMap.put("N_LAT", Double.class);
        hashMap.put("E_LONG", Double.class);
        hashMap.put("W_LONG", Double.class);
        hashMap.put("LAT_INC", Double.class);
        hashMap.put("LONG_INC", Double.class);
        hashMap.put("GS_COUNT", Integer.class);
        TYPES = hashMap;
    }
}

