/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.gephi.graph.LegacyMapHelper;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.project.api.Workspace;
import org.gephi.project.spi.WorkspaceXMLPersistenceProvider;

public class LegacyDataPersistenceProvider
implements WorkspaceXMLPersistenceProvider {
    private static final String ELEMENT_DATA = "Data";
    private static final String ELEMENT_NODEDATA = "nodedata";
    private static final String ELEMENT_NODEDATA_POSITION = "position";
    private static final String ELEMENT_NODEDATA_COLOR = "color";
    private static final String ELEMENT_NODEDATA_SIZE = "size";
    private static final String ELEMENT_EDGEDATA = "edgedata";
    private static final String ELEMENT_EDGEDATA_COLOR = "color";

    public void writeXML(XMLStreamWriter writer, Workspace workspace) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void readXML(XMLStreamReader reader, Workspace workspace) {
        GraphModel model = (GraphModel)workspace.getLookup().lookup(GraphModel.class);
        if (model == null) {
            throw new IllegalStateException("The graphModel is null");
        }
        LegacyMapHelper helper = (LegacyMapHelper)workspace.getLookup().lookup(LegacyMapHelper.class);
        if (helper != null) {
            try {
                this.readData(reader, model, helper);
            }
            catch (XMLStreamException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public String getIdentifier() {
        return ELEMENT_DATA;
    }

    public void readData(XMLStreamReader reader, GraphModel graphModel, LegacyMapHelper helper) throws XMLStreamException {
        Graph graph = graphModel.getGraph();
        boolean end = false;
        while (reader.hasNext() && !end) {
            Integer eventType = reader.next();
            if (eventType.equals(1)) {
                String name = reader.getLocalName();
                if (ELEMENT_NODEDATA.equalsIgnoreCase(name)) {
                    Node node = graph.getNode((Object)helper.preToIdMap.get(reader.getAttributeValue(null, "nodepre")));
                    this.readNodeData(reader, node);
                    continue;
                }
                if (!ELEMENT_EDGEDATA.equalsIgnoreCase(name)) continue;
                Node source = graph.getNode((Object)helper.preToIdMap.get(reader.getAttributeValue(null, "sourcepre")));
                Node target = graph.getNode((Object)helper.preToIdMap.get(reader.getAttributeValue(null, "targetpre")));
                Edge edge = graph.getEdge(source, target, 0);
                this.readEdgeData(reader, edge);
                continue;
            }
            if (!eventType.equals(2) || !ELEMENT_DATA.equalsIgnoreCase(reader.getLocalName())) continue;
            end = true;
        }
    }

    public void readNodeData(XMLStreamReader reader, Node node) throws XMLStreamException {
        boolean end = false;
        while (reader.hasNext() && !end) {
            Integer eventType = reader.next();
            if (eventType.equals(1)) {
                String name = reader.getLocalName();
                if (ELEMENT_NODEDATA_POSITION.equalsIgnoreCase(name)) {
                    node.setX(Float.parseFloat(reader.getAttributeValue(null, "x")));
                    node.setY(Float.parseFloat(reader.getAttributeValue(null, "y")));
                    node.setZ(Float.parseFloat(reader.getAttributeValue(null, "z")));
                    continue;
                }
                if ("color".equalsIgnoreCase(name)) {
                    node.setR(Float.parseFloat(reader.getAttributeValue(null, "r")));
                    node.setG(Float.parseFloat(reader.getAttributeValue(null, "g")));
                    node.setB(Float.parseFloat(reader.getAttributeValue(null, "b")));
                    node.setAlpha(Float.parseFloat(reader.getAttributeValue(null, "a")));
                    continue;
                }
                if (!ELEMENT_NODEDATA_SIZE.equalsIgnoreCase(name)) continue;
                node.setSize(Float.parseFloat(reader.getAttributeValue(0)));
                continue;
            }
            if (!eventType.equals(2) || !ELEMENT_NODEDATA.equalsIgnoreCase(reader.getLocalName())) continue;
            end = true;
        }
    }

    public void readEdgeData(XMLStreamReader reader, Edge edge) throws XMLStreamException {
        boolean end = false;
        while (reader.hasNext() && !end) {
            Integer eventType = reader.next();
            if (eventType.equals(1)) {
                String name = reader.getLocalName();
                if (!"color".equalsIgnoreCase(name)) continue;
                float r = Float.parseFloat(reader.getAttributeValue(null, "r"));
                float g = Float.parseFloat(reader.getAttributeValue(null, "g"));
                float b = Float.parseFloat(reader.getAttributeValue(null, "b"));
                float alpha = Float.parseFloat(reader.getAttributeValue(null, "a"));
                if (r < 0.0f || g < 0.0f || b < 0.0f) {
                    b = 0.0f;
                    g = 0.0f;
                    r = 0.0f;
                    alpha = 0.0f;
                }
                edge.setR(r);
                edge.setG(g);
                edge.setB(b);
                edge.setAlpha(alpha);
                continue;
            }
            if (!eventType.equals(2) || !ELEMENT_EDGEDATA.equalsIgnoreCase(reader.getLocalName())) continue;
            end = true;
        }
    }
}

