/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.gephi.graph.LegacyMapHelper;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphFactory;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.project.api.Workspace;
import org.gephi.project.spi.WorkspaceXMLPersistenceProvider;

public class LegacyGraphPersistenceProvider
implements WorkspaceXMLPersistenceProvider {
    private static final String ELEMENT_DHNS = "Dhns";
    private static final String ELEMENT_EDGES = "Edges";
    private static final String ELEMENT_TREESTRUCTURE = "TreeStructure";
    private static final String ELEMENT_TREESTRUCTURE_NODE = "Node";

    public void writeXML(XMLStreamWriter writer, Workspace workspace) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void readXML(XMLStreamReader reader, Workspace workspace) {
        GraphModel model = LegacyMapHelper.getGraphModel(workspace);
        LegacyMapHelper mapHelper = LegacyMapHelper.get(workspace);
        try {
            this.readDhns(reader, model, mapHelper);
            workspace.add((Object)model);
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getIdentifier() {
        return ELEMENT_DHNS;
    }

    private void readDhns(XMLStreamReader reader, GraphModel graphModel, LegacyMapHelper mapHelper) throws XMLStreamException {
        boolean end = false;
        while (reader.hasNext() && !end) {
            Integer eventType = reader.next();
            if (eventType.equals(1)) {
                String name = reader.getLocalName();
                if (ELEMENT_TREESTRUCTURE.equalsIgnoreCase(name)) {
                    this.readTreeStructure(reader, graphModel, graphModel.factory(), mapHelper);
                    continue;
                }
                if (!ELEMENT_EDGES.equalsIgnoreCase(name)) continue;
                this.readEdges(reader, graphModel, graphModel.factory(), mapHelper);
                continue;
            }
            if (!eventType.equals(2) || !ELEMENT_DHNS.equalsIgnoreCase(reader.getLocalName())) continue;
            end = true;
        }
    }

    public void readTreeStructure(XMLStreamReader reader, GraphModel graphModel, GraphFactory factory, LegacyMapHelper mapHelper) throws XMLStreamException {
        Graph graph = graphModel.getGraph();
        boolean end = false;
        while (reader.hasNext() && !end) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    String name = reader.getLocalName();
                    if (!ELEMENT_TREESTRUCTURE_NODE.equalsIgnoreCase(name)) break;
                    String id = reader.getAttributeValue(null, "id");
                    String pre = reader.getAttributeValue(null, "pre");
                    mapHelper.preToIdMap.put(pre, id);
                    Node node = factory.newNode((Object)id);
                    graph.addNode(node);
                    break;
                }
                case 2: {
                    if (!ELEMENT_TREESTRUCTURE.equalsIgnoreCase(reader.getLocalName())) break;
                    end = true;
                }
            }
        }
    }

    public void readEdges(XMLStreamReader reader, GraphModel graphModel, GraphFactory factory, LegacyMapHelper mapHelper) throws XMLStreamException {
        Graph graph = graphModel.getGraph();
        boolean end = false;
        while (reader.hasNext() && !end) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    String source = null;
                    String target = null;
                    String id = null;
                    Boolean directed = false;
                    Float weight = Float.valueOf(0.0f);
                    for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        String attName = reader.getAttributeName(i).getLocalPart();
                        if ("id".equalsIgnoreCase(attName)) {
                            id = reader.getAttributeValue(i);
                            continue;
                        }
                        if ("source".equalsIgnoreCase(attName)) {
                            source = reader.getAttributeValue(i);
                            continue;
                        }
                        if ("target".equalsIgnoreCase(attName)) {
                            target = reader.getAttributeValue(i);
                            continue;
                        }
                        if ("directed".equalsIgnoreCase(attName)) {
                            directed = Boolean.parseBoolean(reader.getAttributeValue(i));
                            continue;
                        }
                        if (!"weight".equalsIgnoreCase(attName)) continue;
                        weight = Float.valueOf(Float.parseFloat(reader.getAttributeValue(i)));
                    }
                    if (source == null || target == null || id == null) {
                        throw new IllegalArgumentException("source, target or id cannot be null");
                    }
                    Node srcNode = graph.getNode((Object)mapHelper.preToIdMap.get(source));
                    Node destNode = graph.getNode((Object)mapHelper.preToIdMap.get(target));
                    Edge edge = factory.newEdge((Object)id, srcNode, destNode, 0, weight.doubleValue(), directed.booleanValue());
                    graph.addEdge(edge);
                    break;
                }
                case 2: {
                    if (!ELEMENT_EDGES.equalsIgnoreCase(reader.getLocalName())) break;
                    end = true;
                }
            }
        }
    }
}

