/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.cli;

import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.util.LocalStringManagerImpl;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.flashlight.cli.MonitoringConfig;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="disable-monitoring")
@Scoped(value=PerLookup.class)
@I18n(value="disable.monitoring")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class DisableMonitoring
implements AdminCommand {
    private MonitoringService ms;
    @Inject
    private Target targetService;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(optional=true)
    private String modules;
    private final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DisableMonitoring.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            this.ms = this.targetService.getConfig(this.target).getMonitoringService();
        }
        catch (Exception e) {
            report.setMessage(this.localStrings.getLocalString("target.service.exception", "Encountered exception trying to locate the MonitoringService element in the target ({0}) configuration: {1}", new Object[]{this.target, e.getMessage()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            if (this.modules == null || this.modules.length() < 1) {
                boolean enabled = Boolean.parseBoolean(this.ms.getMonitoringEnabled());
                if (enabled) {
                    MonitoringConfig.setMonitoringEnabled(this.ms, "false", report);
                } else {
                    report.setMessage(this.localStrings.getLocalString("disable.monitoring.alreadyfalse", "monitoring-enabled is already set to false"));
                }
            } else {
                String[] strArr;
                for (String moduleName : strArr = this.modules.split(":")) {
                    if (moduleName.length() <= 0) continue;
                    MonitoringConfig.setMonitoringLevel(this.ms, moduleName, "OFF", report);
                }
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            report.setMessage(this.localStrings.getLocalString("disable.monitoring.exception", "Encountered exception during disabling monitoring {0}", new Object[]{e.getMessage()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }
}

