/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.npn;

import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLEngine;
import org.glassfish.grizzly.npn.ClientSideNegotiator;
import org.glassfish.grizzly.npn.ServerSideNegotiator;

public class NegotiationSupport {
    private static final ConcurrentHashMap<SSLEngine, ServerSideNegotiator> serverSideNegotiators = new ConcurrentHashMap();
    private static final ConcurrentHashMap<SSLEngine, ClientSideNegotiator> clientSideNegotiators = new ConcurrentHashMap();

    public static void addNegotiator(SSLEngine engine, ServerSideNegotiator serverSideNegotiator) {
        serverSideNegotiators.putIfAbsent(engine, serverSideNegotiator);
    }

    public static void addNegotiator(SSLEngine engine, ClientSideNegotiator clientSideNegotiator) {
        clientSideNegotiators.putIfAbsent(engine, clientSideNegotiator);
    }

    public static ClientSideNegotiator removeClientNegotiator(SSLEngine engine) {
        return clientSideNegotiators.remove(engine);
    }

    public static ServerSideNegotiator removeServerNegotiator(SSLEngine engine) {
        return serverSideNegotiators.remove(engine);
    }

    public static ServerSideNegotiator getServerSideNegotiator(SSLEngine engine) {
        return serverSideNegotiators.get(engine);
    }

    public static ClientSideNegotiator getClientSideNegotiator(SSLEngine engine) {
        return clientSideNegotiators.get(engine);
    }
}

