/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedHashSet;
import sun.security.ssl.Debug;
import sun.security.ssl.ExtensionType;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HelloExtension;

final class NextProtocolNegotiationExtension
extends HelloExtension {
    private static final LinkedHashSet<String> EMPTY = new LinkedHashSet(0);
    public static final int EXTENSION_ID = 13172;
    LinkedHashSet<String> protocols = EMPTY;
    private byte[] outData;

    public NextProtocolNegotiationExtension(ExtensionType extensionType) {
        super(extensionType);
    }

    @Override
    int length() {
        return 4 + this.outData.length;
    }

    @Override
    void send(HandshakeOutStream handshakeOutStream) throws IOException {
        handshakeOutStream.putInt16(13172);
        handshakeOutStream.putInt16(this.outData.length);
        handshakeOutStream.write(this.outData);
    }

    @Override
    public String toString() {
        return String.format("Next Protocol Negotiation Extension [0x%x/%d], protocols: %s, compressed data: %s", 13172, 13172, this.protocols.toString(), Debug.toString((byte[])this.outData));
    }

    static Builder builder() {
        return new Builder();
    }

    static /* synthetic */ byte[] access$102(NextProtocolNegotiationExtension x0, byte[] x1) {
        x0.outData = x1;
        return x1;
    }

    static final class Builder {
        private static final byte[] EMPTY_DATA = new byte[0];
        public static final String ISO_8859_1 = "ISO-8859-1";
        private final NextProtocolNegotiationExtension extension = new NextProtocolNegotiationExtension(ExtensionType.get(13172));
        private HandshakeInStream in;
        private int len;

        Builder() {
        }

        Builder protocols(LinkedHashSet<String> protocols) {
            this.extension.protocols = protocols;
            return this;
        }

        Builder handshakeIn(HandshakeInStream in, int len) {
            this.in = in;
            this.len = len;
            return this;
        }

        NextProtocolNegotiationExtension build() throws IOException {
            if (this.in != null) {
                if (this.len > 0) {
                    byte[] protocol;
                    this.extension.protocols = new LinkedHashSet();
                    for (int read = 0; read != this.len; read += protocol.length + 1) {
                        protocol = new byte[this.in.getInt8()];
                        this.in.read(protocol);
                        this.extension.protocols.add(new String(protocol, ISO_8859_1));
                    }
                } else {
                    this.extension.protocols = EMPTY;
                }
            } else if (this.extension.protocols.isEmpty()) {
                NextProtocolNegotiationExtension.access$102(this.extension, EMPTY_DATA);
            } else {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                for (String protocol : this.extension.protocols) {
                    out.write(protocol.length());
                    out.write(protocol.getBytes(ISO_8859_1));
                }
                NextProtocolNegotiationExtension.access$102(this.extension, out.toByteArray());
            }
            return this.extension;
        }
    }
}

