/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.DecimalMax;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class DecimalMaxValidatorForNumber
implements ConstraintValidator<DecimalMax, Number> {
    private static final Log log = LoggerFactory.make();
    private BigDecimal maxValue;
    private boolean inclusive;

    @Override
    public void initialize(DecimalMax maxValue) {
        try {
            this.maxValue = new BigDecimal(maxValue.value());
        }
        catch (NumberFormatException nfe) {
            throw log.getInvalidBigDecimalFormatException(maxValue.value(), nfe);
        }
        this.inclusive = maxValue.inclusive();
    }

    @Override
    public boolean isValid(Number value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return true;
        }
        int comparisonResult = value instanceof BigDecimal ? ((BigDecimal)value).compareTo(this.maxValue) : (value instanceof BigInteger ? new BigDecimal((BigInteger)value).compareTo(this.maxValue) : (value instanceof Long ? BigDecimal.valueOf(value.longValue()).compareTo(this.maxValue) : BigDecimal.valueOf(value.doubleValue()).compareTo(this.maxValue)));
        return this.inclusive ? comparisonResult <= 0 : comparisonResult < 0;
    }
}

